/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustBalanceCheckModel<T> {
    private String groupKey;
    private BigDecimal debitSum = BigDecimal.ZERO;
    private BigDecimal creditSum = BigDecimal.ZERO;
    private List<T> rows = new ArrayList<T>(10);
    private BigDecimal diffSum;
    private boolean isDefualtBalance = Boolean.TRUE;
    private String[] computeFormula;

    public AdjustBalanceCheckModel(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public BigDecimal getDebitSum() {
        return this.debitSum;
    }

    public void setDebitSum(BigDecimal debitSum) {
        this.debitSum = this.debitSum.add(debitSum);
    }

    public BigDecimal getCreditSum() {
        return this.creditSum;
    }

    public void setCreditSum(BigDecimal creditSum) {
        this.creditSum = this.creditSum.add(creditSum);
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public boolean isDataBalance(BigDecimal configBalance) {
        return this.isDefualtBalance && this.getDiffSum().abs().compareTo(configBalance) == 0;
    }

    public BigDecimal getDiffSum() {
        if (this.diffSum == null) {
            this.diffSum = this.getDebitSum().subtract(this.getCreditSum());
        }
        return this.diffSum;
    }

    public String getDebitSubCreditWithAbs() {
        return this.getDiffSum().stripTrailingZeros().toPlainString();
    }

    public void setDefualtBalance(boolean defualtBalance) {
        this.isDefualtBalance = defualtBalance;
    }

    public boolean isDefualtBalance() {
        return this.isDefualtBalance;
    }

    public String getComputeFormula() {
        if (this.computeFormula == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)this.computeFormula[0]) || StringUtils.isEmpty((CharSequence)this.computeFormula[1])) {
            return this.computeFormula[0] + this.computeFormula[1] + "=" + this.getDiffSum().stripTrailingZeros().toPlainString();
        }
        return "(" + this.computeFormula[0] + ")-(" + this.computeFormula[1] + ")=" + this.getDiffSum().stripTrailingZeros().toPlainString();
    }

    public void addDebitFormula(String str) {
        if (this.computeFormula == null) {
            this.computeFormula = new String[]{"", ""};
        }
        this.computeFormula[0] = StringUtils.isNotEmpty((CharSequence)this.computeFormula[0]) ? this.computeFormula[0] + "+" + str : str;
    }

    public void addCreditFormula(String str) {
        if (this.computeFormula == null) {
            this.computeFormula = new String[]{"", ""};
        }
        this.computeFormula[1] = StringUtils.isNotEmpty((CharSequence)this.computeFormula[1]) ? this.computeFormula[1] + "+" + str : str;
    }
}

