/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustDataCheckBM;
import kd.fi.bcm.business.adjust.model.IAdjustDataModel;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;

public class AdjustCheckBalanceContext {
    private long modelId = 0L;
    private SchemeContext schemeContext;
    private Map<String, Long> numberMap;
    protected Map<Object, DynamicObject> sourceAdjusts;
    protected Map<Object, DynamicObject> linkAdjusts;
    private Map<Long, Table<String, String, List<IAdjustDataModel>>> adjustDatas;
    private Map<Long, List<DynamicObject>> adjustDataDys;

    public AdjustCheckBalanceContext(Long modelid, List<DynamicObject> adjusts, List<DynamicObject> adjustDatas) {
        this.initData(modelid);
        adjusts.forEach(adjustDy -> {
            this.numberMap.put(adjustDy.getString("number"), adjustDy.getLong("id"));
            boolean isLinkAdjust = ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(adjustDy.getString("entrysource")) || ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(adjustDy.getString("entrysource"));
            (isLinkAdjust ? this.linkAdjusts : this.sourceAdjusts).put(adjustDy.getLong("id"), (DynamicObject)adjustDy);
        });
        this.adjustDataDys = adjustDatas.stream().collect(Collectors.groupingBy(adjustData -> AdjustmentServiceHelper.transformDimid(adjustData, "adjust")));
        this.initAdjustData(this.adjustDataDys);
    }

    protected final void initData(long modelId) {
        this.modelId = modelId;
        this.numberMap = new HashMap<String, Long>(16);
        this.sourceAdjusts = new HashMap<Object, DynamicObject>(16);
        this.linkAdjusts = new HashMap<Object, DynamicObject>(16);
        this.adjustDatas = new HashMap<Long, Table<String, String, List<IAdjustDataModel>>>(16);
        this.adjustDataDys = new HashMap<Long, List<DynamicObject>>(16);
        this.schemeContext = SchemeContext.getInstance(modelId);
    }

    public Map<Long, List<DynamicObject>> getAdjustDataDys() {
        return this.adjustDataDys;
    }

    public final void initAdjustData(Map<Long, List<DynamicObject>> adjustDataMap) {
        adjustDataMap.forEach((adjustid, adjustDataList) -> {
            if (this.adjustDatas.get(adjustid) != null) {
                this.adjustDatas.get(adjustid).clear();
            }
            adjustDataList.forEach(adjustData -> this.setGroupMap((long)adjustid, (DynamicObject)adjustData, this.adjustDatas));
        });
    }

    private void setGroupMap(long adjustid, DynamicObject adjustData, Map<Long, Table<String, String, List<IAdjustDataModel>>> tableMap) {
        tableMap.computeIfAbsent(adjustid, a -> HashBasedTable.create());
        AdjustDataCheckBM adjustDataCheckBM = new AdjustDataCheckBM(adjustData, this.schemeContext);
        if (tableMap.get(adjustid).get((Object)adjustDataCheckBM.getGroumnum(), (Object)adjustDataCheckBM.getSeq()) == null) {
            tableMap.get(adjustid).put((Object)adjustDataCheckBM.getGroumnum(), (Object)adjustDataCheckBM.getSeq(), new ArrayList(10));
        }
        ((List)tableMap.get(adjustid).get((Object)adjustDataCheckBM.getGroumnum(), (Object)adjustDataCheckBM.getSeq())).add(adjustDataCheckBM);
    }

    public Long getIdByNumber(String adjustnumber) {
        return this.numberMap.get(adjustnumber);
    }

    public long getModelId() {
        return this.modelId;
    }

    public Map<Long, Table<String, String, List<IAdjustDataModel>>> getAdjustDatas() {
        return this.adjustDatas;
    }

    public Map<String, Long> getNumberMap() {
        return this.numberMap;
    }
}

