/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.CacheLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.scheme.AdjustCvtCurrencyScheme;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustEntryConfig {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AdjustEntryConfig.class);
    private static final String OP_GETLOSSCARRYSCHEMES = "getLossCarrySchemes";
    private static final String OP_ADJUSTCVTCURRENCYSCHEMES = "getAdjustCvtCurrencySchemes";
    private static final ThreadLocal<AdjustEntryConfig> current = ThreadLocal.withInitial(AdjustEntryConfig::new);
    private List<LossCarryScheme> lossCarrySchemes;
    private List<AdjustCvtCurrencyScheme> adjustCvtCurrencySchemes;

    public static AdjustEntryConfig get() {
        return current.get();
    }

    public List<LossCarryScheme> getLossCarrySchemes(Long modelId) {
        if (this.lossCarrySchemes == null) {
            if (modelId == null || modelId == 0L) {
                return Collections.emptyList();
            }
            String packKey = AdjustEntryConfig.packKey(OP_GETLOSSCARRYSCHEMES, modelId, null, null, null);
            this.lossCarrySchemes = (List)AdjustEntryConfig.get(packKey, () -> {
                String selectFieldStr = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_annualaccount").getAllFields().keySet());
                DynamicObject[] lossCarrySchemeDy = BusinessDataServiceHelper.load((String)"bcm_annualaccount", (String)selectFieldStr, (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray(), (String)"dseq asc");
                if (lossCarrySchemeDy == null || lossCarrySchemeDy.length == 0) {
                    return Collections.emptyList();
                }
                SchemeContext sctx = new SchemeContext(modelId);
                sctx.removeIf(p -> p.isIssys() && !"Account".equals(p.getNumber()) && !"MultiGAAP".equals(p.getNumber()) && !"ChangeType".equals(p.getNumber()));
                return Arrays.stream(lossCarrySchemeDy).map(LossCarryScheme::new).collect(Collectors.toList());
            });
        }
        return this.lossCarrySchemes;
    }

    public List<AdjustCvtCurrencyScheme> getAdjustCvtCurrencySchemes(Long modelId) {
        if (this.adjustCvtCurrencySchemes == null) {
            if (modelId == null || modelId == 0L) {
                return Collections.emptyList();
            }
            String packKey = AdjustEntryConfig.packKey(OP_ADJUSTCVTCURRENCYSCHEMES, modelId, null, null, null);
            this.adjustCvtCurrencySchemes = (List)AdjustEntryConfig.get(packKey, () -> {
                List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entrycvtcurrency", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}).toArray(), null, (int)-1);
                DynamicObject[] col = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_entrycvtcurrency"));
                if (col == null || col.length == 0) {
                    return Collections.emptyList();
                }
                return Arrays.stream(col).map(AdjustCvtCurrencyScheme::new).collect(Collectors.toList());
            });
        }
        return this.adjustCvtCurrencySchemes;
    }

    public void clearAdjustCvtCurrencySchemeCache(Long modelId) {
        AdjustEntryConfig.clearCache(AdjustEntryConfig.packKey(OP_ADJUSTCVTCURRENCYSCHEMES, modelId, null, null, null));
    }

    public void clearLossCarrySchemeCache(Long modelId) {
        AdjustEntryConfig.clearCache(AdjustEntryConfig.packKey(OP_GETLOSSCARRYSCHEMES, modelId, null, null, null));
    }

    private static void clearCache(String packKey) {
        AppCacheServiceHelper.remove(packKey);
    }

    private static <T> T get(String packKey, CacheLoader<T> loader) {
        String cacheStr = (String)AppCacheServiceHelper.get(packKey);
        if (cacheStr == null) {
            Object t = loader.load();
            if (t != null) {
                AppCacheServiceHelper.put(packKey, SerializationUtils.serializeToBase64((Object)t));
            }
            return (T)t;
        }
        try {
            return (T)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        }
        catch (Throwable t) {
            log.error("AdjustEntryConfig.deSerializeFromBase64 error:", t);
            AdjustEntryConfig.clearCache(packKey);
            return (T)loader.load();
        }
    }

    public static String packKey(String sign, Long modelId, Long sceneId, Long fyId, Long periodId) {
        return new StringJoiner("_").add(sign).add(BCMStringUtil.getStringValue((Object)modelId, (String)"")).add(BCMStringUtil.getStringValue((Object)sceneId, (String)"")).add(BCMStringUtil.getStringValue((Object)fyId, (String)"")).add(BCMStringUtil.getStringValue((Object)periodId, (String)"")).toString();
    }
}

