/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustErrorCatcher {
    private static final String SERVICE_KEY = "AdjustErrorCatchService";
    private final IPageCache cache;
    private boolean isSuccess = true;
    private final IFormView iFormView;
    private Map<String, Set<Integer>> errorMap;

    public AdjustErrorCatcher(IFormView iFormView) {
        this.cache = iFormView.getPageCache();
        this.iFormView = iFormView;
        String cacheStr = this.cache.get(SERVICE_KEY);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            this.errorMap = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheStr);
        }
        if (this.errorMap == null) {
            this.errorMap = new LinkedHashMap<String, Set<Integer>>(16);
        }
    }

    public void collectMsg(int row, String msg) {
        if (msg == null) {
            return;
        }
        this.errorMap.computeIfAbsent(msg, k -> new HashSet(16)).add(row);
    }

    public void collectErrorMsg(int row, String msg) {
        if (msg == null) {
            return;
        }
        this.errorMap.computeIfAbsent(msg, k -> new HashSet(16)).add(row);
        this.isSuccess = false;
    }

    public void pull() {
        if (this.errorMap != null) {
            this.cache.put(SERVICE_KEY, ObjectSerialUtil.toByteSerialized(this.errorMap));
        }
    }

    public boolean needThrow() {
        return !this.errorMap.isEmpty();
    }

    public void throwError() {
        if (this.needThrow()) {
            StringBuilder sb = new StringBuilder();
            this.errorMap.forEach((errorMsg, rowList) -> {
                if (rowList.contains(-1)) {
                    sb.append((String)errorMsg);
                } else {
                    sb.append(ResManager.loadKDString((String)"\u7b2c", (String)"AdjustErrorCatcher_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    for (Integer index : rowList) {
                        index = index + 1;
                        sb.append(index).append(',');
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(ResManager.loadKDString((String)"\u884c \uff1a ", (String)"AdjustErrorCatcher_2", (String)"fi-bcm-business", (Object[])new Object[0])).append((String)errorMsg);
                }
                sb.append('\n');
            });
            this.clear();
            if (sb.length() != 0) {
                if (this.isSuccess()) {
                    if (sb.length() > 1000) {
                        this.iFormView.showMessage(sb.toString());
                    } else {
                        this.iFormView.showTipNotification(sb.toString(), Integer.valueOf(3000));
                    }
                } else {
                    throw new KDBizException(sb.toString());
                }
            }
        }
    }

    public void clear() {
        this.errorMap.clear();
        this.cache.remove(SERVICE_KEY);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }
}

