/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustModel
extends DynaEntityObject {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustModel.class);
    public static final String MODEL = "model";
    protected static final String ENTITY = "entity";
    public static final String SCENARIO = "scenario";
    public static final String PERIOD = "period";
    public static final String YEAR = "year";
    protected static final String MODIFY_TIME = "modifytime";
    protected static final String CREATOR = "creator";
    protected static final String MODIFIER = "modifier";
    protected static final String DESCRIPTION = "description";
    public static final String STATUS = "status";
    protected static final String CHECK_STATUS = "checkstatus";
    protected static final String PROCESS = "process";
    protected static final String AUDIT_TRAIL = "audittrail";
    protected static final String BUSINESS_TYPE = "bussnesstype";
    protected static final String CREATE_TIME = "createTime";
    public static final String ENTRY_SOURCE = "entrysource";
    protected static final String INPUT_MODE = "inputmode";
    public static final String JOURNAL_TYPE = "journaltype";
    protected static final String BALANCE_TYPE = "balancetype";
    protected static final String CHECK_RECORD = "checkrecord";
    protected static final String IS_CONTINUOUS = "iscontinuous";
    protected static final String COMMEMB_ENTRY = "commembentry";
    protected static final String MODIFY_STATUS = "modifystatus";
    protected static final String UPDATE_CYCLE = "updatecycle";
    protected static final String MULTIPLE_CURRENCY = "multiplecurrency";
    protected static final String LINKAGE_LINK_SOURCE = "linkagelinksource";
    protected static final String SPREAD_MEMB_ENTRY = "spreadmembentry";
    protected static final String CVT_BEFORE_CURRENCY = "cvtbeforecurrency";
    protected static final String SUBMITTER = "submitter";
    protected static final String SUBMIT_TIME = "submittime";
    protected static final String CANCEL_SUBMITTER = "cancelsubmitter";
    protected static final String CANCEL_SUBMIT_TIME = "cancelsubmittime";
    protected static final String RATIFIER = "ratifier";
    protected static final String RATIFY_TIME = "ratifytime";
    protected static final String REVIEWER = "reviewer";
    protected static final String REVIEW_TIME = "reviewtime";
    protected static final String CALLBACKER = "callbacker";
    protected static final String CALLBACK_TIME = "callbacktime";
    public static final String MERGENODE = "bcm_mergenode";
    public static final String LINKCREATETYPE = "linkcreatetype";
    public static final String SOURCETYPE = "sourcetype";
    public static final String BELONGORGLIST = "belongorglist";
    public static final String DEBIT = "debit";
    public static final String CREDIT = "credit";
    private static final long serialVersionUID = 1L;
    private final HashMap<String, Object> userdefineProMap = new HashMap();

    public void setProperty(String key, Object value) {
        this.userdefineProMap.put(key, value);
    }

    @Override
    public Object get(Object key) {
        Object val = super.get(key);
        if (val == null) {
            val = this.userdefineProMap.get(key);
        }
        return val;
    }

    public AdjustModel() {
        this.put(COMMEMB_ENTRY, (Object)new ArrayList(10));
        this.put(SPREAD_MEMB_ENTRY, (Object)new ArrayList(10));
        this.userdefineProMap.put(BELONGORGLIST, new ArrayList(10));
        this.setDataEntityNumber("bcm_rptadjust");
    }

    public List<Long> getBelongOrgList() {
        return (List)this.userdefineProMap.get(BELONGORGLIST);
    }

    public boolean isMergeinspread() {
        return this.getSpreadDimensionEntries().stream().anyMatch(entry -> MERGENODE.equals(entry.getNumber()));
    }

    public List<CommDimensionEntry> getCommDimensionEntries() {
        return (List)this.get(COMMEMB_ENTRY);
    }

    public void addCommDimensionEntries(CommDimensionEntry e) {
        this.getCommDimensionEntries().add(e);
    }

    public List<SpreadDimensionEntry> getSpreadDimensionEntries() {
        return (List)this.get(SPREAD_MEMB_ENTRY);
    }

    public void addSpreadDimensionEntries(SpreadDimensionEntry e) {
        this.getSpreadDimensionEntries().add(e);
    }

    public void setModelId(long modelId) {
        this.put(MODEL, (Object)modelId);
    }

    public long getModelId() {
        return (Long)this.get(MODEL);
    }

    public void setScenarioId(long id) {
        this.put(SCENARIO, (Object)id);
    }

    public long getScenarioId() {
        return this.get(SCENARIO, 0L);
    }

    public void setYearId(long id) {
        this.put(YEAR, (Object)id);
    }

    public long getYearId() {
        return this.get(YEAR, 0L);
    }

    public void setPeriodId(long id) {
        this.put(PERIOD, (Object)id);
    }

    public long getPeriodId() {
        return this.get(PERIOD, 0L);
    }

    public String getData() {
        return (String)this.get("data");
    }

    public void setData(String data) {
        this.put("data", (Object)data);
    }

    public String getSpreadJson() {
        return (String)this.get("spreadJson");
    }

    public void setSpreadJson(String spreadJson) {
        this.put("spreadJson", (Object)spreadJson);
    }

    public void setJournaltype(int journaltype) {
        this.put(JOURNAL_TYPE, (Object)journaltype);
    }

    public int getJournaltype() {
        if (this.get(JOURNAL_TYPE) == null) {
            return 0;
        }
        return (Integer)this.get(JOURNAL_TYPE);
    }

    public void setBalancetype(int balancetype) {
        this.put(BALANCE_TYPE, (Object)balancetype);
    }

    public int getBalancetype() {
        return (Integer)this.get(BALANCE_TYPE);
    }

    public void setStatus(String status) {
        this.put(STATUS, (Object)status);
    }

    public String getStatus() {
        return (String)this.get(STATUS);
    }

    public void setCheckStatus(String checkstatus) {
        this.put(CHECK_STATUS, (Object)checkstatus);
    }

    public String getCheckStatus() {
        return (String)this.get(CHECK_STATUS);
    }

    public void setAudittrail(long id) {
        this.put(AUDIT_TRAIL, (Object)id);
    }

    public long getAudittrail() {
        return (Long)this.get(AUDIT_TRAIL);
    }

    public void setProcess(String process) {
        this.put(PROCESS, (Object)process);
    }

    public String getProcess() {
        return (String)this.get(PROCESS);
    }

    public void setBussnesstype(String bussnesstype) {
        this.put(BUSINESS_TYPE, (Object)bussnesstype);
    }

    public String getBussnesstype() {
        return (String)this.get(BUSINESS_TYPE);
    }

    public void setMultiplecurrency(String multiplecurrency) {
        this.put(MULTIPLE_CURRENCY, (Object)multiplecurrency);
    }

    public String getMultiplecurrency() {
        return StringUtils.isEmpty((CharSequence)((CharSequence)this.get(MULTIPLE_CURRENCY))) ? "0" : (String)this.get(MULTIPLE_CURRENCY);
    }

    public void setUpdatecycle(String updatecycle) {
        this.put(UPDATE_CYCLE, (Object)updatecycle);
    }

    public String getUpdatecycle() {
        return (String)this.get(UPDATE_CYCLE);
    }

    public void setBelongOrg(Long belongOrg) {
        this.put("belongOrg", (Object)belongOrg);
    }

    public Long getBelongOrg() {
        return (Long)this.get("belongOrg");
    }

    public void setInputMode(String inputMode) {
        this.put(INPUT_MODE, (Object)inputMode);
    }

    public String getInputMode() {
        return (String)this.get(INPUT_MODE);
    }

    public void setEntrySource(String entrysource) {
        this.put(ENTRY_SOURCE, (Object)entrysource);
    }

    public String getEntrySource() {
        return (String)this.get(ENTRY_SOURCE);
    }

    public Date getCreateTime() {
        return (Date)this.get(CREATE_TIME);
    }

    public void setCreateTime(Date createTime) {
        this.put(CREATE_TIME, (Object)createTime);
    }

    public Date getModifyTime() {
        return (Date)this.get(MODIFY_TIME);
    }

    public void setModifyTime(Date modifyTime) {
        this.put(MODIFY_TIME, (Object)modifyTime);
    }

    public long getCreatorId() {
        return (Long)this.get(CREATOR);
    }

    public void setCreatorId(long creatorId) {
        this.put(CREATOR, (Object)creatorId);
    }

    public long getModifierId() {
        return (Long)this.get(MODIFIER);
    }

    public void setModifierId(long modifierId) {
        this.put(MODIFIER, (Object)modifierId);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.put(DESCRIPTION, (Object)description);
    }

    public long getMergeId() {
        return this.get(ENTITY) == null ? 0L : (Long)this.get(ENTITY);
    }

    public void setMergeId(long entity) {
        this.put(ENTITY, (Object)entity);
    }

    public void setIsContinuous(String iscontinuous) {
        this.put(IS_CONTINUOUS, (Object)iscontinuous);
    }

    public String getIsContinuous() {
        return (String)this.get(IS_CONTINUOUS);
    }

    public Long getCheckrecordId() {
        return (Long)this.get(CHECK_RECORD);
    }

    public void setCheckrecordId(Long checkrecord) {
        this.put(CHECK_RECORD, (Object)checkrecord);
    }

    public long getCvtBeforeCurrencyId() {
        return this.get(CVT_BEFORE_CURRENCY, 0L);
    }

    public void setCvtBeforeCurrencyId(long cvtBeforeCurrency) {
        this.put(CVT_BEFORE_CURRENCY, (Object)cvtBeforeCurrency);
    }

    public long getTemplateId() {
        return this.get("template", 0L);
    }

    public void setTemplateId(long templateId) {
        this.put("template", (Object)templateId);
    }

    public String getModifyStatus() {
        return this.get(MODIFY_STATUS, "0");
    }

    public void setModifyStatus(String modifyStatus) {
        this.put(MODIFY_STATUS, (Object)modifyStatus);
    }

    public long getLinkagelinksourceId() {
        return this.get(LINKAGE_LINK_SOURCE, 0L);
    }

    public void setLinkagelinksourceId(long linkagelinksourceId) {
        this.put(LINKAGE_LINK_SOURCE, (Object)linkagelinksourceId);
    }

    public long getSubmitterId() {
        return (Long)this.get(SUBMITTER);
    }

    public void setSubmitterId(long submitterId) {
        this.put(SUBMITTER, (Object)submitterId);
    }

    public Date getSubmitTime() {
        return (Date)this.get(SUBMIT_TIME);
    }

    public void setSubmitTime(Date submitTime) {
        this.put(SUBMIT_TIME, (Object)submitTime);
    }

    public long getCancelSubmitterId() {
        return (Long)this.get(CANCEL_SUBMITTER);
    }

    public void setCancelSubmitterId(long cancelSubmitterId) {
        this.put(CANCEL_SUBMITTER, (Object)cancelSubmitterId);
    }

    public Date getCancelSubmitTime() {
        return (Date)this.get(CANCEL_SUBMIT_TIME);
    }

    public void setCancelSubmitTime(Date cancelSubmitTime) {
        this.put(CANCEL_SUBMIT_TIME, (Object)cancelSubmitTime);
    }

    public long getRatifierId() {
        return (Long)this.get(RATIFIER);
    }

    public void setRatifierId(long ratifierId) {
        this.put(RATIFIER, (Object)ratifierId);
    }

    public Date getRatifyTime() {
        return (Date)this.get(RATIFY_TIME);
    }

    public void setRatifyTime(Date ratifyTime) {
        this.put(RATIFY_TIME, (Object)ratifyTime);
    }

    public long getReviewerId() {
        return (Long)this.get(REVIEWER);
    }

    public void setReviewerId(long reviewerId) {
        this.put(REVIEWER, (Object)reviewerId);
    }

    public Date getReviewTime() {
        return (Date)this.get(REVIEW_TIME);
    }

    public void setReviewTime(Date reviewTime) {
        this.put(REVIEW_TIME, (Object)reviewTime);
    }

    public long getCallBackerId() {
        return (Long)this.get(CALLBACKER);
    }

    public void setCallBackerId(long callBackerId) {
        this.put(CALLBACKER, (Object)callBackerId);
    }

    public Date getCallBackTime() {
        return (Date)this.get(CALLBACK_TIME);
    }

    public void setCallBackTime(Date callBackTime) {
        this.put(CALLBACK_TIME, (Object)callBackTime);
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        Predicate<Object> p = t -> t == null;
        this.setId(dyna.getLong("id"));
        this.setName(dyna.getString("name"));
        this.setNumber(dyna.getString("number"));
        this.setModelId(this.defaultIfNull(p, dyna.getDynamicObject(MODEL), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setScenarioId(this.defaultIfNull(p, dyna.getDynamicObject(SCENARIO), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setYearId(this.defaultIfNull(p, dyna.getDynamicObject(YEAR), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setPeriodId(this.defaultIfNull(p, dyna.getDynamicObject(PERIOD), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setAudittrail(this.defaultIfNull(p, dyna.getDynamicObject(AUDIT_TRAIL), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setMergeId(this.defaultIfNull(p, dyna.getDynamicObject(ENTITY), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCreatorId(this.defaultIfNull(p, dyna.getDynamicObject(CREATOR), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setModifierId(this.defaultIfNull(p, dyna.getDynamicObject(MODIFIER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCreateTime(dyna.getDate(CREATE_TIME));
        this.setModifyTime(dyna.getDate(MODIFY_TIME));
        this.setData(dyna.getString("data"));
        this.setSpreadJson(dyna.getString("spreadjson"));
        this.setStatus(dyna.getString(STATUS));
        this.setCheckStatus(dyna.getString(CHECK_STATUS));
        this.setProcess(dyna.getString(PROCESS));
        this.setJournaltype(dyna.getInt(JOURNAL_TYPE));
        this.setBalancetype(dyna.getInt(BALANCE_TYPE));
        this.setDescription(dyna.getString(DESCRIPTION));
        this.setIsContinuous(dyna.getString(IS_CONTINUOUS));
        this.setCheckrecordId(dyna.getLong(CHECK_RECORD));
        this.setEntrySource(this.defaultIfNull(p, dyna.getString(ENTRY_SOURCE), "0", v -> (String)v));
        this.setTemplatecatalog(dyna.getString("templatecatalog_id"));
        this.setMultiplecurrency(StringUtils.isEmpty((CharSequence)dyna.getString(MULTIPLE_CURRENCY)) ? "0" : dyna.getString(MULTIPLE_CURRENCY));
        this.setBussnesstype(dyna.getString(BUSINESS_TYPE));
        this.setSourceType(this.defaultIfNull(p, dyna.getString(SOURCETYPE), ElimRptAdjSourceTypeEnum.AUTO.getValue() + "", v -> (String)v));
        this.setUpdatecycle(dyna.getString(UPDATE_CYCLE));
        this.setBelongOrg(dyna.getLong("belongOrg_id"));
        this.setInputMode(dyna.getString(INPUT_MODE));
        this.setCvtBeforeCurrencyId(this.defaultIfNull(p, dyna.getDynamicObject(CVT_BEFORE_CURRENCY), 0L, v -> ((DynamicObject)v).getLong("id")));
        DynamicObjectCollection entries = dyna.getDynamicObjectCollection(COMMEMB_ENTRY);
        this.getCommDimensionEntries().addAll(new CommDimensionEntry(this).loadDynaObject(entries, () -> this));
        entries = dyna.getDynamicObjectCollection(SPREAD_MEMB_ENTRY);
        this.getSpreadDimensionEntries().addAll(new SpreadDimensionEntry(this).loadDynaObject(entries, () -> this));
        if (dyna.getDynamicObjectType().getProperty(BELONGORGLIST) != null) {
            entries = dyna.getDynamicObjectCollection(BELONGORGLIST);
            entries.forEach(entry -> this.getBelongOrgList().add(entry.getLong("belongorgmem.id")));
        }
        this.setTemplateId(dyna.getLong("template.id"));
        this.setLinkagelinksourceId(dyna.getLong(LINKAGE_LINK_SOURCE));
        this.setModifyStatus(dyna.getString(MODIFY_STATUS));
        this.setSubmitterId(this.defaultIfNull(p, dyna.getDynamicObject(SUBMITTER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setSubmitTime(dyna.getDate(SUBMIT_TIME));
        this.setCancelSubmitterId(this.defaultIfNull(p, dyna.getDynamicObject(CANCEL_SUBMITTER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCancelSubmitTime(dyna.getDate(CANCEL_SUBMIT_TIME));
        this.setRatifierId(this.defaultIfNull(p, dyna.getDynamicObject(RATIFIER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setRatifyTime(dyna.getDate(RATIFY_TIME));
        this.setReviewerId(this.defaultIfNull(p, dyna.getDynamicObject(REVIEWER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setReviewTime(dyna.getDate(REVIEW_TIME));
        this.setCallBackerId(this.defaultIfNull(p, dyna.getDynamicObject(CALLBACKER), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCallBackTime(dyna.getDate(CALLBACK_TIME));
        this.setLinkCreateType(dyna.getString(LINKCREATETYPE));
        DynamicObject copy = BusinessDataServiceHelper.newDynamicObject((String)dyna.getDynamicObjectType().getName());
        for (String field : ((BasedataEntityType)copy.getDynamicObjectType()).getFields().keySet()) {
            if (this.keySet().contains(field)) continue;
            Object val = dyna.get(field);
            if (val instanceof DynamicObject) {
                val = this.defaultIfNull(p, val, 0L, v -> ((DynamicObject)v).getLong("id"));
            }
            this.setProperty(field, val);
        }
    }

    @Override
    public DynamicObject genDynamicObject() {
        DynamicObject dyn = super.genDynamicObject();
        for (Map.Entry<String, Object> entry : this.userdefineProMap.entrySet()) {
            try {
                if (BELONGORGLIST.equals(entry.getKey())) {
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgList((DynamicObject)dyn, (Collection)((List)entry.getValue()), (boolean)true);
                    continue;
                }
                if (entry.getKey().contains("_") || entry.getKey().contains(".")) continue;
                dyn.set(entry.getKey(), entry.getValue());
            }
            catch (Throwable t) {
                LOG.error(entry.getKey() + "_" + entry.getValue(), t);
            }
        }
        return dyn;
    }

    public String getLinkCreateType() {
        return (String)this.get(LINKCREATETYPE);
    }

    public void setLinkCreateType(String linkcreatetype) {
        this.put(LINKCREATETYPE, (Object)linkcreatetype);
    }

    public String getSourceType() {
        return (String)this.get(SOURCETYPE);
    }

    public void setSourceType(String sourceType) {
        this.put(SOURCETYPE, (Object)sourceType);
    }

    public void setTemplatecatalog(String templatecatalog) {
        this.put("templatecatalog", (Object)templatecatalog);
    }

    public String getTemplatecatalog() {
        return (String)this.get("templatecatalog");
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object v, R defaultValue, Function<Object, R> f) {
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    @Override
    public boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || SCENARIO.equals(key) || YEAR.equals(key) || PERIOD.equals(key) || MODEL.equals(key) || PROCESS.equals(key) || AUDIT_TRAIL.equals(key) || COMMEMB_ENTRY.equals(key) || SPREAD_MEMB_ENTRY.equals(key);
    }

    @Override
    public String getCommonDataEntityNumber() {
        return "bcm_rptadjust.commembentry";
    }

    @Override
    public String getSpreadDataEntityNumber() {
        return "bcm_rptadjust.spreadmembentry";
    }

    public boolean isRADJ() {
        return !OrgRelaProcessMembPool.isRelaProcess((String)this.getProcess());
    }
}

