/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.dynamicObjectModel.AdjustLoadTypeEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustOperQueryParam {
    private long modelId;
    private final Set<String> adjustProperty = new HashSet<String>(16);
    private final Set<String> adjustDataProperty = new HashSet<String>(16);
    private final Set<String> extraAdjustProperty = new HashSet<String>(16);
    private final Set<String> extraAdjustDataProperty = new HashSet<String>(16);
    private boolean isBatch;
    private int loadType = 0;
    private AdjustLoadTypeEnum adjustLoadType = AdjustLoadTypeEnum.LoadNoFields;
    private AdjustLoadTypeEnum entryLoadType = AdjustLoadTypeEnum.LoadNoFields;

    public AdjustOperQueryParam(boolean isBatch, int loadType) {
        this.isBatch = isBatch;
        this.loadType = loadType;
    }

    public AdjustOperQueryParam setModelId(long modelId) {
        this.modelId = modelId;
        return this;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void addExtraAdjustField(String adjustField) {
        this.extraAdjustProperty.add(adjustField);
    }

    public void addExtraAdjustDataField(String adjustDataField) {
        this.extraAdjustDataProperty.add(adjustDataField);
    }

    public void addAdjustField(String adjustDataField) {
        this.adjustProperty.add(adjustDataField);
    }

    public boolean hasAdjustField() {
        return !this.adjustProperty.isEmpty();
    }

    public void addEntryField(String adjustDataField) {
        this.adjustDataProperty.add(adjustDataField);
    }

    public boolean hasEntryField() {
        return !this.adjustDataProperty.isEmpty();
    }

    public String getAdjustFieldStr() {
        return String.join((CharSequence)",", this.getAdjustProperty());
    }

    public Set<String> getAdjustProperty() {
        if (CollectionUtils.isEmpty(this.adjustProperty)) {
            if (this.loadType == 3 || this.adjustLoadType == AdjustLoadTypeEnum.DataSetRow) {
                this.adjustProperty.addAll(DynUtils.getDynamicTypeProperties((String)"bcm_rptadjust"));
            } else {
                this.adjustProperty.addAll(EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust").getAllFields().entrySet().stream().filter(p -> StringUtils.isNotEmpty((String)((IDataEntityProperty)p.getValue()).getAlias())).map(Map.Entry::getKey).collect(Collectors.toSet()));
            }
        }
        this.adjustProperty.removeAll(this.extraAdjustProperty);
        return this.adjustProperty;
    }

    public String getEntryFieldStr() {
        return String.join((CharSequence)",", this.getAdjustDataProperty());
    }

    public Set<String> getAdjustDataProperty() {
        if (CollectionUtils.isEmpty(this.adjustDataProperty)) {
            if (this.loadType == 3 || this.entryLoadType == AdjustLoadTypeEnum.DataSetRow) {
                this.adjustDataProperty.addAll(DynUtils.getDynamicTypeProperties((String)"bcm_rptadjustdata"));
            } else {
                this.adjustDataProperty.addAll(EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata").getAllFields().keySet());
            }
        }
        this.adjustDataProperty.removeAll(this.extraAdjustDataProperty);
        return this.adjustDataProperty;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean batch) {
        this.isBatch = batch;
    }

    public int getLoadType() {
        return this.loadType;
    }

    public void setLoadType(int loadType) {
        this.loadType = loadType;
    }

    public void setAdjustLoadType(AdjustLoadTypeEnum adjustLoadType) {
        this.adjustLoadType = adjustLoadType;
    }

    public void setEntryLoadType(AdjustLoadTypeEnum entryLoadType) {
        this.entryLoadType = entryLoadType;
    }

    public AdjustLoadTypeEnum getAdjustLoadType() {
        return this.adjustLoadType;
    }

    public AdjustLoadTypeEnum getEntryLoadType() {
        return this.entryLoadType;
    }
}

