/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.fi.bcm.business.adjust.formula.ICalcLine;

public class CalcLinePool<T extends ICalcLine> {
    private final Map<String, T> calcLine = new LinkedHashMap<String, T>(16);
    private final Map<Long, List<T>> groupCalcLineMap = new LinkedHashMap<Long, List<T>>(16);

    public void add(T line) {
        this.add(0L, line);
    }

    public void add(Long groupId, T line) {
        if (!this.contains(line)) {
            this.calcLine.put(line.getLineId(), line);
            this.groupCalcLineMap.computeIfAbsent(groupId, a -> Lists.newArrayList()).add(line);
        }
    }

    public boolean contains(T line) {
        return this.calcLine.containsKey(line.getLineId());
    }

    public T searchById(String lineId) {
        return (T)((ICalcLine)this.calcLine.get(lineId));
    }

    public List<T> searchByTmpId(Long tmpId) {
        return this.groupCalcLineMap.get(tmpId);
    }

    public void clear() {
        this.calcLine.clear();
    }

    public void forEach(Consumer<T> lineFunc) {
        this.calcLine.values().forEach(lineFunc);
    }

    public boolean isEmpty() {
        return this.calcLine.isEmpty();
    }
}

