/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustBaseEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.ILoader;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class CommDimensionEntry
extends AdjustBaseEntry
implements ILoader<DynamicObjectCollection, List<CommDimensionEntry>, DynaEntityObject> {
    private static final long serialVersionUID = 1L;

    public CommDimensionEntry(DynaEntityObject adjust) {
        super(adjust);
        this.setDataEntityNumber(adjust.getCommonDataEntityNumber());
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        dyna.set("comdimension", (Object)this.getDimension().getId());
        dyna.set("commembid", (Object)(this.getMember() == null ? 0L : this.getMember().getId()));
        if (dyna.getDynamicObjectType().getProperty("comentitysign") != null) {
            dyna.set("comentitysign", (Object)this.getNumber());
        }
        dyna.set("seq", (Object)incrementer.getAndIncrement());
        coll.add((Object)dyna);
        return coll;
    }

    @Override
    public List<CommDimensionEntry> loadDynaObject(DynamicObjectCollection t, Supplier<DynaEntityObject> s) {
        ArrayList<CommDimensionEntry> entries = new ArrayList<CommDimensionEntry>(10);
        long modelId = this.getTemplate().getOrDefault("model", 0L);
        for (DynamicObject o : t) {
            CommDimensionEntry entry = new CommDimensionEntry(s.get());
            entry.setId(o.getLong("id"));
            entry.setSeq(o.getInt("seq"));
            Dimension d = new Dimension();
            DynamicObject dyna = o.getDynamicObject("comdimension");
            this.loadSimpleDynamicObject(d, dyna);
            d.setDataEntityNumber(dyna.getDataEntityType().getName());
            d.setMemberEntityNumber(dyna.getString("membermodel"));
            entry.setDimension(d);
            entry.setMember(this.queryMember(modelId, o.getLong("commembid"), d));
            if (o.getDynamicObjectType().getProperty("comentitysign") != null) {
                if (StringUtils.isEmpty((String)o.getString("comentitysign"))) {
                    entry.setNumber(d.getMemberEntityNumber());
                } else {
                    entry.setNumber(o.getString("comentitysign"));
                }
            }
            entries.add(entry);
        }
        return entries;
    }

    private Member queryMember(long modelId, Long membId, Dimension d) {
        Member m = new Member();
        IDNumberTreeNode commemb = MemberReader.findMemberById((long)modelId, (String)d.getMemberEntityNumber(), (Long)membId);
        if (commemb != IDNumberTreeNode.NotFoundTreeNode) {
            m.setId(commemb.getId());
            m.setName(commemb.getName());
            m.setNumber(commemb.getNumber());
        }
        m.setDataEntityNumber(d.getMemberEntityNumber());
        m.setDimension(d);
        return m;
    }
}

