/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.CommonTemplateEntry;
import kd.fi.bcm.business.adjust.model.RptAdjustTemplateModel;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class CommonAdjustTemplateModel
extends RptAdjustTemplateModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IDNumberTreeNode mergeNode;
    private Set<Long> orgScope;
    private List<CommonTemplateEntry> entries;
    private SpreadManager spreadManager;
    public static final String EXECUTEORDER = "executeorder";

    public BigDecimal getExecuteOreder() {
        return this.get(EXECUTEORDER) == null ? new BigDecimal("99999") : (BigDecimal)this.get(EXECUTEORDER);
    }

    public void setExecuteOrder(BigDecimal order) {
        this.put(EXECUTEORDER, (Object)order);
    }

    @Override
    public long getCvtBeforeCurrencyId() {
        if (OrgRelaProcessMembPool.isRelaProcess((String)this.getProcess())) {
            return this.get("cvtbeforecurrency", 0L);
        }
        return 0L;
    }

    @Override
    public void loadDynaObj2Model(DynamicObject dyna) {
        super.loadDynaObj2Model(dyna);
        this.setExecuteOrder(dyna.getBigDecimal(EXECUTEORDER));
        this.spreadManager = JsonSerializerUtil.toSpreadManager((String)((String)dyna.get("data")));
        this.collectSpreadDataFromTemplate();
        this.setSpreadJson(null);
        this.setData(null);
        this.setModifyTime(null);
        this.setCreateTime(null);
    }

    private void collectSpreadDataFromTemplate() {
        this.entries = new ArrayList<CommonTemplateEntry>();
        SpreadManager spreadManager = (SpreadManager)ObjectSerialUtil.deSerializedBytesAdjust((String)this.getData());
        Sheet sheet = spreadManager.getBook().getSheet(0);
        Map<String, Integer> orGetIndexMap = CommonAdjustTemplateModel.createOrGetIndexMap(sheet);
        Collection<Integer> values = orGetIndexMap.values();
        if (orGetIndexMap.containsKey("Entity")) {
            values.remove(orGetIndexMap.get("Entity"));
        }
        int maxRow = sheet.getMaxRowCount();
        boolean isHasDimData = Boolean.FALSE;
        for (int rowIndex = 1; rowIndex <= maxRow; ++rowIndex) {
            isHasDimData = Boolean.FALSE;
            if (CommonAdjustTemplateModel.isEmptRow(sheet, rowIndex, values)) continue;
            CommonTemplateEntry commonTemplateEntry = new CommonTemplateEntry();
            commonTemplateEntry.setRow(rowIndex);
            for (Map.Entry<String, Integer> entry : orGetIndexMap.entrySet()) {
                Cell cell = sheet.getCell(rowIndex, entry.getValue().intValue());
                if ("debit".equals(entry.getKey()) || "credit".equals(entry.getKey())) {
                    if (cell == null || cell.getValue() == null && !cell.hasFormula()) continue;
                    commonTemplateEntry.setDc("debit".equals(entry.getKey()) ? DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS : DrCRDirectEnum.BORROW_MINUS_lOAN_PLUS);
                    commonTemplateEntry.setBalanceLine("1".equals(cell.getUserObject("isBlanceLine")));
                    commonTemplateEntry.setHasFormula(cell.hasFormula());
                    if (commonTemplateEntry.isHasFormula()) {
                        commonTemplateEntry.setOrginFormula(cell.getFormula());
                        continue;
                    }
                    commonTemplateEntry.setValue(InvestUtils.convertToBigDecimal((Object)cell.getValue()));
                    continue;
                }
                if (cell != null && ((String)cell.getUserObject("entitysign", (Object)"")).startsWith("bcm_")) {
                    commonTemplateEntry.getRowData().put(entry.getKey(), cell.getUserObject("membid"));
                    isHasDimData = Boolean.TRUE;
                    continue;
                }
                if (cell == null) continue;
                commonTemplateEntry.getRowData().put(entry.getKey(), cell.getValue());
            }
            if (!isHasDimData) continue;
            this.entries.add(commonTemplateEntry);
        }
    }

    private static boolean isEmptRow(Sheet sheet, Integer row, Collection<Integer> cols) {
        return cols.stream().allMatch(col -> {
            Cell cell = sheet.getCell(row.intValue(), col.intValue());
            if ((cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString())) && cell.getMemberFromUserObject() == null && !cell.hasFormula()) {
                return true;
            }
            return cell.getValue() != null && (cell.getValue().toString().contains("=") || cell.getValue().toString().contains("--"));
        });
    }

    public static Map<String, Integer> createOrGetIndexMap(Sheet effectiveSheet) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < effectiveSheet.getMaxColumnCount(); ++i) {
            Cell cell = effectiveSheet.getCell(0, i);
            if (cell == null || cell.getUserObject("entitysign") == null) continue;
            String sign = (String)cell.getUserObject("entitysign");
            if (StringUtils.isNotEmpty((String)sign) && sign.startsWith("bcm_") && !"bcm_mergenode".equals(sign)) {
                indexMap.put(cell.getDimension(0).getNumber(), i);
                continue;
            }
            indexMap.put(sign, i);
        }
        return indexMap;
    }

    public Set<Long> getOrgScope() {
        return this.orgScope;
    }

    public void setOrgScope(Set<Long> orgScope) {
        this.orgScope = orgScope;
    }

    public List<CommonTemplateEntry> getEntries() {
        return this.entries;
    }

    @Override
    public String getProcess() {
        return super.getProcess();
    }

    public void setMergeNode(IDNumberTreeNode mergeNode) {
        this.mergeNode = mergeNode;
    }

    public IDNumberTreeNode getMergeNode() {
        return this.mergeNode;
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }
}

