/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;

public class DseqTreeNode
implements Comparable<DseqTreeNode> {
    public static final String undefinedseq = "100000000000";
    public static final String connector = "-";
    private Boolean hasDefaultData = false;
    private String parentDseq = "";
    private String dseq = "";
    private final List<DynamicObject> otherCurrencyDatas = new ArrayList<DynamicObject>();
    private final List<DynamicObject> sameDseqDatas = new ArrayList<DynamicObject>();
    private List<DseqTreeNode> children;

    public DseqTreeNode() {
    }

    public DseqTreeNode(String dseq) {
        int lastIndex = dseq.lastIndexOf(connector);
        this.parentDseq = lastIndex == -1 ? "" : dseq.substring(0, lastIndex);
        this.dseq = dseq.substring(lastIndex + 1);
        if (StringUtils.isEmpty((CharSequence)dseq)) {
            this.dseq = undefinedseq;
        }
    }

    public DseqTreeNode(DynamicObject entry) {
        this(entry.getString("dseq"));
        this.addOtherCurrencyData(entry);
    }

    public final void addOtherCurrencyData(DynamicObject entry) {
        this.otherCurrencyDatas.add(entry);
        if (entry.getBoolean("isdefaultcurrency")) {
            this.hasDefaultData = true;
        }
    }

    public void addSameDseqData(DynamicObject entry) {
        this.sameDseqDatas.add(entry);
    }

    public DseqTreeNode addChild(DseqTreeNode node) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<DseqTreeNode>());
        }
        if (node != null) {
            this.getChildren().add(node);
        }
        return this;
    }

    public void updateDseq() {
        if (this.children != null && !this.children.isEmpty()) {
            Collections.sort(this.children);
            int size = Math.max(Integer.toString(this.children.size()).length(), 2);
            int currentDseq = 0;
            for (DseqTreeNode childTreeNode : this.children) {
                childTreeNode.dseq = childTreeNode.compensationDseq(size, ++currentDseq);
                childTreeNode.parentDseq = StringUtils.isEmpty((CharSequence)this.dseq) ? "" : (StringUtils.isEmpty((CharSequence)this.parentDseq) ? this.dseq : this.parentDseq + connector + this.dseq);
                childTreeNode.updateField("dseq", childTreeNode.createWholeDseq());
                for (DynamicObject sameDseqNode : childTreeNode.getSameDseqDatas()) {
                    childTreeNode.dseq = childTreeNode.compensationDseq(size, ++currentDseq);
                    sameDseqNode.set("dseq", (Object)childTreeNode.createWholeDseq());
                }
                childTreeNode.updateDseq();
            }
        }
    }

    private String compensationDseq(int dseqSize, int newSeq) {
        return String.format("%0" + dseqSize + "d", newSeq);
    }

    private String createWholeDseq() {
        return StringUtils.isEmpty((CharSequence)this.parentDseq) ? this.dseq : this.parentDseq + connector + this.dseq;
    }

    public void updateField(String field, Object value) {
        this.otherCurrencyDatas.forEach(data -> data.set(field, value));
        this.sameDseqDatas.forEach(data -> data.set(field, value));
    }

    @Override
    public int compareTo(DseqTreeNode o) {
        return new BigDecimal(this.getDseq()).compareTo(new BigDecimal(o.getDseq()));
    }

    public String getDseq() {
        return StringUtils.isEmpty((CharSequence)this.dseq) ? undefinedseq : this.dseq;
    }

    public String getParentDseq() {
        return StringUtils.isEmpty((CharSequence)this.parentDseq) ? null : this.parentDseq;
    }

    private List<DynamicObject> getOtherCurrencyDatas() {
        return this.otherCurrencyDatas;
    }

    public Boolean hasDefaultData() {
        return this.hasDefaultData;
    }

    private List<DynamicObject> getSameDseqDatas() {
        return this.sameDseqDatas;
    }

    private void setChildren(List<DseqTreeNode> children) {
        this.children = children;
    }

    public List<DseqTreeNode> getChildren() {
        return this.children;
    }
}

