/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkageDataCollector {
    private Long modelId;
    private DynamicObject[] retainHistoryLinkDatas;
    private List<DynamicObject> createLinkageDatas = new ArrayList<DynamicObject>(12);
    private final Map<Long, Boolean> adjustIds = new HashMap<Long, Boolean>(16);
    private Map<Long, Long> sourceId2LinkageIdMap;
    private OperationResult operationResult = new OperationResult();
    private DynamicObjectCollection sourceDatas;

    public LinkageDataCollector(Long modelId) {
        this.modelId = modelId;
    }

    public Map<Long, Long> getSourceId2LinkageIdMap() {
        return this.sourceId2LinkageIdMap;
    }

    public void setSourceId2LinkageIdMap(Map<Long, Long> sourceId2LinkageIdMap) {
        this.sourceId2LinkageIdMap = sourceId2LinkageIdMap;
    }

    public DynamicObject[] getRetainHistoryLinkDatas() {
        return this.retainHistoryLinkDatas;
    }

    public void setRetainHistoryLinkDatas(DynamicObject[] retainHistoryLinkDatas) {
        this.retainHistoryLinkDatas = retainHistoryLinkDatas;
    }

    public List<DynamicObject> getCreateLinkageDatas() {
        return this.createLinkageDatas;
    }

    public void setCreateLinkageDatas(List<DynamicObject> createLinkageDatas) {
        this.createLinkageDatas = createLinkageDatas;
    }

    public void setSourceDatas(DynamicObjectCollection sourceDatas) {
        this.sourceDatas = sourceDatas;
    }

    public Map<Long, Boolean> getAdjustIds() {
        return this.adjustIds;
    }

    public void putAdjustId(Long adjustId, Boolean createLinkageIsOk) {
        createLinkageIsOk = createLinkageIsOk != false ? this.adjustIds.getOrDefault(adjustId, Boolean.TRUE) : createLinkageIsOk;
        this.adjustIds.put(adjustId, createLinkageIsOk);
    }

    public boolean createLinkageIsOk(Long adjustId) {
        return this.adjustIds.getOrDefault(adjustId, Boolean.TRUE);
    }

    public boolean hasLinkageData() {
        return !this.createLinkageDatas.isEmpty() || this.retainHistoryLinkDatas != null && this.retainHistoryLinkDatas.length > 0;
    }

    public void saveLinkageData() {
        PlatUtil.executeWithTX(e -> {
            this.clearLinkageAdjustData();
            this.updateAdjustSourceAndLinkageHead();
            this.updateLinkageData();
            AdjustOperationHelper.clonePermClassFromSrcAdjust(this.modelId, this.sourceId2LinkageIdMap);
        });
    }

    private void clearLinkageAdjustData() {
        if (!this.sourceId2LinkageIdMap.isEmpty()) {
            List adjusts = this.sourceId2LinkageIdMap.values().stream().filter(linkageId -> linkageId != 0L).collect(Collectors.toList());
            adjusts.addAll(this.sourceId2LinkageIdMap.keySet());
            QFBuilder qfBuilder = new QFBuilder("adjust", "in", adjusts);
            qfBuilder.add("entrysource", "in", (Object)new String[]{"2", "4", "6"});
            if (this.retainHistoryLinkDatas != null && this.retainHistoryLinkDatas.length > 0) {
                qfBuilder.add("id", "not in", Arrays.stream(this.retainHistoryLinkDatas).map(e -> e.getLong("id")).collect(Collectors.toList()));
            }
            DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])qfBuilder.toArray());
        }
    }

    private DynamicObject createLinkageHead(Long linkageId, DynamicObject sourceHeader) {
        DynamicObject newLinkAdjust = LinkageMappingServiceHelper.createNewLinkAdjust(sourceHeader);
        newLinkAdjust.set("status", (Object)sourceHeader.getString("status"));
        newLinkAdjust.set("id", (Object)linkageId);
        newLinkAdjust.set("linkagelinksource", (Object)sourceHeader.getLong("id"));
        return newLinkAdjust;
    }

    private void updateAdjustSourceAndLinkageHead() {
        DynamicObject[] sourceAdjusts = BusinessDataServiceHelper.load((Object[])this.sourceId2LinkageIdMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        ArrayList<Long> needDeleteLinkageIds = new ArrayList<Long>(10);
        ArrayList<DynamicObject> needCreateLinkages = new ArrayList<DynamicObject>(10);
        String userId = RequestContext.get().getUserId();
        Date now = TimeServiceHelper.now();
        HashSet<Long> temp = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> checkExitsHead = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject sourceAdjust : sourceAdjusts) {
            Long sourceId = sourceAdjust.getLong("id");
            Long linkageId = sourceAdjust.getLong("linkagelinksource");
            Long replaceLinkageId = this.sourceId2LinkageIdMap.get(sourceId);
            if (!this.adjustIds.containsKey(sourceId) || replaceLinkageId == 0L) {
                if (linkageId != 0L) {
                    needDeleteLinkageIds.add(linkageId);
                }
                replaceLinkageId = 0L;
            } else if (linkageId.equals(replaceLinkageId)) {
                checkExitsHead.put(linkageId, sourceAdjust);
            } else if (temp.add(replaceLinkageId)) {
                needCreateLinkages.add(this.createLinkageHead(replaceLinkageId, sourceAdjust));
            }
            sourceAdjust.set("linkagelinksource", (Object)replaceLinkageId);
            sourceAdjust.set("modifier", (Object)userId);
            sourceAdjust.set("modifytime", (Object)now);
        }
        ArrayList<DynamicObject> exitsLinkHeadDyns = new ArrayList<DynamicObject>(16);
        if (!checkExitsHead.isEmpty()) {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter("id", "in", checkExitsHead.keySet()).toArray(), null, (int)-1);
            for (Map.Entry entry : checkExitsHead.entrySet()) {
                Long k = (Long)entry.getKey();
                DynamicObject v = (DynamicObject)entry.getValue();
                if (ids.contains(k)) {
                    v.set("modifier", (Object)userId);
                    v.set("modifytime", (Object)now);
                    continue;
                }
                needCreateLinkages.add(this.createLinkageHead(k, v));
            }
            if (!CollectionUtil.isEmpty((Collection)ids)) {
                SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
                df.applyPattern("yyyy-MM-dd HH:mm:ss");
                ArrayList<String> updateParams = new ArrayList<String>(5);
                updateParams.add("fmodifierid = " + RequestContext.get().getUserId());
                updateParams.add("fmodifytime = " + String.format("{ts'%s'}", df.format(TimeServiceHelper.now())));
                String sql = "update t_bcm_rptadjust set " + String.join((CharSequence)",", updateParams) + " where fid in (%s)";
                CharSequence[] succids = (String[])ids.stream().map(Object::toString).distinct().toArray(String[]::new);
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(sql, String.join((CharSequence)",", succids)));
                SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
            }
            exitsLinkHeadDyns.addAll(Arrays.asList(BusinessDataServiceHelper.load((Object[])checkExitsHead.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"))));
        }
        if (!needDeleteLinkageIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"), (Object[])needDeleteLinkageIds.toArray());
        }
        this.rebuildAdjustCommembEntry(sourceAdjusts, needCreateLinkages, exitsLinkHeadDyns);
        SaveServiceHelper.save((DynamicObject[])sourceAdjusts);
        if (!exitsLinkHeadDyns.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])exitsLinkHeadDyns.toArray(new DynamicObject[0]));
        }
        if (!needCreateLinkages.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needCreateLinkages.toArray(new DynamicObject[0]));
        }
    }

    private void rebuildAdjustCommembEntry(DynamicObject[] sourceAdjusts, List<DynamicObject> needCreateLinkages, List<DynamicObject> exitsLinkHeads) {
        ArrayList<DynamicObject> allHead = new ArrayList<DynamicObject>(16);
        allHead.addAll(Arrays.asList(sourceAdjusts));
        allHead.addAll(needCreateLinkages);
        allHead.addAll(exitsLinkHeads);
        ArrayList<DynamicObject> allEntries = new ArrayList<DynamicObject>(16);
        allEntries.addAll((Collection<DynamicObject>)this.sourceDatas);
        allEntries.addAll(this.createLinkageDatas);
        AdjustmentServiceHelper.rebuildAdjustCommembEntry(this.modelId, allHead, allEntries);
    }

    private void updateLinkageData() {
        if (this.retainHistoryLinkDatas != null && this.retainHistoryLinkDatas.length > 0) {
            SaveServiceHelper.update((DynamicObject[])this.retainHistoryLinkDatas);
        }
        if (this.createLinkageDatas != null && !this.createLinkageDatas.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.createLinkageDatas.toArray(new DynamicObject[0]));
        }
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(OperationResult op) {
        this.operationResult = op;
    }
}

