/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.papertemplate.PaperTemplateCatalog;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustTemplateControlEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;

public class RptAdjustTemplateModel
extends AdjustModel {
    private static final long serialVersionUID = 1L;

    public RptAdjustTemplateModel() {
        this.setDataEntityNumber("bcm_papertemplate");
    }

    @Override
    public long getId() {
        if (this.get("id") == null) {
            return 0L;
        }
        return (Long)this.get("id");
    }

    public PaperTemplateCatalog getTemplateCatalog() {
        return (PaperTemplateCatalog)this.get("templatecatalog");
    }

    public void setTemplateCatalog(PaperTemplateCatalog catalog) {
        this.put("templatecatalog", (Object)catalog);
    }

    public void setTemplateType(String templateType) {
        this.put("templatetype", (Object)templateType);
    }

    public String getTemplateType() {
        return (String)this.get("templatetype");
    }

    @Override
    public void setJournaltype(int journaltype) {
        this.put(AdjustTemplateControlEnum.JOURNAL_TYPE.getNumber(), (Object)journaltype);
    }

    @Override
    public int getJournaltype() {
        return (Integer)this.get(AdjustTemplateControlEnum.JOURNAL_TYPE.getNumber());
    }

    @Override
    public void setBussnesstype(String bussnesstype) {
        this.put(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber(), (Object)bussnesstype);
    }

    @Override
    public String getBussnesstype() {
        return (String)this.get(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber());
    }

    @Override
    public String getData() {
        return (String)this.get("data");
    }

    @Override
    public void setData(String data) {
        this.put("data", (Object)data);
    }

    @Override
    public String getSpreadJson() {
        return (String)this.get("spreadjson");
    }

    @Override
    public void setSpreadJson(String spreadJson) {
        this.put("spreadjson", (Object)spreadJson);
    }

    @Override
    public int getBalancetype() {
        return (Integer)this.get(AdjustTemplateControlEnum.BALANCE_TYPE.getNumber());
    }

    @Override
    public void setBalancetype(int balanceType) {
        this.put(AdjustTemplateControlEnum.BALANCE_TYPE.getNumber(), (Object)balanceType);
    }

    @Override
    public String getLinkCreateType() {
        return (String)this.get(AdjustTemplateControlEnum.LINK_CREATE_TYPE.getNumber());
    }

    @Override
    public void setLinkCreateType(String linkcreatetype) {
        this.put(AdjustTemplateControlEnum.LINK_CREATE_TYPE.getNumber(), (Object)linkcreatetype);
    }

    public long getAdjustCatalogId() {
        return this.get("adjustcatalogid") == null ? 0L : (Long)this.get("adjustcatalogid");
    }

    public void setAdjustCatalogId(long adjustCatalogId) {
        this.put("adjustcatalogid", (Object)adjustCatalogId);
    }

    public void setGroup(long group) {
        this.put("group", (Object)group);
    }

    public long getGroup() {
        if (this.get("group") == null) {
            this.setGroup(DBServiceHelper.genGlobalLongId());
        }
        return (Long)this.get("group");
    }

    public Map<String, Object> getTmplScene() {
        return (Map)this.get("tmplscene");
    }

    public void setTmplScene(Map<String, Object> tmplSceneMap) {
        this.put("tmplscene", (Object)tmplSceneMap);
    }

    public void setEffectiveText(String text) {
        this.put("effectivetext", (Object)text);
    }

    public String getEffectiveText() {
        return (String)this.get("effectivetext");
    }

    public void setEffectiveData(Map<String, Set<Long>> data) {
        this.put("effectivedata", (Object)data);
    }

    public Map<String, Set<Long>> getEffectiveData() {
        return (Map)this.get("effectivedata");
    }

    @Override
    public void loadDynaObj2Model(DynamicObject dyna) {
        Predicate<Object> p = t -> t == null;
        this.setId(dyna.getLong("id"));
        this.setName(dyna.getString("name"));
        this.setNumber(dyna.getString("number"));
        this.setModelId(this.defaultIfNull(p, dyna.getDynamicObject("model"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setScenarioId(this.defaultIfNull(p, dyna.getDynamicObject("scenario"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setJournaltype(Integer.parseInt(JournalTypeEnum.NORMAL.getKey()));
        this.setId(dyna.getLong("id"));
        this.setName(dyna.getString("name"));
        this.setNumber(dyna.getString("number"));
        this.setMultiplecurrency(dyna.getString("multiplecurrency"));
        this.setCvtBeforeCurrencyId(dyna.getLong("cvtbeforecurrency"));
        DynamicObject permclass = dyna.getDynamicObject("permclass");
        if (permclass != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)permclass.getLong("id"));
            jsonObject.put("number", (Object)permclass.getString("number"));
            this.setPermClass(jsonObject);
        }
        this.setDescription(dyna.getString("description"));
        this.setStatus(dyna.getString("status"));
        this.setCreatorId(this.defaultIfNull(p, dyna.getDynamicObject("creator"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setModifierId(this.defaultIfNull(p, dyna.getDynamicObject("modifier"), 0L, v -> ((DynamicObject)v).getLong("id")));
        this.setCreateTime(dyna.getDate("createTime"));
        this.setModifyTime(dyna.getDate("modifytime"));
        this.setAdjustCatalogId(dyna.getLong("adjustcatalog.id"));
        DynamicObject templatecatalog = dyna.getDynamicObject("templatecatalog");
        if (templatecatalog != null) {
            PaperTemplateCatalog catalog = new PaperTemplateCatalog();
            catalog.setId(templatecatalog.getLong("id"));
            catalog.setName(templatecatalog.getString("name"));
            String longnumber = templatecatalog.getString("longnumber");
            this.setTemplateType(PaperTemplateService.getTemplateTypeByLongnumber(longnumber));
            this.setTemplateCatalog(catalog);
        }
        this.setData(dyna.getString("data"));
        this.setSpreadJson(dyna.getString("spreadjson"));
        this.setBussnesstype(dyna.getString("bussnesstype"));
        this.setBalancetype(dyna.getInt("balancetype"));
        this.setLinkCreateType(dyna.getString("linkcreatetype"));
        this.setJournaltype(dyna.getInt("journaltype"));
        this.setProcess(BusinessTypeEnum.searchByName((String)this.getBussnesstype()).getProcessNumber());
        DynamicObjectCollection entries = dyna.getDynamicObjectCollection("commembentry");
        this.getCommDimensionEntries().addAll(new CommDimensionEntry(this).loadDynaObject(entries, () -> this));
        entries = dyna.getDynamicObjectCollection("spreadmembentry");
        this.getSpreadDimensionEntries().addAll(new SpreadDimensionEntry(this).loadDynaObject(entries, () -> this));
        this.setGroup(dyna.getLong("group"));
        this.setTmplScene(PaperTemplateHelper.findTmplScene4Setting(this.getModelId(), PaperTemplateTypeEnum.PRTADJUST, this.getGroup()));
        Pair<String, Map<String, Set<Long>>> textData = PaperTemplateHelper.explainEffective(dyna);
        this.setEffectiveText((String)textData.p1);
        this.setEffectiveData((Map)textData.p2);
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object v, R defaultValue, Function<Object, R> f) {
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    @Override
    public String getCommonDataEntityNumber() {
        return "bcm_adjusttemplate.commembentry";
    }

    @Override
    public String getSpreadDataEntityNumber() {
        return "bcm_adjusttemplate.spreadmembentry";
    }

    public List<Dimension> getCommDimension() {
        List<CommDimensionEntry> commDimensionEntryList = this.getCommDimensionEntries();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(commDimensionEntryList.size());
        for (CommDimensionEntry commDimensionEntry : commDimensionEntryList) {
            dimensionList.add(commDimensionEntry.getDimension());
        }
        return dimensionList;
    }

    public List<Dimension> getSpreadDimension() {
        List<SpreadDimensionEntry> spreadDimensionEntryList = this.getSpreadDimensionEntries();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(spreadDimensionEntryList.size());
        for (SpreadDimensionEntry spreadDimensionEntry : spreadDimensionEntryList) {
            dimensionList.add(spreadDimensionEntry.getDimension());
        }
        return dimensionList;
    }
}

