/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustBaseEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.ILoader;

public class SpreadDimensionEntry
extends AdjustBaseEntry
implements ILoader<DynamicObjectCollection, List<SpreadDimensionEntry>, DynaEntityObject> {
    private static final long serialVersionUID = 1L;

    public SpreadDimensionEntry(DynaEntityObject adjust) {
        super(adjust);
        this.setDataEntityNumber(adjust.getSpreadDataEntityNumber());
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        dyna.set("spreaddimension", (Object)this.getDimension().getId());
        if (dyna.getDynamicObjectType().getProperty("spreadentitysign") != null) {
            dyna.set("spreadentitysign", (Object)this.getNumber());
        }
        dyna.set("seq", (Object)incrementer.getAndIncrement());
        coll.add((Object)dyna);
        return coll;
    }

    @Override
    public List<SpreadDimensionEntry> loadDynaObject(DynamicObjectCollection t, Supplier<DynaEntityObject> s) {
        ArrayList<SpreadDimensionEntry> entries = new ArrayList<SpreadDimensionEntry>(10);
        for (DynamicObject o : t) {
            SpreadDimensionEntry entry = new SpreadDimensionEntry(s.get());
            entry.setId(o.getLong("id"));
            entry.setSeq(o.getInt("seq"));
            Dimension d = new Dimension();
            DynamicObject dyna = o.getDynamicObject("spreaddimension");
            this.loadSimpleDynamicObject(d, dyna);
            d.setDataEntityNumber(dyna.getDataEntityType().getName());
            d.setMemberEntityNumber(dyna.getString("membermodel"));
            d.setFieldmapped(dyna.getString("fieldmapped"));
            entry.setDimension(d);
            if (o.getDynamicObjectType().getProperty("spreadentitysign") != null) {
                if (StringUtils.isEmpty((String)o.getString("spreadentitysign"))) {
                    entry.setNumber(d.getMemberEntityNumber());
                } else {
                    entry.setNumber(o.getString("spreadentitysign"));
                }
            }
            entries.add(entry);
        }
        return entries;
    }
}

