/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model.export;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.exception.KDException;
import kd.bos.extension.ConcurrentHashSet;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;

class QueryAdjustChildResult {
    private volatile String errorLog;
    private final Set<Long> adjPkSet = new ConcurrentHashSet(16);
    private final Map<String, ConcurrentLinkedQueue<IDynamicObjectModel>> dics = new ConcurrentHashMap<String, ConcurrentLinkedQueue<IDynamicObjectModel>>(16);
    private volatile Map<Long, List<Row>> entryMap = new ConcurrentHashMap<Long, List<Row>>(100);

    QueryAdjustChildResult() {
    }

    public void populate(Set<String> belongOrgs, IDynamicObjectModel adjust) {
        belongOrgs.forEach(belongOrg -> this.dics.computeIfAbsent((String)belongOrg, a -> new ConcurrentLinkedQueue()).add(adjust));
        this.adjPkSet.add(adjust.getLong("id"));
    }

    public void populateErrorLog(String errorLog) {
        this.errorLog = errorLog;
        this.adjPkSet.clear();
        this.dics.clear();
    }

    public void cacheEntryDataSet(DataSet ds) {
        try (DataSet dsClone = ds;){
            dsClone.forEachRemaining(row -> this.entryMap.computeIfAbsent(row.getLong("adjust"), a -> Lists.newArrayList()).add(((AbstractRow)row).persist()));
        }
    }

    public List<Pair<IDynamicObjectModel, List<Row>>> search(String belongOrg) {
        ConcurrentLinkedQueue<IDynamicObjectModel> adjustQueue;
        if (!this.isSuccess()) {
            throw new KDException(this.errorLog);
        }
        ArrayList resultList = Lists.newArrayList();
        if (this.entryMap != null && (adjustQueue = this.dics.remove(belongOrg)) != null) {
            adjustQueue.forEach(adjust -> {
                List<Row> rowList = this.entryMap.remove(adjust.getLong("id"));
                if (!CollectionUtil.isEmpty(rowList)) {
                    resultList.add(Pair.onePair((Object)adjust, rowList));
                }
            });
        }
        return resultList;
    }

    public boolean isEmpty() {
        return this.adjPkSet.isEmpty();
    }

    public boolean isEmpty(String belongOrg) {
        return !this.dics.containsKey(belongOrg);
    }

    public Set<Long> getAdjustPkSet() {
        return this.adjPkSet;
    }

    public boolean isSuccess() {
        return StringUtils.isBlank((CharSequence)this.errorLog);
    }

    public String getErrorLog() {
        return this.errorLog;
    }
}

