/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.model.IOriginalSign;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.operation.OperationRunable;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustMutexLockedCheckValidator;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;

public abstract class AbstractAdjustOperation
implements IOriginalSign {
    private AdjustOperQueryParam queryParam = new AdjustOperQueryParam(true, 0);
    private String originalSign;
    private final Long modelId;
    private final String modelNum;
    private List<Long> pkids;
    protected AdjustOperationContext actx;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());
    protected AdjRecordLog recordLog = new AdjRecordLog();
    private OperationResult op = new OperationResult();
    private final AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> validatorExecute;
    private boolean isOpenMutex = false;

    protected AbstractAdjustOperation(Long modelId, List<Long> pkids) {
        this.pkids = pkids;
        this.modelId = modelId;
        this.modelNum = MemberReader.findModelNumberById((Object)modelId);
        this.actx = new AdjustOperationContext(modelId);
        this.validatorExecute = new AdjustValidatorExecute(this.actx);
        this.initializeOperationResult();
    }

    protected final void initializeOperationResult() {
        this.op = new OperationResult();
        this.op.setBillCount(this.pkids.size());
        this.validatorExecute.setValidateResult(this.op);
    }

    public void excute() {
        if (this.openMutex()) {
            this.validatorExecute.addValidator(new AdjustMutexLockedCheckValidator());
        }
        this.actx.setOperTypeEnum(this.getOperationType());
        this.onAddValidators(this.validatorExecute);
        this.beforeExcute();
        AtomicInteger lastSuccessCount = new AtomicInteger();
        this.getQueryParam().setModelId(this.getModelId());
        this.onPrepareQueryParam(this.getQueryParam());
        this.afterPrepareQueryParam(this.getQueryParam());
        AdjustOperationThreadHelper.groupAdjustList(this.pkids, this.getQueryParam(), (adjustDys, adjustDatas) -> {
            lastSuccessCount.set(this.getRecordLog().getSuccessConut().get());
            Set ajustIdset = adjustDys.parallelStream().map(p -> p.getString("id")).collect(Collectors.toSet());
            try (TXHandle tx = TX.required();){
                try {
                    this.beforeValidatorData(adjustDys, adjustDatas);
                    this.validatorExecute.excute((Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>)Pair.onePair((Object)adjustDys, (Object)adjustDatas));
                    adjustDys.removeIf(elim -> {
                        long id = elim.getLong("id");
                        String number = elim.getString("number");
                        List entries = (List)adjustDatas.remove(id);
                        try {
                            if (entries == null || entries.isEmpty()) {
                                this.addErrorOper(number, id, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u660e\u7ec6\u5206\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractAdjustOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                            } else {
                                this.dealAdjustDatas((DynamicObject)elim, entries);
                                if (this.needBatchExcute()) {
                                    this.afterExcute();
                                }
                            }
                        }
                        catch (Throwable t) {
                            this.addErrorOper(number, id, AdjustmentServiceHelper.toString_Adj(t));
                        }
                        return true;
                    });
                    this.afterExcute();
                    this.releaseMutex();
                }
                catch (Throwable t) {
                    try {
                        tx.markRollback();
                        String errorMsg = AdjustmentServiceHelper.toString_Adj(t);
                        this.getRecordLog().setSuccessConut(lastSuccessCount.get());
                        this.getRecordLog().addErrorMsg(errorMsg);
                        this.getOperationResult().setMessage(errorMsg);
                        ajustIdset.stream().forEach(e -> this.getOperationResult().getSuccessPkIds().remove(LongUtil.toLong((Object)e)));
                        if (this.getOperationResult().getSuccessPkIds().isEmpty()) {
                            this.getOperationResult().setSuccess(false);
                        }
                        this.getOperationResult().setShowMessage(true);
                        this.log.error(t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.releaseMutex();
                    }
                }
            }
        });
    }

    public AdjustOperQueryParam getQueryParam() {
        return this.queryParam;
    }

    protected void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
    }

    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
    }

    private void afterPrepareQueryParam(AdjustOperQueryParam queryParam) {
        if (queryParam.hasAdjustField()) {
            queryParam.addAdjustField("id");
            queryParam.addAdjustField("number");
            queryParam.addAdjustField("scenario.id");
            queryParam.addAdjustField("year.id");
            queryParam.addAdjustField("period.id");
        }
        if (queryParam.hasEntryField()) {
            queryParam.addEntryField("id");
            queryParam.addEntryField("adjust.id");
        }
    }

    protected boolean needBatchExcute() {
        return false;
    }

    protected void onAddValidators(AdjustValidatorExecute e) {
    }

    protected void releaseMutex() {
        if (this.openMutex() && this.actx.getUserObject().containsKey((Object)"successMutex")) {
            AdjustmentServiceHelper.batchRelease(this.actx.getUserObject("successMutex").parallelStream().map(Object::toString).collect(Collectors.toList()));
            this.actx.getUserObject().removeAll((Object)"successMutex");
        }
    }

    protected abstract void beforeExcute();

    protected abstract void dealAdjustDatas(DynamicObject var1, List<DynamicObject> var2);

    protected abstract void afterExcute();

    protected abstract Map<String, Object> createRecordParam();

    protected abstract AdjustOperTypeEnum getOperationType();

    public void asynexcute() {
        AdjustOperationThreadHelper.excuteInThread(this.getOperationType(), this.createRecordParam(), new OperationRunable(){

            @Override
            public int getCount() {
                return AbstractAdjustOperation.this.getPkids().size();
            }

            @Override
            public void run(Map<String, Object> params, AdjRecordLog log) {
                AbstractAdjustOperation.this.recordLog = log;
                AbstractAdjustOperation.this.validatorExecute.setAdjLog(log);
                AbstractAdjustOperation.this.excute();
            }
        });
    }

    protected void addErrorOper(String number, Long id, String msg) {
        msg = String.format("%s : %s", number, msg);
        this.getOperationResult().getSuccessPkIds().remove(id);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(msg);
        if (this.getOperationType() != null) {
            operateErrorInfo.setTitle(this.getOperationType().getName());
        }
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        this.getOperationResult().addErrorInfo(operateErrorInfo);
        this.getRecordLog().addErrorMsg(msg);
    }

    protected void addWarnOper(String number, Long id, String msg) {
        msg = String.format("%s : %s", number, msg);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(msg);
        if (this.getOperationType() != null) {
            operateErrorInfo.setTitle(this.getOperationType().getName());
        }
        operateErrorInfo.setErrorLevel(ErrorLevel.Warning.name());
        this.getOperationResult().addErrorInfo(operateErrorInfo);
        this.getRecordLog().addWarningMsg(msg);
    }

    protected void addSuccessOper(Long id) {
        if (!this.getOperationResult().getSuccessPkIds().contains(id)) {
            this.getOperationResult().getSuccessPkIds().add(id);
        }
        this.getRecordLog().addSuccessCount();
    }

    protected AdjRecordLog getRecordLog() {
        return this.recordLog;
    }

    protected Long getModelId() {
        if (this.modelId == null || this.modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractAdjustOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return this.modelId;
    }

    protected String getModelNum() {
        return this.modelNum;
    }

    protected List<Long> getPkids() {
        return this.pkids;
    }

    protected void setPkids(List<Long> pkids) {
        this.pkids = pkids;
    }

    public OperationResult getOperationResult() {
        return this.op;
    }

    protected void clearOperationRseult() {
        this.setOp(new OperationResult());
        this.op.setBillCount(this.pkids.size());
        this.op.setSuccess(true);
    }

    protected void setOp(OperationResult op) {
        this.op = op;
    }

    private boolean openMutex() {
        return this.isOpenMutex;
    }

    public void setOpenMutex(boolean openMutex) {
        this.isOpenMutex = openMutex;
    }

    protected AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> getValidatorExecute() {
        return this.validatorExecute;
    }

    public void setActx(AdjustOperationContext actx) {
        this.actx = actx;
        if (this.validatorExecute != null) {
            this.validatorExecute.setCtx(actx);
        }
    }

    @Override
    public String getOriginalSign() {
        return this.originalSign;
    }

    @Override
    public void setOriginalSign(String originalSign) {
        this.originalSign = originalSign;
    }

    public AdjRecordLog getAdjLog() {
        return this.recordLog;
    }

    public void setRecordLog(AdjRecordLog recordLog) {
        this.recordLog = recordLog;
    }
}

