/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.common.enums.adjust.AdjustOperationStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class AdjRecordLog {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AdjRecordLog.class);
    private AtomicLong lastPushCacheTime = new AtomicLong(System.currentTimeMillis());
    private DynamicObject recordLogDy;
    private String specicalLogSign = "";
    private final AtomicInteger index = new AtomicInteger(0);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger successConut = new AtomicInteger(0);
    private int status;
    private final List<String> errorMsgs = new CopyOnWriteArrayList<String>();
    private final List<String> warningMsgs = new CopyOnWriteArrayList<String>();

    public AtomicInteger getSuccessConut() {
        return this.successConut;
    }

    public AdjRecordLog loadRecord(DynamicObject recordLogDy) {
        this.recordLogDy = recordLogDy;
        this.count.set(recordLogDy.getInt("count"));
        this.status = recordLogDy.getInt("status");
        return this;
    }

    public AdjRecordLog loadRecord(DynamicObject recordLogDy, String specicalLogSign) {
        this.loadRecord(recordLogDy);
        if (specicalLogSign != null) {
            this.specicalLogSign = specicalLogSign;
        }
        return this;
    }

    public DynamicObject getRecordLogDy() {
        return this.recordLogDy;
    }

    public void addSuccessCount() {
        this.successConut.incrementAndGet();
        this.update(false);
    }

    public void setCount(int count) {
        this.count.set(count);
        this.update(true);
    }

    public void addCount() {
        this.count.incrementAndGet();
        this.update(false);
    }

    public int getCount() {
        return this.count.get();
    }

    public void setSuccessConut(int successConut) {
        this.successConut.set(successConut);
        this.update(false);
    }

    public void addErrorMsg(long pkId, String errorMsg) {
        this.addErrorMsg(errorMsg);
    }

    public void addWarningMsg(long pkId, String errorMsg) {
        this.addWarningMsg(errorMsg);
    }

    public void addErrorMsg(String errorMsg) {
        this.errorMsgs.add("/**ERROR**/" + errorMsg);
        this.update(false);
    }

    public void addWarningMsg(String errorMsg) {
        this.warningMsgs.add(errorMsg);
        this.update(false);
    }

    public void setStatus(int status) {
        this.status = status;
        this.update(true);
    }

    public AdjRecordLog startLog() {
        this.setStatus(AdjustOperationStatusEnum.STARTSTATUS.getStatus());
        this.update(true);
        return this;
    }

    public void endLog() {
        if (this.errorMsgs.isEmpty()) {
            this.setStatus(AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus());
        } else if (this.successConut.get() != 0) {
            this.setStatus(AdjustOperationStatusEnum.COMPLETEDSTATUS.getStatus());
        } else {
            this.setStatus(AdjustOperationStatusEnum.ERRORSTATUS.getStatus());
        }
        log.error(String.format("specicalLogSign : %s;errormsg : %s;warning : %s", this.specicalLogSign, this.errorMsgs, this.warningMsgs));
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean autoUpdate) {
        if (this.recordLogDy == null) {
            return;
        }
        if (autoUpdate || (double)this.index.incrementAndGet() >= Math.min(50.0, (double)this.successConut.get() * 0.1)) {
            if (AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus() == this.status || AdjustOperationStatusEnum.ERRORSTATUS.getStatus() == this.status || AdjustOperationStatusEnum.COMPLETEDSTATUS.getStatus() == this.status) {
                this.saveAdjLog();
            } else {
                this.updateAdjLogCache();
            }
            this.index.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAdjLog() {
        AdjRecordLog adjRecordLog = this;
        synchronized (adjRecordLog) {
            int countCopy = this.count.get();
            int successCountCopy = this.successConut.get();
            this.recordLogDy.set("count", (Object)countCopy);
            this.recordLogDy.set("successcount", (Object)successCountCopy);
            this.recordLogDy.set("errorcount", (Object)(countCopy - successCountCopy));
            this.recordLogDy.set("status", (Object)this.status);
            this.recordLogDy.set("endtime", (Object)TimeServiceHelper.now());
            ArrayList<String> msgList = new ArrayList<String>(this.warningMsgs);
            msgList.addAll(this.errorMsgs);
            this.recordLogDy.set("failedlog", (Object)this.specicalLogSign.concat(String.join((CharSequence)";", msgList)));
            SaveServiceHelper.update((DynamicObject)this.recordLogDy);
            AdjustOperationThreadHelper.releaseAdjLogCache(this.recordLogDy.getLong("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAdjLogCache() {
        if (System.currentTimeMillis() - this.lastPushCacheTime.get() >= 1000L) {
            AdjRecordLog adjRecordLog = this;
            synchronized (adjRecordLog) {
                this.lastPushCacheTime.set(System.currentTimeMillis());
                AdjustOperationThreadHelper.updateAdjLogCache(this.recordLogDy.getLong("id"), this.count.get(), this.successConut.get(), this.errorMsgs.size());
            }
        }
    }

    public int getFailedCount() {
        return this.count.get() - this.successConut.get();
    }

    public OperationResult toOperationResult() {
        OperationResult op = new OperationResult();
        op.setBillCount(this.count.get());
        for (int i = 0; i < this.successConut.get(); ++i) {
            op.getSuccessPkIds().add(1L);
        }
        this.errorMsgs.forEach(errorMsg -> {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(errorMsg);
            operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
            op.addErrorInfo(operateErrorInfo);
        });
        this.warningMsgs.forEach(errorMsg -> {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(errorMsg);
            operateErrorInfo.setErrorLevel(ErrorLevel.Warning.name());
            op.addErrorInfo(operateErrorInfo);
        });
        return op;
    }
}

