/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustFlowOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;

public class AdjustAutoAuditOperation
extends AdjustFlowOperation {
    public AdjustAutoAuditOperation(AdjustOperationContext ctx, List<Long> pkids) {
        super(ctx, pkids, AdjustOperTypeEnum.AUTOAUDITOPERATION);
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){
            private AdjustBalanceCheckService balanceCheckService;

            @Override
            protected void beforeValidate() {
                super.beforeValidate();
                this.balanceCheckService = new AdjustBalanceCheckService(this.getCtx().getModelId());
            }

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDatas) {
                if (ElimRptAdjSourceTypeEnum.LINK.getValue() != adjust.getInt("sourcetype") && !this.balanceCheckService.isBalance(adjust, adjustDatas)) {
                    AdjustAutoAuditOperation.this.addErrorOper(adjust.getString("number"), adjust.getLong("id"), ResManager.loadKDString((String)"\u5206\u7ec4\u5931\u8d25\u6216\u8005\u501f\u8d37\u4e0d\u5e73\u8861\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustAutoAuditOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            }

            @Override
            protected String getValidatorKey() {
                return "checkAdjustDataBalance";
            }
        });
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        super.dealAdjustDatas(adjustDy, adjustDatas);
        if (RptAdjustStatusEnum.SAVE.status().equals(adjustDy.getString("status")) || RptAdjustStatusEnum.BACK.status().equals(adjustDy.getString("status")) || RptAdjustStatusEnum.TEMPSAVE.status().equals(adjustDy.getString("status"))) {
            LinkageMappingService linkageMappingService;
            LinkageDataCollector linkageDataCollector;
            boolean isCM017 = ConfigServiceHelper.getBoolParam(this.getModelId(), "CM017");
            Long pkId = adjustDy.getLong("id");
            if (!isCM017 && this.getOperationResult().getSuccessPkIds().contains(pkId) && AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus().equals(adjustDy.getString("linkcreatetype")) && !(linkageDataCollector = (linkageMappingService = new LinkageMappingService(this.getModelId(), (Long)this.getYear(), (Long)this.getScene(), (Long)this.getPeriod(), Collections.singleton(pkId), false)).rebuildLinkage()).createLinkageIsOk(pkId)) {
                this.addErrorOper(adjustDy.getString("number"), pkId, ResManager.loadKDString((String)"\u751f\u6210\u7684\u8054\u52a8\u5206\u5f55\u6709\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5728\u8054\u52a8\u5206\u5f55\u754c\u9762\u7ef4\u62a4\u518d\u91cd\u65b0\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"AdjustAutoAuditOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected boolean isSysToMDD() {
        return true;
    }
}

