/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.model.AdjustBalanceCheckModel;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;

public class AdjustBalanceCheckReportOperation
extends AbstractAdjustOperation {
    private final long scenario;
    private final long year;
    private final long period;
    private AdjustBalanceCheckService adjustBalanceCheckService;

    public AdjustBalanceCheckReportOperation(Long modelId, Long scenario, Long year, Long period, List<Long> pkids) {
        super(modelId, pkids);
        this.scenario = scenario;
        this.year = year;
        this.period = period;
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        e.addValidator(new AdjustCheckPermValidator(Boolean.FALSE));
    }

    @Override
    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        queryParam.setLoadType(2);
        queryParam.addAdjustField("process");
        queryParam.addAdjustField("entity");
        queryParam.addAdjustField("sourcetype");
        queryParam.addAdjustField("multiplecurrency");
        queryParam.addAdjustField("cvtbeforecurrency");
        queryParam.addAdjustField("templatecatalog");
        queryParam.addAdjustField("balancetype");
        this.actx.getSctx().getDimensions().stream().forEach(e -> {
            String fieldmapped = e.getFieldmapped();
            queryParam.addEntryField(fieldmapped);
            queryParam.addEntryField(fieldmapped + ".number");
        });
        queryParam.addEntryField("id");
        queryParam.addEntryField("adjust");
        queryParam.addEntryField("adjust.id");
        queryParam.addEntryField("adjust.entity");
        queryParam.addEntryField("isdefaultcurrency");
        queryParam.addEntryField("entrysource");
        queryParam.addEntryField("entryrowtype");
        queryParam.addEntryField("groupnum");
        queryParam.addEntryField("entity");
        queryParam.addEntryField("merge");
        queryParam.addEntryField("merge.number");
        queryParam.addEntryField("dseq");
        queryParam.addEntryField("groupnum");
        queryParam.addEntryField("cvtbeforecredit");
        queryParam.addEntryField("credit");
        queryParam.addEntryField("cvtbeforedebit");
        queryParam.addEntryField("debit");
    }

    @Override
    protected void beforeExcute() {
        this.adjustBalanceCheckService = new AdjustBalanceCheckService(this.getModelId());
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        Map<String, AdjustBalanceCheckModel> res = this.adjustBalanceCheckService.checkAdjustBalance(adjustDy, adjustDatas);
        BalanceTypeEnum enumByIndex = BalanceTypeEnum.getEnumByIndex((int)adjustDy.getInt("balancetype"));
        List<String> infos = this.adjustBalanceCheckService.getNonBalanceDataWithInfo(enumByIndex, res);
        infos.stream().forEach(e -> this.addWarnOper(adjustDy.getString("number"), adjustDy.getLong("id"), (String)e));
        this.addSuccessOper(adjustDy.getLong("id"));
    }

    @Override
    protected void afterExcute() {
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", this.getModelId());
        param.put("scenario", this.scenario);
        param.put("year", this.year);
        param.put("period", this.period);
        return param;
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.CHECK_BALANCE_OPERATION;
    }
}

