/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.convert.AdjustRateDiffCreateService;
import kd.fi.bcm.business.adjust.formula.AdjustDefaultFormulaValueHandler;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.CalcLine;
import kd.fi.bcm.business.adjust.model.CalcLinePool;
import kd.fi.bcm.business.adjust.model.CommonAdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.CommonTemplateEntry;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.DebugLogCollector;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.util.AdjustTemplateHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.TemplateModelValidator.CommonAdjustTemplateModelValidator;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustBuilder;
import kd.fi.bcm.common.adjust.AdjustHeadDyn;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.adjust.IAdjustEntry;
import kd.fi.bcm.common.adjust.IAdjustHead;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.invest.InvProcessEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdjustBatchCreateCommonEntryOperation {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustBatchCreateCommonEntryOperation.class);
    private static final Log log = LogFactory.getLog(AdjustBatchCreateCommonEntryOperation.class);
    private final AdjustOperationContext ctx;
    private final AdjustValidatorExecute<List<CommonAdjustTemplateModel>> validatorExecute;
    private int elimTemplateType = 1;
    private int generatCount = 0;
    protected List<String> specifiedProcess = null;
    private List<CommonAdjustTemplateModel> commonAdjustTemplateModels;
    private final IDNumberTreeNode unitOrgTreeNode;
    private CalculateService calcService;
    private final Set<Long> noBlAdjustIds = new HashSet<Long>(16);
    protected List<DynamicObject> adjusts = new ArrayList<DynamicObject>();
    protected List<DynamicObject> entries = new ArrayList<DynamicObject>();
    private final AdjustConvertService adjConvertSer;
    private final AdjustRateDiffCreateService createRateDiffSer;
    private AdjustBalanceCheckService adjustBalanceCheckService;
    private final DebugLogCollector debugLogCollector;
    private Collection<Long> templateIds;
    private final Map<Long, Long> permClassCopyMap = new HashMap<Long, Long>(100);

    public AdjustBatchCreateCommonEntryOperation(AdjustOperationContext ctx, long unitOrgId) {
        this.ctx = ctx;
        this.unitOrgTreeNode = MemberReader.findEntityMemberById((String)ctx.getModelNum(), (Long)unitOrgId);
        this.validatorExecute = new AdjustValidatorExecute(ctx);
        this.adjConvertSer = new AdjustConvertService(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId());
        this.createRateDiffSer = new AdjustRateDiffCreateService(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId());
        this.adjustBalanceCheckService = new AdjustBalanceCheckService(ctx.getModelId());
        this.debugLogCollector = new DebugLogCollector();
    }

    public AdjustBatchCreateCommonEntryOperation(AdjustOperationContext ctx, long unitOrgId, Collection<Long> templateIds) {
        this(ctx, unitOrgId);
        this.templateIds = templateIds;
    }

    public void setElimTemplateType(int elimTemplateType) {
        this.elimTemplateType = elimTemplateType;
    }

    public Pair<Integer, String> generate() {
        try {
            Map<Long, String> noNeedCreateSet = this.deleteAllAutoCommonAdjust();
            this.beforeInitParam();
            if (this.buildCommonAdjustTemplateModel(noNeedCreateSet)) {
                return Pair.onePair((Object)this.generatCount, (Object)this.debugLogCollector.log());
            }
            this.afterInitParam();
            for (List<CommonAdjustTemplateModel> models : this.sortCommonAdjustTemplateModel()) {
                CalcLinePool<CalcLine> calcPool = this.calculateExpression();
                PlatUtil.executeWithTX(tx -> {
                    this.buildCommonAdjustRecord(models, calcPool);
                    this.saveData();
                });
            }
        }
        catch (Throwable t) {
            return Pair.onePair((Object)0, (Object)AdjustmentServiceHelper.toString_Adj(t));
        }
        return Pair.onePair((Object)this.generatCount, (Object)this.debugLogCollector.log());
    }

    private Map<Long, String> deleteAllAutoCommonAdjust() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.ctx.getModelId());
        qfBuilder.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qfBuilder.add("year", "=", (Object)this.ctx.getFyId());
        qfBuilder.add("period", "=", (Object)this.ctx.getPeriodId());
        qfBuilder.add("process", "in", this.getProcesses());
        qfBuilder.add("entity.number", "=", (Object)this.unitOrgTreeNode.getNumber());
        qfBuilder.add("sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.COMMON_PAPER.getValue() + ""));
        if (!CollectionUtil.isEmpty(this.templateIds)) {
            qfBuilder.add("extend", "in", this.templateIds);
        }
        HashMap src2LinkMap = new HashMap(16);
        HashMap auditSet = new HashMap(16);
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(new HashSet<String>(Arrays.asList("status", "extend", "extendfrom", "id")), qfBuilder, null, -1);){
            ds.forEachRemaining(row -> {
                src2LinkMap.put(row.getLong("id"), row.getLong("extend"));
                if (RptAdjustStatusEnum.AUDIT.status().equals(row.getString("status"))) {
                    auditSet.put(row.getLong("id"), row.getString("extendfrom"));
                }
            });
        }
        HashMap<Long, String> noNeedCreateSet = new HashMap<Long, String>(16);
        if (!src2LinkMap.isEmpty()) {
            Map<Long, HashBasedTable<Long, Long, List<String>>> delLockScope = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55\u6a21\u677f\uff08\u5220\u9664\u5386\u53f2\u5206\u5f55\uff09", (String)"AdjustBatchCreateCommonEntryOperation_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, auditSet.keySet(), null);
            for (Long adjustId : new ArrayList(src2LinkMap.keySet())) {
                HashBasedTable<Long, Long, List<String>> detailTable = delLockScope.get(adjustId);
                if (detailTable == null) continue;
                Long extend = (Long)src2LinkMap.remove(adjustId);
                String extendfrom = (String)auditSet.get(adjustId);
                if (extendfrom == null) continue;
                if (detailTable.containsRow((Object)adjustId)) {
                    noNeedCreateSet.put(extend, String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"AdjustBatchCreateCommonEntryOperation_13", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.row((Object)adjustId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                    continue;
                }
                noNeedCreateSet.put(extend, String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8/\u5171\u4eab)%1$s[%2$s]", (String)"AdjustBatchCreateCommonEntryOperation_18", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
            }
            AdjustClearServiceHelper.batchDeleteAutoAdjust(ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55", (String)"AdjustBatchCreateCommonEntryOperation_8", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), new ArrayList<Long>(src2LinkMap.keySet()));
        }
        return noNeedCreateSet;
    }

    private Collection<List<CommonAdjustTemplateModel>> sortCommonAdjustTemplateModel() {
        TreeMap listTreeMap = this.commonAdjustTemplateModels.parallelStream().collect(Collectors.groupingBy(CommonAdjustTemplateModel::getExecuteOreder, () -> new TreeMap(Comparator.naturalOrder()), Collectors.toList()));
        return listTreeMap.values();
    }

    private void beforeInitParam() {
        this.validatorExecute.addValidator(new CommonAdjustTemplateModelValidator(this.debugLogCollector));
    }

    private Set<Long> createCommonOrgScopeMap(Long templateId) {
        HashSet<Long> result = new HashSet<Long>(16);
        Set<Long> orgIds = AdjustTemplateHelper.getAssignTemplateOrgDataRange(this.ctx.getModelId(), this.unitOrgTreeNode.getId(), templateId);
        if (!CollectionUtils.isEmpty(orgIds)) {
            Map<String, List<IDNumberTreeNode>> orgMap = orgIds.stream().map(orgId -> MemberReader.findEntityMemberById((Long)this.ctx.getModelId(), (Long)orgId)).collect(Collectors.groupingBy(IDNumberTreeNode::getNumber));
            Map<String, Set<Long>> effectiveOrgMap = InvestServiceHelper.queryEffectiveOrgMapCache(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.unitOrgTreeNode.getId());
            orgMap.remove(this.unitOrgTreeNode.getNumber());
            orgMap.forEach((orgNum, list) -> {
                Set idScope = list.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                Set effectiveIdList = (Set)effectiveOrgMap.get(orgNum);
                if (effectiveIdList != null && effectiveIdList.size() > 0) {
                    boolean isFind = false;
                    for (Long id : effectiveIdList) {
                        if (!idScope.contains(id)) continue;
                        result.add(id);
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        this.debugLogCollector.addDebugLog(log -> log.put((Object)ResManager.loadKDString((String)"\u5df2\u5931\u6548\u6216\u4e0d\u53c2\u4e0e\u5408\u5e76\u7684\u7ec4\u7ec7\u7f16\u7801\uff1a%s", (String)"AdjustBatchCreateCommonEntryOperation_5", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
                    }
                } else {
                    this.debugLogCollector.addDebugLog(log -> log.put((Object)ResManager.loadKDString((String)"\u5df2\u5931\u6548\u6216\u4e0d\u53c2\u4e0e\u5408\u5e76\u7684\u7ec4\u7ec7\u7f16\u7801\uff1a%s", (String)"AdjustBatchCreateCommonEntryOperation_5", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
                }
            });
            this.debugLogCollector.end(String.format("/**\u6267\u884c\u8fc7\u7a0b\u4e3a%s\u7684\u8c03\u8bd5\u65e5\u5fd7**/{", this.getProcesses()), ",");
            return result;
        }
        return Collections.emptySet();
    }

    protected boolean buildCommonAdjustTemplateModel(Map<Long, String> noNeedCreateSet) {
        Collection<Long> tempIdCollection = AdjustTemplateHelper.getAssignOrgNumToTempIdCache(this.ctx.getModelId(), this.ctx.getScenarioId(), this.unitOrgTreeNode.getNumber(), TemplateCatalogEnum.PRTADJUST.getTemplatetype());
        if (!CollectionUtil.isEmpty(this.templateIds)) {
            tempIdCollection.retainAll(this.templateIds);
        }
        if (!tempIdCollection.isEmpty()) {
            List<CommonAdjustTemplateModel> templs = AdjustTemplateHelper.getTemplateListCache(this.ctx.getModelId(), this.ctx.getScenarioId(), tempIdCollection);
            Collection<String> manualChangedTmpNumSet = this.collectManualChangedTmp(templs);
            List<String> processScope = this.getProcesses();
            this.commonAdjustTemplateModels = new ArrayList<CommonAdjustTemplateModel>(templs.size());
            Set<Long> effectiveTmpls = PaperTemplateHelper.queryEffectiveTmpls(this.ctx.getModelId(), this.ctx.getFyId(), this.ctx.getPeriodId(), new HashSet<Long>(tempIdCollection));
            for (CommonAdjustTemplateModel temp : templs) {
                if (noNeedCreateSet.containsKey(temp.getId())) {
                    this.debugLogCollector.addErrorLog(ResManager.loadKDString((String)"\u5386\u53f2\u5206\u5f55\u5df2\u7ecf\u5206\u9636\u6bb5\u6570\u636e\u9501\u5b9a\uff0c\u65e0\u6cd5\u6253\u56de,\u6d89\u53ca\u6a21\u677f\u5982\u4e0b\u6240\u793a\uff1a", (String)"AdjustBatchCreateCommonEntryOperation_15", (String)"fi-bcm-business", (Object[])new Object[0]), noNeedCreateSet.get(temp.getId()));
                    continue;
                }
                if (!effectiveTmpls.contains(temp.getId()) || manualChangedTmpNumSet.contains(temp.getNumber())) continue;
                String process = temp.getProcess();
                if (!processScope.contains(temp.getProcess()) || this.unitOrgTreeNode.isLeaf() && (OrgRelaProcessMembPool.isRelaProcess((String)process) || "DEJE".equals(process) || "DADJ".equals(process))) continue;
                temp.setMergeNode(this.unitOrgTreeNode);
                if (OrgRelaProcessMembPool.isRelaProcess((String)process)) {
                    temp.setOrgScope(this.createCommonOrgScopeMap(temp.getId()));
                } else {
                    temp.setOrgScope(Sets.newHashSet((Object[])new Long[]{this.unitOrgTreeNode.getId()}));
                }
                if (temp.getOrgScope().isEmpty()) continue;
                this.commonAdjustTemplateModels.add(temp);
            }
            this.validatorExecute.excute(this.commonAdjustTemplateModels);
            this.debugLogCollector.end(String.format("/**\u6267\u884c\u8fc7\u7a0b\u4e3a%s\u7684\u6a21\u677f\u8c03\u8bd5\u65e5\u5fd7**/{", this.getProcesses()));
        }
        return this.commonAdjustTemplateModels == null || this.commonAdjustTemplateModels.isEmpty();
    }

    private Collection<String> collectManualChangedTmp(List<CommonAdjustTemplateModel> tempList) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.ctx.getModelId());
        qfBuilder.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qfBuilder.add("year", "=", (Object)this.ctx.getFyId());
        qfBuilder.add("period", "=", (Object)this.ctx.getPeriodId());
        qfBuilder.add("process", "in", this.getProcesses());
        qfBuilder.add("extendfrom", "in", tempList.stream().map(p -> p.getNumber()).collect(Collectors.toList()));
        qfBuilder.add("entity", "=", (Object)this.unitOrgTreeNode.getId());
        qfBuilder.add("sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.MANUAL.getValue() + ""));
        Map<String, String> noManualChangedTmpMap = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"number,extendfrom", (QFilter[])qfBuilder.toArray()).parallelStream().collect(Collectors.toMap(p -> p.getString("number"), p -> p.getString("extendfrom")));
        this.debugLogCollector.addDebugLog(e -> {
            if (noManualChangedTmpMap.size() > 0) {
                noManualChangedTmpMap.forEach((adjnum, tmpNum) -> e.put(tmpNum, (Object)ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u5df2\u5b58\u5728\u624b\u5de5\u4fee\u6539\u4e14\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u81ea\u52a8\u5206\u5f55%s\uff0c\u4e0d\u53ef\u81ea\u52a8\u751f\u6210\u3002", (String)"AdjustBatchCreateCommonEntryOperation_3", (String)"fi-bcm-business", (Object[])new Object[]{adjnum})));
            }
        });
        return noManualChangedTmpMap.values();
    }

    private void afterInitParam() {
    }

    protected CalcLinePool<CalcLine> calculateExpression() {
        CalcLinePool<CalcLine> pool = new CalcLinePool<CalcLine>();
        this.buildExpression(pool);
        this.calcService = new CalculateService(this.getCalContext(pool));
        this.parseExpression(pool);
        this.doCalculate(pool);
        return pool;
    }

    private CommonTemplateEntry transformAndCloneEntry(Long orgId, CommonTemplateEntry entry) {
        CommonTemplateEntry clone = entry.clone();
        Object o = clone.getRowData().get(DimTypesEnum.MYCOMPANY.getNumber());
        if (o != null) {
            IDNumberTreeNode var = MemberReader.findMemberById((String)this.ctx.getModelNum(), (String)"bcm_mycompanymembertree", (Long)((Long)o));
            if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(var.getNumber())) {
                IDNumberTreeNode org = MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)orgId);
                IDNumberTreeNode realMc = MemberReader.findMemberByNumber((String)this.ctx.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)org.getNumber());
                if (realMc != IDNumberTreeNode.NotFoundTreeNode) {
                    clone.getRowData().put(DimTypesEnum.MYCOMPANY.getNumber(), realMc.getId());
                }
            }
        }
        return clone;
    }

    private void buildExpression(CalcLinePool<CalcLine> pool) {
        for (CommonAdjustTemplateModel temp : this.commonAdjustTemplateModels) {
            for (Long orgId : temp.getOrgScope()) {
                for (CommonTemplateEntry entry : temp.getEntries()) {
                    CalcLine line = new CalcLine();
                    line.setOrgId(orgId);
                    line.setRow(entry.getRow());
                    line.setEntry(this.transformAndCloneEntry(orgId, entry));
                    line.setTmp(temp);
                    line.setSpreadManager(temp.getSpreadManager());
                    line.setUnitOrgTreeNode(this.unitOrgTreeNode);
                    line.setLineId(temp.getNumber() + "#" + orgId + "#" + line.getRow());
                    if (entry.isHasFormula()) {
                        if (entry.isBalanceLine()) {
                            pool.add(temp.getId(), line);
                            continue;
                        }
                        for (String formula : entry.getFloatFormulas()) {
                            line = line.clone();
                            line.setRuleExpr(formula);
                            pool.add(temp.getId(), line);
                        }
                        continue;
                    }
                    line.setValue(entry.getValue());
                    pool.add(temp.getId(), line);
                }
            }
        }
    }

    private void parseExpression(CalcLinePool<CalcLine> calcPool) {
        calcPool.forEach(line -> {
            if (StringUtils.isNotEmpty((String)line.getRuleExpr()) && !line.getEntry().isBalanceLine()) {
                try {
                    Expression expr = ExcelFormulaPaserHelper.parse((String)line.getRuleExpr());
                    expr = AdjustFormulaParseHelper.walkExpress(this.ctx, expr, line);
                    line.setRuleExpr(expr.toString());
                    line.setStatus(this.calcService.addCalculateExpress4Book(line.getRuleExpr(), line.getLineId()));
                }
                catch (Throwable e) {
                    LOG.error(e);
                    if (line.getRuleExpr() == null) {
                        line.setRuleExpr("");
                    }
                    line.setRuleExpr(line.getRuleExpr().concat(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBatchCreateCommonEntryOperation_6", (String)"fi-bcm-business", (Object[])new Object[0])));
                }
            }
        });
    }

    private void doCalculate(CalcLinePool<CalcLine> calcPool) {
        this.calcService.batchCalculate();
        calcPool.forEach(line -> {
            if (line.getStatus() == null) {
                log.error((Object)String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e3a%1$s\uff0c\u76f8\u5173\u53c2\u6570\u4e3a%2$s", (String)"AdjustBatchCreateCommonEntryOperation_11", (String)"fi-bcm-business", (Object[])new Object[0]), line.getRuleExpr(), line));
            } else if (line.getStatus().hasException()) {
                line.setDebugFormula(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff0c\u516c\u5f0f\u4e3a%1$s\uff0c\u76f8\u5173\u53c2\u6570\u4e3a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a%3$s", (String)"AdjustBatchCreateCommonEntryOperation_10", (String)"fi-bcm-business", (Object[])new Object[0]), line.getRuleExpr(), this.calcService.trans2FormulaEexprss(line.getStatus()) + "=" + this.calcService.trans2EvalExpress(line.getStatus()), AdjustmentServiceHelper.toString_Adj(line.getStatus().getException())));
            } else {
                line.setValue(InvestUtils.convertToBigDecimal(this.calcService.evalExpress(line.getStatus())));
                line.setDebugFormula(this.calcService.trans2FormulaEexprss(line.getStatus()) + "=" + this.calcService.trans2EvalExpress(line.getStatus()));
            }
            if (line.getValue() == null) {
                line.setValue(BigDecimal.ZERO);
            }
        });
        this.calcService.clear();
    }

    private CalContext getCalContext(CalcLinePool<CalcLine> calcPool) {
        CalContext calContext = new CalContext(this.ctx.getModelNum(), null, this.ctx.getFyNum(), this.ctx.getPeriodNum(), this.ctx.getScenariodNum(), this.unitOrgTreeNode.getCurrency());
        calContext.setProperty("orgUnitId", this.unitOrgTreeNode.getId());
        calContext.setProperty("orgUnitNumber", this.unitOrgTreeNode.getNumber());
        calContext.setProperty("modelId", this.ctx.getModelId());
        calContext.setProperty("yearId", this.ctx.getFyId());
        calContext.setProperty("periodId", this.ctx.getPeriodId());
        calContext.setProperty("scenarioId", this.ctx.getScenarioId());
        calContext.setDefaultParamHandle(new AdjustDefaultFormulaValueHandler(calContext, calcPool));
        return calContext;
    }

    protected void buildCommonAdjustRecord(List<CommonAdjustTemplateModel> models, CalcLinePool calcPool) {
        boolean isDebugModel = DebugServiceHelper.isDebugInvElim();
        HashMap groupBanlanceLineMap = new HashMap(16);
        AdjustBuilder adjustBuilder = new AdjustBuilder(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), AdjustHeadDyn::new);
        adjustBuilder.addSingleAdjustAfterHandler(adjustHead -> this.genAdjustBalanceLineData((AdjustBuilder<IAdjustHead>)adjustBuilder, groupBanlanceLineMap, (IAdjustHead)adjustHead));
        adjustBuilder.setCodeRuleFunc(String[]::new);
        for (CommonAdjustTemplateModel template : models) {
            String currencyNum;
            List<CalcLine> entries = calcPool.searchByTmpId(template.getId());
            if (CollectionUtil.isEmpty(entries)) continue;
            this.fillTemplateModel(template);
            boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)template.getProcess());
            LinkedHashMap<Long, List> orgMap = new LinkedHashMap<Long, List>(16);
            entries.forEach(e -> orgMap.computeIfAbsent(e.getOrgId(), v -> new ArrayList()).add(e));
            boolean isDEblance = BalanceTypeEnum.BALANCE.getIndex() == template.getBalancetype();
            String string = currencyNum = "1".equals(template.getMultiplecurrency()) ? MemberReader.findCurrencyMemberById((String)this.ctx.getModelNum(), (Long)template.getCvtBeforeCurrencyId()).getNumber() : this.unitOrgTreeNode.getCurrency();
            if (hasMerge) {
                adjustBuilder.newAdjustHead(adjustHead -> this.genHeadDyna(template, (IAdjustHead)adjustHead));
            }
            AtomicInteger groupIndex = new AtomicInteger(1);
            orgMap.forEach((orgId, lines) -> {
                if (!hasMerge) {
                    adjustBuilder.newAdjustHead(adjustHead -> this.genHeadDyna(template, (IAdjustHead)adjustHead));
                }
                lines.forEach(line -> {
                    String groupNum = "G" + groupIndex.get();
                    String templGroupNum = line.getEntry().getRowData().computeIfAbsent("groupnum", r -> "").toString();
                    if (StringUtils.isNotEmpty((String)templGroupNum)) {
                        groupNum = groupNum.concat(".").concat(templGroupNum);
                    }
                    if (line.getEntry().isBalanceLine()) {
                        groupBanlanceLineMap.computeIfAbsent(adjustBuilder.getCurrent().getId(), k -> new HashMap(16)).put(isDEblance ? groupNum : MemberReader.findEntityMemberById((Long)this.ctx.getModelId(), (Long)orgId).getNumber(), Pair.onePair((Object)template, (Object)line));
                    } else if (isDebugModel || line.getValue() != null && line.getValue().compareTo(BCMConstant.Zero) != 0) {
                        IDNumberTreeNode accountNode = MemberReader.findMemberById((String)this.ctx.getModelNum(), (String)"bcm_accountmembertree", (Long)((Long)line.getEntry().getRowData().get("Account")));
                        line.setValue(line.getValue().setScale((int)CurrencyScaleHandler.getNewCurrencyScale(this.ctx.getModelId(), this.ctx.getScenariodNum(), currencyNum, accountNode.getNumber()), RoundingMode.HALF_UP));
                        adjustBuilder.addEntry(groupNum, (adjustHead, adjustData) -> this.genEntryDyna(hasMerge, template, (CalcLine)line, (IAdjustEntry)adjustData));
                    }
                });
                if (hasMerge) {
                    groupIndex.getAndIncrement();
                }
            });
        }
        Pair adjustPs = adjustBuilder.buildDynamic();
        Set adjustIds = ((Map)adjustPs.p2).keySet();
        for (Long next : new HashSet<Long>(this.permClassCopyMap.keySet())) {
            if (adjustIds.contains(next)) continue;
            this.permClassCopyMap.remove(next);
        }
        this.adjusts.addAll((Collection)adjustPs.p1);
        for (DynamicObject adjust : this.adjusts) {
            Collection adjustDatas = (Collection)((Map)adjustPs.p2).get(adjust.getLong("id"));
            AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)adjust, (Collection)adjustDatas, (boolean)false);
            this.entries.addAll(this.dealMutiCurrencyEntries(adjust, (List)adjustDatas));
        }
    }

    private List<DynamicObject> dealMutiCurrencyEntries(DynamicObject elim, List<DynamicObject> tempResult) {
        if (!this.unitOrgTreeNode.isLeaf() && elim.getBoolean("multiplecurrency")) {
            ArrayList<DynamicObject> entries = new ArrayList<DynamicObject>(tempResult.size() * 3);
            for (DynamicObject dy : tempResult) {
                entries.add(dy);
                Set<Long> currencySet = AdjustConvertUtil.getMultipleCurrency(this.ctx.getModelId(), this.unitOrgTreeNode.getId(), elim.getString("bussnesstype"));
                for (Long curId : currencySet) {
                    DynamicObject otherCurrDy = AdjustOperationHelper.copyDynamicObject(dy, false);
                    otherCurrDy.set("currency", (Object)curId);
                    otherCurrDy.set("isdefaultcurrency", (Object)0);
                    entries.add(otherCurrDy);
                }
            }
            this.adjConvertSer.batchConvert(entries);
            return this.createRateDiffSer.createRateDiffSingleElim(entries, true);
        }
        return tempResult;
    }

    private void fillTemplateModel(CommonAdjustTemplateModel template) {
        template.getCommDimensionEntries().forEach(com -> {
            Member m = new Member();
            if ("Year".equals(com.getDimension().getNumber())) {
                m.setId(this.ctx.getFyId());
                com.setMember(m);
            } else if ("Scenario".equals(com.getDimension().getNumber())) {
                m.setId(this.ctx.getScenarioId());
                com.setMember(m);
            } else if ("Period".equals(com.getDimension().getNumber())) {
                m.setId(this.ctx.getPeriodId());
                com.setMember(m);
            }
        });
    }

    protected void genHeadDyna(CommonAdjustTemplateModel template, IAdjustHead adjustHead) {
        adjustHead.setLinkcreatetype(AdjustLinkCreateEnum.COMMONADJUST);
        BusinessTypeEnum buss = BusinessTypeEnum.searchByName((String)template.getBussnesstype());
        adjustHead.setName(template.getName() + "_" + this.ctx.getFyNum());
        adjustHead.setBussnesstype(buss);
        adjustHead.setStatus(RptAdjustStatusEnum.TEMPSAVE);
        adjustHead.set("multiplecurrency", (Object)template.getMultiplecurrency());
        adjustHead.setCvtBeforeCurrency(Long.valueOf(template.getCvtBeforeCurrencyId()));
        adjustHead.setEntity(this.unitOrgTreeNode.getId());
        adjustHead.setJournaltype(JournalTypeEnum.getEumByKey((String)(template.getJournaltype() + "")));
        adjustHead.setBalancetype(BalanceTypeEnum.getEnumByIndex((int)template.getBalancetype()));
        adjustHead.setLinkcreatetype(AdjustLinkCreateEnum.searchByStatus((String)template.getLinkCreateType()));
        adjustHead.setDescription(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210-\u8c03\u6574\u5e95\u7a3f\u5206\u5f55", (String)"AdjustBatchCreateCommonEntryOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        adjustHead.set("entrysource", (Object)"0");
        adjustHead.setSourceType(ElimRptAdjSourceTypeEnum.COMMON_PAPER);
        adjustHead.set("extendfrom", (Object)template.getNumber());
        adjustHead.set("extend", (Object)template.getId());
        adjustHead.set("templatecatalog", (Object)template.getAdjustCatalogId());
        if (template.getPermClass() != null) {
            this.permClassCopyMap.put(adjustHead.getId(), ((JSONObject)template.getPermClass()).getLong("id"));
        }
        template.getCommDimensionEntries().forEach(comm -> adjustHead.addCommonPageMemberDim(Long.valueOf(comm.getDimension().getId()), Long.valueOf(comm.getMember().getId()), Integer.valueOf(comm.getSeq())));
        template.getSpreadDimensionEntries().forEach(spreadDimensionEntry -> adjustHead.addSpreadMemberDim(Long.valueOf(spreadDimensionEntry.getDimension().getId()), Integer.valueOf(spreadDimensionEntry.getSeq())));
    }

    protected void genEntryDyna(boolean hasMerge, CommonAdjustTemplateModel template, CalcLine line, IAdjustEntry adjustData) {
        template.getSpreadDimensionEntries().forEach(spread -> adjustData.set(this.ctx.getSctx().getDimensionByNumber(spread.getDimension().getNumber()).getFieldmapped(), line.getEntry().getRowData().get(spread.getDimension().getNumber())));
        adjustData.setEntity(line.getOrgId());
        if (hasMerge) {
            adjustData.setMerge(this.unitOrgTreeNode.getId().longValue());
            adjustData.setCurrencyId(MemberReader.findCurrencyMemberByNum((String)this.ctx.getModelNum(), (String)this.unitOrgTreeNode.getCurrency()).getId());
        } else {
            IDNumberTreeNode curNode = MemberReader.findCurrencyMemberById((String)this.ctx.getModelNum(), (Long)adjustData.getCurrencyId());
            IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)adjustData.getEntity());
            IDNumberTreeNode processNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Process", (long)adjustData.getProcessId());
            String currencyNum = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)orgNode, (long)this.ctx.getModelId(), (String)processNode.getNumber(), (String)curNode.getNumber()).p2;
            adjustData.setCurrencyId(MemberReader.findCurrencyMemberByNum((String)this.ctx.getModelNum(), (String)currencyNum).getId());
        }
        adjustData.setDescription(line.getEntry().getRowData().computeIfAbsent("description", k -> "").toString());
        String calculatecontent = line.getEntry().getRowData().computeIfAbsent("calculatecontent", k -> "").toString();
        if (!StringUtils.isEmpty((String)line.getDebugFormula())) {
            calculatecontent = calculatecontent.concat("[").concat(line.getDebugFormula()).concat("]");
        }
        adjustData.set("calculatecontent", (Object)calculatecontent);
        adjustData.setEntrySource(EntrySourceEnum.MANUALCREATE);
        if (line.getEntry().getDc() == DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS) {
            adjustData.setDebit(line.getValue());
        } else {
            adjustData.setCredit(line.getValue());
        }
        adjustData.set("ruleexpr", (Object)line.getRuleExpr());
        adjustData.set("entrysource", (Object)10);
        AdjustOperationHelper.transformMyCompanyVars(this.ctx.getModelNum(), adjustData.genDynamic());
    }

    private void genAdjustBalanceLineData(AdjustBuilder<IAdjustHead> adjustBuilder, Map<Long, Map<String, Pair<CommonAdjustTemplateModel, CalcLine>>> groupBanlanceLineMap, IAdjustHead adjustHead) {
        boolean balanceFlag;
        boolean isNoBalance;
        if (adjustHead.getEntrys().isEmpty()) {
            return;
        }
        Map<String, Pair<CommonAdjustTemplateModel, CalcLine>> groupBalanceMap = groupBanlanceLineMap.remove(adjustHead.getId());
        Pair pair = adjustHead.genDynamic();
        BalanceTypeEnum balanceTypeEnum = BalanceTypeEnum.getEnumByIndex((int)((DynamicObject)pair.p1).getInt("balancetype"));
        boolean bl = isNoBalance = BalanceTypeEnum.UNBALANCE.getIndex() == balanceTypeEnum.getIndex();
        if (isNoBalance && (groupBalanceMap == null || groupBalanceMap.isEmpty())) {
            return;
        }
        if (isNoBalance) {
            balanceTypeEnum = BalanceTypeEnum.BALANCEWITHORG;
        }
        if (balanceFlag = this.adjustBalanceCheckService.computeIfNoBalance(balanceTypeEnum, (DynamicObject)pair.p1, (Collection)pair.p2, e -> {
            Pair tmpcCalcLine;
            Pair pair = tmpcCalcLine = groupBalanceMap != null ? (Pair)groupBalanceMap.get(e.getGroupKey()) : null;
            if (tmpcCalcLine == null && !isNoBalance) {
                adjustHead.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
                this.noBlAdjustIds.add(adjustHead.getId());
            } else if (tmpcCalcLine != null) {
                List rows = e.getRows();
                DynamicObject dy = (DynamicObject)rows.get(rows.size() - 1);
                String groupnum = dy.getString("groupnum");
                boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)adjustHead.getProcess());
                CalcLine balanceLine = (CalcLine)tmpcCalcLine.p2;
                BigDecimal diffSum = e.getDiffSum();
                balanceLine.setValue(balanceLine.getEntry().getDc() == DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS ? diffSum.negate() : diffSum);
                adjustBuilder.addEntry(groupnum, (adjust, adjustData) -> {
                    this.genEntryDyna(hasMerge, (CommonAdjustTemplateModel)tmpcCalcLine.p1, (CalcLine)tmpcCalcLine.p2, (IAdjustEntry)adjustData);
                    this.adjustBalanceCheckService.resetAdjustDataMoneyRedirect(adjustData.genDynamic());
                    List groupnum1 = adjust.getEntrys().stream().filter(a -> a.get("groupnum").toString().equals(groupnum)).collect(Collectors.toList());
                    Integer showseq = (Integer)((IAdjustEntry)groupnum1.get(groupnum1.size() - 1)).get("showseq");
                    adjustData.set("showseq", (Object)(showseq + 1));
                });
            }
        })) {
            AdjustConvertUtil.setAdjustDataShowSeq((Collection)adjustHead.genDynamic().p2, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
        }
    }

    protected void saveData() {
        this.generatCount += this.adjusts.size();
        if (!this.adjusts.isEmpty()) {
            AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", this.adjusts);
            BusinessDataWriter.save((IDataEntityType)this.adjusts.get(0).getDataEntityType(), (Object[])this.adjusts.toArray());
            this.adjusts.forEach(elim -> {
                Long permClassId = this.permClassCopyMap.get(elim.getLong("id"));
                if (permClassId != null) {
                    PermClassEntityHelper.savePermClass("bcm_rptadjust", elim.getLong("id"), this.ctx.getModelId(), permClassId);
                }
            });
        }
        if (!this.entries.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.entries.toArray(new DynamicObject[0]));
        }
        List<Long> auditElimIds = this.adjusts.stream().filter(e -> !this.noBlAdjustIds.contains(e.getLong("id"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        List<Long> sourceIds = this.adjusts.stream().filter(e -> AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus().equals(e.getString("linkcreatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        Map<Object, Object> sourceId2LinkageIdMap = Collections.emptyMap();
        if (!sourceIds.isEmpty()) {
            LinkageMappingService linkageMappingService = new LinkageMappingService((Long)this.ctx.getModelId(), (Long)this.ctx.getFyId(), (Long)this.ctx.getScenarioId(), (Long)this.ctx.getPeriodId(), sourceIds, false);
            LinkageDataCollector linkageDataCollector = linkageMappingService.buildAutoElimLinkage();
            sourceId2LinkageIdMap = linkageDataCollector.getSourceId2LinkageIdMap();
            this.entries.addAll(linkageDataCollector.getCreateLinkageDatas());
            if (linkageDataCollector.getRetainHistoryLinkDatas() != null) {
                this.entries.addAll(Arrays.asList(linkageDataCollector.getRetainHistoryLinkDatas()));
            }
        }
        HashBasedTable<Long, Long, List<String>> newLockScope = AdjustOperationHelper.batchCheckOlapDataLock(ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55\u6a21\u677f\uff08\u751f\u6210\u65b0\u5206\u5f55\uff09", (String)"AdjustBatchCreateCommonEntryOperation_16", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, this.entries, null);
        HashSet<DynamicObject> toSaveStatusSet = new HashSet<DynamicObject>(16);
        Long linkId = 0L;
        for (DynamicObject elim2 : this.adjusts) {
            Long elimId = elim2.getLong("id");
            linkId = sourceId2LinkageIdMap.getOrDefault(elimId, 0L);
            if (this.noBlAdjustIds.contains(elimId)) {
                auditElimIds.remove(elimId);
                continue;
            }
            if (newLockScope.containsRow((Object)elimId)) {
                elim2.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                toSaveStatusSet.add(elim2);
                auditElimIds.remove(elimId);
                this.debugLogCollector.addErrorLog(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u6570\u636e\u5df2\u7ecf\u5206\u9636\u6bb5\u9501\u5b9a\uff0c\u5df2\u81ea\u52a8\u8f6c\u4e3a\u4fdd\u5b58\uff0c\u5982\u4e0b\u6240\u793a : ", (String)"AdjustBatchCreateCommonEntryOperation_17", (String)"fi-bcm-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimGenerateService_15", (String)"fi-bcm-business", (Object[])new Object[0]), elim2.getString("extendfrom"), newLockScope.row((Object)elimId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                continue;
            }
            if (newLockScope.containsRow((Object)linkId)) {
                elim2.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                toSaveStatusSet.add(elim2);
                auditElimIds.remove(elimId);
                this.debugLogCollector.addErrorLog(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u6570\u636e\u5df2\u7ecf\u5206\u9636\u6bb5\u9501\u5b9a\uff0c\u5df2\u81ea\u52a8\u8f6c\u4e3a\u4fdd\u5b58\uff0c\u5982\u4e0b\u6240\u793a : ", (String)"AdjustBatchCreateCommonEntryOperation_17", (String)"fi-bcm-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8)%1$s[%2$s]", (String)"AdjustBatchCreateCommonEntryOperation_14", (String)"fi-bcm-business", (Object[])new Object[0]), elim2.getString("extendfrom"), newLockScope.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                continue;
            }
            if (!LongUtil.isvalidLong((Object)linkId)) continue;
            auditElimIds.add(linkId);
        }
        if (!toSaveStatusSet.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])toSaveStatusSet.toArray(new DynamicObject[0]));
        }
        if (!auditElimIds.isEmpty()) {
            AdjustCheckServiceHelper.doSysToMdd(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), auditElimIds, true);
        }
        this.debugLogCollector.end("");
        this.adjusts.clear();
        this.entries.clear();
    }

    private List<String> getProcesses() {
        List process;
        if (this.specifiedProcess != null) {
            return new ArrayList<String>(this.specifiedProcess);
        }
        switch (this.elimTemplateType) {
            case 1: {
                process = InvProcessEnum.getAllNumber();
                process.removeAll(InvProcessEnum.getAllADJNumber());
                break;
            }
            case 2: {
                process = Lists.newArrayList((Object[])new String[]{"RAdj", "ERAdj"});
                break;
            }
            default: {
                process = Lists.newArrayList((Object[])new String[]{"IRpt", "ADJ", "EJE", "EOE", "EOther"});
            }
        }
        return process;
    }

    public void setSpecifiedProcess(List<String> process) {
        this.specifiedProcess = process;
    }
}

