/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustCopyOperation;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustChargeCheckValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustChargeOperation
extends AdjustCopyOperation {
    public AdjustChargeOperation(Long modelId, Long tarScene, Long tarYear, Long tarPeriod, List<Long> pkids) {
        super(modelId, tarScene, tarYear, tarPeriod, pkids, true);
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        e.getCtx().addUserObject("tarYear", this.tarYear.getLong("id"));
        e.getCtx().addUserObject("tarPeriod", this.tarPeriod.getLong("id"));
        e.addValidator(new AdjustCheckPermValidator());
        e.addOnlyWarningValidator(new AdjustCheckDimMemValidator());
        e.addOnlyWarningValidator(new AdjustCheckDataNotNullValidator());
        e.addValidator(new AdjustChargeCheckValidator());
    }

    @Override
    public void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
        LinkedHashMap adjustDyList = new LinkedHashMap(adjustDys.size());
        adjustDys.forEach(adjustDy -> adjustDyList.put(adjustDy.getLong("id"), adjustDy));
        HashMap link2SrcMap = new HashMap(adjustDys.size());
        ArrayList srcAdjustIdList = new ArrayList(adjustDys.size());
        adjustDys.forEach(p -> {
            boolean isLink;
            long linkSourceId = DynUtils.getBaseId((DynamicObject)p, (String)"linkagelinksource");
            boolean bl = isLink = p.getInt("sourcetype") == ElimRptAdjSourceTypeEnum.LINK.getValue();
            if (linkSourceId != 0L) {
                link2SrcMap.put(linkSourceId, DynUtils.getBaseId((DynamicObject)p, (String)"id"));
                if (isLink && !adjustDyList.containsKey(linkSourceId)) {
                    srcAdjustIdList.add(linkSourceId);
                }
            }
        });
        if (!link2SrcMap.isEmpty()) {
            srcAdjustIdList.removeAll(link2SrcMap.values());
            DynamicObject[] srcAdjustDys = BusinessDataServiceHelper.load((Object[])srcAdjustIdList.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectType());
            Arrays.stream(srcAdjustDys).forEach(srcAdjustDy -> this.src2DyMap.put(srcAdjustDy.getLong("id"), srcAdjustDy));
            DynamicObject[] linkEntries = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)this.getQueryParam().getEntryFieldStr(), (QFilter[])new QFilter("adjust", "in", link2SrcMap.keySet()).and("adjust.status", "=", (Object)RptAdjustStatusEnum.AUDIT.status()).toArray());
            Map<Long, List<DynamicObject>> src2LinkEntries = Arrays.stream(linkEntries).collect(Collectors.groupingBy(p -> link2SrcMap.getOrDefault(DynUtils.getBaseId((DynamicObject)p, (String)"adjust"), 0L)));
            src2LinkEntries.forEach((srcId, entries) -> adjustDatas.computeIfAbsent((Long)srcId, a -> Lists.newArrayList()).addAll(entries));
        }
    }

    @Override
    protected void dealElimOtherProperities(DynamicObject adjustDy, DynamicObject newElim) {
        newElim.set("journaltype", (Object)JournalTypeEnum.CHARGE_AGAINST.getKey());
        newElim.set("extend", (Object)adjustDy.getLong("id"));
        newElim.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.CHARGE.getValue());
        CharSequence[] strings = new String[]{adjustDy.getString("number"), adjustDy.getString("name"), adjustDy.getString("year.number"), adjustDy.getString("period.number")};
        newElim.set("description", (Object)String.format(ResManager.loadKDString((String)"\u6e90\u5206\u5f55\u4fe1\u606f:%s", (String)"AdjustChargeOperation_3", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)", ", strings)));
    }

    @Override
    protected void dealEntryOtherProperities(DynamicObject entryClone) {
        entryClone.set("debit", (Object)entryClone.getBigDecimal("debit").negate());
        entryClone.set("credit", (Object)entryClone.getBigDecimal("credit").negate());
        entryClone.set("summoney", (Object)entryClone.getBigDecimal("summoney").negate());
        entryClone.set("cvtbeforecredit", (Object)entryClone.getBigDecimal("cvtbeforecredit").negate());
        entryClone.set("cvtbeforesummoney", (Object)entryClone.getBigDecimal("cvtbeforesummoney").negate());
        entryClone.set("cvtbeforedebit", (Object)entryClone.getBigDecimal("cvtbeforedebit").negate());
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.CHARGEOPERATION;
    }
}

