/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.LinkageTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustCheckTarLinkRepeatOperation
extends AbstractAdjustOperation {
    private final long scenario;
    private final long year;
    private final long period;
    private final HashMultimap<String, DynamicObject> linkDeploy = HashMultimap.create();
    private final Map<Long, DimensionScope> linkApplyEntityMap = new HashMap<Long, DimensionScope>(16);
    private final Map<Long, String> linkDeployMsg = new HashMap<Long, String>(16);
    private static final Map<String, String> deployMap = new HashMap<String, String>();

    public AdjustCheckTarLinkRepeatOperation(Long modelId, Long scenario, Long year, Long period, List<Long> pkids) {
        super(modelId, pkids);
        this.scenario = scenario;
        this.year = year;
        this.period = period;
        this.actx.getSctx().removeIf(p -> p.isIssys() && !"account".equals(p.getFieldmapped()) && !"internalcompany".equals(p.getFieldmapped()) && !"audittrail".equals(p.getFieldmapped()) && !"changetype".equals(p.getFieldmapped()) && !"mycompany".equals(p.getFieldmapped()));
    }

    @Override
    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        queryParam.setLoadType(2);
        queryParam.addAdjustField("sourcetype");
        queryParam.addAdjustField("linkcreatetype");
        queryParam.addEntryField("id");
        queryParam.addEntryField("adjust.id");
        queryParam.addEntryField("isdefaultcurrency");
        queryParam.addEntryField("entrysource");
        queryParam.addEntryField("groupnum");
        queryParam.addEntryField("dseq");
        this.actx.getSctx().getFieldMap().keySet().forEach(field -> queryParam.addEntryField(field + ".number"));
    }

    @Override
    protected void beforeExcute() {
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getModelId());
        qf.add("id", "in", LinkageMappingServiceHelper.queryIds(this.getModelId(), this.scenario));
        qf.add("status", "=", (Object)"1");
        Collection filterLinks = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)this.getLinkEntrySelectField(), (QFilter[])qf.toArray()).values();
        List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(this.getModelId());
        filterLinks.forEach(link -> {
            if (ConvertDifferenceHandle.isApply(this.year, this.period, link.getDynamicObjectCollection("effective"), yearIdsList)) {
                link.getDynamicObjectCollection("entryentity").forEach(detailLink -> {
                    if (!LinkageTypeEnum.SOURCE.getIndex().equals(detailLink.getString("linkagetype"))) {
                        this.linkDeploy.put((Object)detailLink.getString("account.number").concat("!").concat(detailLink.getString("changetype.number")), detailLink);
                        this.linkDeployMsg.put(detailLink.getLong("id"), link.getString("number"));
                    }
                });
            }
        });
        if (this.linkDeploy.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8054\u52a8\u914d\u7f6e\u4fe1\u606f\u3002", (String)"AdjustCheckTarLinkRepeatOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        filterLinks.forEach(dys -> {
            DimensionScope entityScope = LinkageMappingServiceHelper.getApplyEntityScope(this.getModelId(), dys);
            if (entityScope != null) {
                this.linkApplyEntityMap.put(dys.getLong("id"), entityScope);
            }
        });
    }

    private String getLinkEntrySelectField() {
        HashSet<String> fields = new HashSet<String>(8);
        fields.add("id");
        fields.add("number");
        fields.add("entryentity.groupnum");
        fields.add("entryentity.seq");
        fields.add("entryentity.linkagetype");
        for (Dimension dim : this.actx.getSctx().getDimensions()) {
            fields.add(deployMap.get(dim.getFieldmapped()) + ".number");
        }
        fields.add("effective.effectiveyear");
        fields.add("effective.effectiveperiod");
        fields.add("effective.applytype");
        fields.add("effective.yearscope");
        fields.add("applyentity.entityisexcept");
        fields.add("applyentity.entitymeb");
        fields.add("applyentity.property");
        fields.add("applyentity.propertyvalue");
        fields.add("applyentity.entityrange");
        return String.join((CharSequence)",", fields);
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        String adjustNum = adjustDy.getString("number");
        if (ElimRptAdjSourceTypeEnum.LINK.getValue() == adjustDy.getInt("sourcetype") || ElimRptAdjSourceTypeEnum.AUTO.getValue() == adjustDy.getInt("sourcetype")) {
            this.addSuccessOper(adjustDy.getLong("id"));
        } else {
            adjustDatas.stream().filter(this::needCheck).forEach(adjustData -> {
                Set linkSchemeNums;
                String packKey = adjustData.getString("account.number").concat("!").concat(adjustData.getString("changetype.number"));
                Set linkDeployGroup = this.linkDeploy.get((Object)packKey);
                if (linkDeployGroup != null && linkDeployGroup.size() > 0 && (linkSchemeNums = linkDeployGroup.stream().filter(e -> this.applyEntity((DynamicObject)e, (DynamicObject)adjustData)).filter(linkScheme -> this.equals((DynamicObject)linkScheme, (DynamicObject)adjustData)).map(p -> String.format(ResManager.loadKDString((String)"%1$s\u7ec4%2$s\u5e8f\u53f7%3$s", (String)"AdjustCheckTarLinkRepeatOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]), this.linkDeployMsg.get(p.getLong("id")), p.getString("groupnum"), p.getString("seq"))).collect(Collectors.toSet())).size() > 0) {
                    this.addWarnOper(adjustNum, adjustDy.getLong("id"), String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7\u201c%1$s\u201d\u4e0b\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5206\u5f55\uff0c\u5176\u76ee\u6807\u8054\u52a8\u7c7b\u578b\u4e3a\u201d%3$s\u201d\u3002", (String)"AdjustCheckTarLinkRepeatOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]), adjustData.getString("groupnum"), adjustData.getString("dseq"), linkSchemeNums));
                }
            });
            this.addSuccessOper(adjustDy.getLong("id"));
        }
    }

    private boolean applyEntity(DynamicObject e, DynamicObject adjustData) {
        DimensionScope dimensionScope = this.linkApplyEntityMap.get(e.getLong("id"));
        if (dimensionScope == null) {
            return true;
        }
        String entityNum = OrgRelaProcessMembPool.isRelaProcess((String)adjustData.getString("process.number")) ? adjustData.getString("merge.number") : adjustData.getString("entity.number");
        return dimensionScope.contains(entityNum);
    }

    private boolean needCheck(DynamicObject adjustData) {
        if (!adjustData.getBoolean("isdefaultcurrency")) {
            return false;
        }
        return !Arrays.asList(2, 4, 6).contains(adjustData.getInt("entrysource"));
    }

    private boolean equals(DynamicObject linkScheme, DynamicObject adjustData) {
        return this.actx.getSctx().getDimensions().stream().filter(p -> !PresetConstant.AUDITTRIAL_DIM.equals(p.getNumber()) && !PresetConstant.ACCOUNT_DIM.equals(p.getNumber()) && !PresetConstant.CHANGETYPE_DIM.equals(p.getNumber())).allMatch(p -> {
            IDNumberTreeNode link = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)p.getNumber(), (String)linkScheme.getString(deployMap.get(p.getFieldmapped()) + ".number"));
            IDNumberTreeNode srcData = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)p.getNumber(), (String)adjustData.getString(p.getFieldmapped() + ".number"));
            return LinkageMappingServiceHelper.checkIsMatch(AdjustOperationHelper.createVersionParam(this.getModelId(), this.scenario, this.year, this.period), link, srcData, false);
        });
    }

    @Override
    protected void afterExcute() {
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", this.getModelId());
        param.put("scenario", this.scenario);
        param.put("year", this.year);
        param.put("period", this.period);
        return param;
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.CHECKTARLINKREPEATOPERATION;
    }

    static {
        deployMap.put("account", "account");
        deployMap.put("changetype", "changetype");
        deployMap.put("audittrail", "audittrial");
        deployMap.put("mycompany", "mycompany");
        deployMap.put("internalcompany", "intercompany");
        deployMap.put("dim1", "userdefined1");
        deployMap.put("dim2", "userdefined2");
        deployMap.put("dim3", "userdefined3");
        deployMap.put("dim4", "userdefined4");
        deployMap.put("dim5", "userdefined5");
        deployMap.put("dim6", "userdefined6");
    }
}

