/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.attachment.AdjustAttachmentHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.operation.IAdjustOperationLogService;
import kd.fi.bcm.business.adjust.trace.impl.AdjustDimOperationTraceLogImpl;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckArchiveStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AdjustClearOperation
extends AbstractAdjustOperation
implements IAdjustOperationLogService {
    private final Long scene;
    private final Long year;
    private final Long period;
    private boolean isAutoElim = false;
    private final Map<Long, Long> linksourceMap = new HashMap<Long, Long>();
    private final HashMultimap<Long, Long> share2Map = HashMultimap.create();
    private AdjustDimOperationTraceLogImpl traceLog;
    private Map<Long, Map<Long, String>> adjustDataTraceInfo;

    public AdjustClearOperation(Long modelId, Long scene, Long year, Long period, QFBuilder filter) {
        this(modelId, scene, year, period, QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])filter.toArray(), null, (int)-1).stream().map(LongUtil::toLong).collect(Collectors.toList()));
    }

    public AdjustClearOperation(Long modelId, Long scene, Long year, Long period, List<Long> pkids) {
        super(modelId, pkids);
        this.scene = scene;
        this.year = year;
        this.period = period;
        this.setOpenMutex(true);
    }

    @Override
    protected void beforeExcute() {
    }

    @Override
    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        super.onPrepareQueryParam(queryParam);
        if (this.isAutoElim) {
            queryParam.setLoadType(1);
            queryParam.addAdjustField("linkagelinksource");
            queryParam.addAdjustField("shareentry.shareadjust");
            queryParam.addAdjustField("status");
            queryParam.addAdjustField("entrysource");
            queryParam.addEntryField("isdefaultcurrency");
            queryParam.addEntryField("summoney");
            queryParam.addEntryField("olaporg");
            queryParam.addEntryField("groupnum");
            queryParam.addEntryField("dseq");
            this.actx.getSctx().getDimensions().forEach(dim -> queryParam.addEntryField(dim.getFieldmapped() + ".number"));
        }
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        if (this.isAutoElim) {
            return;
        }
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                String status = adjust.getString("status");
                if (!(RptAdjustStatusEnum.SAVE.status().equals(status) || RptAdjustStatusEnum.TEMPSAVE.status().equals(status) || RptAdjustStatusEnum.BACK.status().equals(status))) {
                    this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"%1$s\u72b6\u6001\u7684\u5206\u5f55\u4e0d\u652f\u6301%2$s\u64cd\u4f5c\u3002", (String)"AdjustClearOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]), RptAdjustStatusEnum.getStatusEnumBy((String)status).text(), AdjustOperTypeEnum.DELETEOPERATION.getName()));
                }
            }

            @Override
            protected String getValidatorKey() {
                return "AdjustClearOperation";
            }
        });
        e.addValidator(new AdjustSceneVersionValidator());
        e.addValidator(new AdjustCheckPermValidator());
        e.addValidator(new AdjustCheckArchiveStatusValidator());
    }

    @Override
    protected void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
        super.beforeValidatorData(adjustDys, adjustDatas);
        this.adjustDataTraceInfo = new ConcurrentHashMap<Long, Map<Long, String>>(adjustDys.size());
        ArrayList tasks = new ArrayList();
        adjustDatas.forEach((adjustId, datas) -> {
            ConcurrentHashMap detailLogMap = new ConcurrentHashMap(datas.size());
            this.adjustDataTraceInfo.put((Long)adjustId, detailLogMap);
            tasks.add(() -> {
                datas.forEach(d -> detailLogMap.put(d.getLong("id"), this.packKey((DynamicObject)d)));
                return "";
            });
        });
        if (!tasks.isEmpty()) {
            ThreadPoolService.runInWaiting4Thread(tasks.toArray(new Callable[0]));
        }
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjust, List<DynamicObject> adjustDatas) {
        Map<Long, String> traceLogMap;
        long adjId = adjust.getLong("id");
        String entrysource = adjust.getString("entrysource");
        if (ElimHeaderSourceEnum.SOURCE.getValue().equals(entrysource) || ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(entrysource)) {
            for (DynamicObject shareentry : adjust.getDynamicObjectCollection("shareentry")) {
                DynamicObject shareAdjust = shareentry.getDynamicObject("shareadjust");
                if (shareAdjust == null) continue;
                this.share2Map.put((Object)adjId, (Object)shareAdjust.getLong("id"));
            }
        }
        if (ElimHeaderSourceEnum.SOURCE.getValue().equals(entrysource) || ElimHeaderSourceEnum.SHARE.getValue().equals(entrysource)) {
            this.linksourceMap.put(adjId, adjust.getLong("linkagelinksource"));
        }
        if (this.adjustDataTraceInfo != null && (traceLogMap = this.adjustDataTraceInfo.get(adjId)) != null && !traceLogMap.isEmpty()) {
            adjustDatas.stream().filter(p -> p.getBoolean("isdefaultcurrency")).forEach(p -> this.getTraceLog().addTag(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801%1$s\u5206\u7ec4\u53f7%2$s\u5e8f\u53f7%3$s\uff1a%4$s", (String)"AdjustClearOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), p.getString("groupnum"), p.getString("dseq"), traceLogMap.getOrDefault(p.getLong("id"), "")), () -> p.getBigDecimal("summoney")));
        }
        this.addSuccessOper(adjust.getLong("id"));
    }

    private String packKey(DynamicObject entry) {
        return this.getTraceLog().getDimKeys().stream().map(p -> {
            if ("Entity".equalsIgnoreCase((String)p)) {
                return entry.getString("olaporg");
            }
            return entry.getString(this.actx.getSctx().getDimensionByNumber((String)p).getFieldmapped() + ".number");
        }).collect(Collectors.joining("|"));
    }

    @Override
    protected void afterExcute() {
        OperationResult shareResult = null;
        OperationResult linlResult = null;
        Set<Long> successIds = this.getOperationResult().getSuccessPkIds().stream().map(LongUtil::toLong).collect(Collectors.toSet());
        if (this.isAutoElim) {
            if (!CollectionUtil.isEmpty((Collection)this.share2Map.keySet())) {
                shareResult = AdjustClearServiceHelper.batchDeleteAutoAdjust(this.getOriginalSign() + "_shareResult", this.getModelId(), this.scene, this.year, this.period, new ArrayList<Long>(this.share2Map.values()));
                this.mergeShareRelativeResult(shareResult);
                successIds.retainAll(this.getOperationResult().getSuccessPkIds());
            }
            AdjustCheckServiceHelper.doSysToMdd(this.getModelId(), this.scene, this.year, this.period, successIds, false, this.getRecordLog());
        } else {
            AdjustmentServiceHelper.updateCheckTmplState(this.getModelId(), new ArrayList<Long>(successIds), false);
        }
        if (!CollectionUtil.isEmpty(this.linksourceMap.keySet())) {
            linlResult = AdjustClearServiceHelper.batchDeleteAutoAdjust(this.getOriginalSign() + "_linlResult", this.getModelId(), this.scene, this.year, this.period, new ArrayList<Long>(this.linksourceMap.values()));
            this.mergeLinkSourceResult(linlResult);
            successIds.retainAll(this.getOperationResult().getSuccessPkIds());
        }
        if (!successIds.isEmpty()) {
            this.updateAllShareOrg(successIds);
            DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])new QFilter[]{new QFilter("adjust", "in", successIds)});
            DeleteServiceHelper.delete((String)"bcm_rptadjust", (QFilter[])new QFilter[]{new QFilter("id", "in", successIds)});
            DeleteServiceHelper.delete((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("elim", "in", successIds)});
        }
        this.getTraceLog().publish();
        this.writeOperationLog(this.getOperationResult(), this.getModelId(), this.getPkids(), AdjustOperTypeEnum.DELETEOPERATION.getName());
        ThreadPoolService.runInThread(() -> {
            String orginSignStr = String.format(ResManager.loadKDString((String)"\u6765\u6e90\u4e3a\uff1a%s\u7684\u5206\u5f55\u6e05\u9664\u64cd\u4f5c", (String)"AdjustClearOperation_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.getOriginalSign() == null ? "" : this.getOriginalSign());
            try {
                PermClassEntityHelper.deleteEntities(new ArrayList<Long>(successIds), this.getModelId());
                AdjustAttachmentHelper.clearAttachment(successIds);
            }
            catch (Throwable t) {
                AdjustClearServiceHelper.LOG.error(orginSignStr + "---", t);
            }
        });
    }

    private void updateAllShareOrg(Set<Long> successIds) {
        String succIdStr = String.join((CharSequence)",", (CharSequence[])successIds.stream().map(Object::toString).distinct().toArray(String[]::new));
        HashSet relationShareIds = new HashSet(successIds.size());
        try (DataSet ds = DB.queryDataSet((String)"updateAllShareOrg", (DBRoute)BCMConstant.DBROUTE, (String)String.format("select fid from t_bcm_adjustshareentry where fshareadjustid in (%s)", succIdStr));){
            ds.forEachRemaining(row -> relationShareIds.add(row.getLong("fid")));
        }
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format("delete from t_bcm_adjustshareentry where fshareadjustid in (%s)", succIdStr));
        HashMultimap elim2Allshareorg = HashMultimap.create();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjust", (String)"id,shareentry.shareadjust.number,shareentry.shareorg.name", (QFilter[])new QFBuilder("id", "in", relationShareIds).toArray(), null);){
            ds.forEach(r -> {
                if (!StringUtil.isEmptyString((String)r.getString("shareentry.shareadjust.number"))) {
                    elim2Allshareorg.put((Object)r.getLong("id"), (Object)r.getString("shareentry.shareorg.name"));
                }
            });
        }
        String queryHeadSql = "update t_bcm_rptadjust set fallshareorg = ? where fid = ?";
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(16);
        for (Long relationShareId : relationShareIds) {
            Object[] param = new Object[]{String.join((CharSequence)",", elim2Allshareorg.get((Object)relationShareId)), relationShareId};
            obParams.add(param);
        }
        AdjustOperationHelper.executeDBBatch(queryHeadSql, obParams, 10000, true);
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
    }

    private void mergeShareRelativeResult(OperationResult shareResult) {
        if (this.share2Map.isEmpty()) {
            return;
        }
        Map<Long, List<OperateErrorInfo>> errorInfoList = shareResult.getAllErrorInfo().stream().collect(Collectors.groupingBy(p -> LongUtil.toLong((Object)p.getPkValue())));
        StringBuilder errorHandler = new StringBuilder();
        this.share2Map.asMap().forEach((mainId, shareSet) -> {
            shareSet.stream().filter(shareId -> !shareResult.getSuccessPkIds().contains(shareId)).forEach(shareId -> {
                List errorInfos = (List)errorInfoList.get(shareId);
                if (CollectionUtil.isEmpty((Collection)errorInfos)) {
                    errorHandler.append(shareResult.getMessage());
                } else {
                    errorInfos.forEach(errorInfo -> errorHandler.append(errorInfo.getMessage()));
                }
            });
            if (errorHandler.length() > 0) {
                this.addErrorOper("", (Long)mainId, ResManager.loadKDString((String)"\u5171\u4eab\u5206\u5f55\u6821\u9a8c\u5f02\u5e38:", (String)"AdjustClearOperation_4", (String)"fi-bcm-business", (Object[])new Object[0]).concat(errorHandler.toString()));
            }
            errorHandler.setLength(0);
        });
        errorInfoList.getOrDefault(0L, Collections.EMPTY_LIST).forEach(errorInfo -> this.addErrorOper("", 0L, ResManager.loadKDString((String)"\u5171\u4eab\u5206\u5f55\u6821\u9a8c\u5f02\u5e38:", (String)"AdjustClearOperation_4", (String)"fi-bcm-business", (Object[])new Object[0]).concat(errorInfo.toString())));
    }

    private void mergeLinkSourceResult(OperationResult linkResult) {
        if (this.share2Map.isEmpty()) {
            return;
        }
        Map<Long, List<OperateErrorInfo>> errorInfoList = linkResult.getAllErrorInfo().stream().collect(Collectors.groupingBy(p -> LongUtil.toLong((Object)p.getPkValue())));
        StringBuilder errorHandler = new StringBuilder();
        this.linksourceMap.forEach((mainId, linkId) -> {
            if (linkId != 0L && !linkResult.getSuccessPkIds().contains(linkId)) {
                List errorInfos = (List)errorInfoList.get(linkId);
                if (CollectionUtil.isEmpty((Collection)errorInfos)) {
                    errorHandler.append(linkResult.getMessage());
                } else {
                    errorInfos.forEach(errorInfo -> errorHandler.append(errorInfo.getMessage()));
                }
            }
            if (errorHandler.length() > 0) {
                this.addErrorOper("", (Long)mainId, ResManager.loadKDString((String)"\u8054\u52a8\u5206\u5f55\u6821\u9a8c\u5f02\u5e38:", (String)"AdjustClearOperation_5", (String)"fi-bcm-business", (Object[])new Object[0]).concat(errorHandler.toString()));
            }
            errorHandler.setLength(0);
        });
        errorInfoList.getOrDefault(0L, Collections.EMPTY_LIST).forEach(errorInfo -> this.addErrorOper("", 0L, ResManager.loadKDString((String)"\u8054\u52a8\u5206\u5f55\u6821\u9a8c\u5f02\u5e38:", (String)"AdjustClearOperation_5", (String)"fi-bcm-business", (Object[])new Object[0]).concat(errorInfo.toString())));
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", this.getModelId());
        param.put("scenario", this.scene);
        param.put("year", this.year);
        param.put("period", this.period);
        return param;
    }

    public AdjustDimOperationTraceLogImpl getTraceLog() {
        if (this.traceLog == null) {
            this.traceLog = new AdjustDimOperationTraceLogImpl();
            this.traceLog.setOperTypeEnum(AdjustOperTypeEnum.DELETEOPERATION);
            this.traceLog.setModelId(this.getModelId());
            this.traceLog.setSceneId(this.scene);
            this.traceLog.setYearId(this.year);
            this.traceLog.setPeriodId(this.period);
            this.traceLog.setSpecialSourceKey(this.getOriginalSign());
            this.traceLog.setDimKeys(new ArrayList<String>(this.actx.getSctx().getNumberMap().keySet()));
        }
        return this.traceLog;
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.DELETEOPERATION;
    }

    public void setAutoElim(boolean autoElim) {
        this.isAutoElim = autoElim;
    }

    @Override
    public long getYear() {
        return this.year;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }
}

