/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.Lists;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.attachment.AdjustAttachmentHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustCheckStatusEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class AdjustCopyOperation
extends AbstractAdjustOperation {
    protected long srcYear;
    protected long srcPeriod;
    protected long srcScene;
    protected DynamicObject tarScene;
    protected DynamicObject tarYear;
    protected DynamicObject tarPeriod;
    protected DynamicObject manJourMem;
    private boolean isExcuteLossScheme = false;
    private AdjustConvertService adjConvertSer;
    protected final Map<Long, DynamicObject> src2DyMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Long> src2tarAdjustIdMap = new HashMap<Long, Long>(16);

    public AdjustCopyOperation(Long modelId, Long tarScene, Long tarYear, Long tarPeriod, List<Long> pkids, boolean isExcuteLossScheme) {
        super(modelId, pkids);
        this.isExcuteLossScheme = isExcuteLossScheme;
        this.initSrc2TarData(tarScene, tarYear, tarPeriod, pkids);
    }

    @Override
    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        super.onPrepareQueryParam(queryParam);
        queryParam.setLoadType(0);
    }

    protected void initSrc2TarData(Long tarScene, Long tarYear, Long tarPeriod, List<Long> pkids) {
        if (tarScene != null) {
            this.tarScene = BusinessDataServiceHelper.loadSingle((Object)tarScene, (String)"bcm_scenemembertree");
            this.actx.setScenarioId(tarScene);
        }
        this.tarYear = BusinessDataServiceHelper.loadSingle((Object)tarYear, (String)"bcm_fymembertree");
        this.actx.setScenarioId(tarYear);
        this.tarPeriod = BusinessDataServiceHelper.loadSingle((Object)tarPeriod, (String)"bcm_periodmembertree");
        this.actx.setScenarioId(tarPeriod);
        DynamicObject elim = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"scenario.id,year.number,year.id,period.number,period.id", (QFilter[])new QFilter("id", "in", pkids).toArray());
        if (elim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\uff01", (String)"AdjustCopyOperation_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.srcScene = elim.getLong("scenario.id");
        this.srcPeriod = elim.getLong("period.id");
        this.srcYear = elim.getLong("year.id");
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.getCtx().addUserObject("tarScene", this.tarScene.getLong("id"));
        e.getCtx().addUserObject("tarYear", this.tarYear.getLong("id"));
        e.getCtx().addUserObject("tarPeriod", this.tarPeriod.getLong("id"));
        e.addValidator(new AdjustCheckPermValidator());
        e.addOnlyWarningValidator(new AdjustCheckDataNotNullValidator());
        e.addOnlyWarningValidator(new AdjustCheckDimMemValidator());
    }

    @Override
    public void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
        super.beforeValidatorData(adjustDys, adjustDatas);
        LinkedHashMap adjustDyList = new LinkedHashMap(adjustDys.size());
        adjustDys.forEach(adjustDy -> adjustDyList.put(adjustDy.getLong("id"), adjustDy));
        HashMap link2SrcMap = new HashMap(adjustDys.size());
        ArrayList srcAdjustIdList = new ArrayList(adjustDys.size());
        adjustDys.forEach(p -> {
            boolean isLink;
            long linkSourceId = DynUtils.getBaseId((DynamicObject)p, (String)"linkagelinksource");
            boolean bl = isLink = p.getInt("sourcetype") == ElimRptAdjSourceTypeEnum.LINK.getValue();
            if (linkSourceId != 0L) {
                link2SrcMap.put(linkSourceId, DynUtils.getBaseId((DynamicObject)p, (String)"id"));
                if (isLink && !adjustDyList.containsKey(linkSourceId)) {
                    srcAdjustIdList.add(linkSourceId);
                }
            }
        });
        if (!link2SrcMap.isEmpty()) {
            srcAdjustIdList.removeAll(link2SrcMap.values());
            DynamicObject[] srcAdjustDys = BusinessDataServiceHelper.load((Object[])srcAdjustIdList.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectType());
            Arrays.stream(srcAdjustDys).forEach(srcAdjustDy -> this.src2DyMap.put(srcAdjustDy.getLong("id"), (DynamicObject)srcAdjustDy));
            DynamicObject[] linkEntries = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)this.getQueryParam().getEntryFieldStr(), (QFilter[])new QFilter("adjust", "in", link2SrcMap.keySet()).toArray());
            Map<Long, List<DynamicObject>> src2LinkEntries = Arrays.stream(linkEntries).collect(Collectors.groupingBy(p -> link2SrcMap.getOrDefault(DynUtils.getBaseId((DynamicObject)p, (String)"adjust"), 0L)));
            src2LinkEntries.forEach((srcId, entries) -> adjustDatas.computeIfAbsent((Long)srcId, a -> Lists.newArrayList()).addAll(entries));
        }
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.COPYOPERATION;
    }

    @Override
    public void beforeExcute() {
        boolean isOverYear;
        boolean bl = isOverYear = Integer.parseInt(this.tarYear.getString("number").substring(2)) > Integer.parseInt(MemberReader.findFyMemberById((String)this.getModelNum(), (Long)this.srcYear).getNumber().substring(2));
        if (isOverYear && this.isExcuteLossScheme) {
            this.actx.initLossCarrySchemes();
        }
        this.manJourMem = BusinessDataServiceHelper.loadSingle((String)"bcm_audittrialmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ManualJournal"), new QFilter("model", "=", (Object)this.getModelId())});
        this.adjConvertSer = new AdjustConvertService(this.getModelId(), this.tarScene.getLong("id"), this.tarYear.getLong("id"), this.tarPeriod.getLong("id"));
        this.initPermClass();
    }

    protected void initPermClass() {
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDataList) {
        if (adjustDy.getInt("sourcetype") == ElimRptAdjSourceTypeEnum.LINK.getValue() && (adjustDy = this.src2DyMap.get(adjustDy.getLong("linkagelinksource"))) == null) {
            return;
        }
        long srcAdjId = adjustDy.getLong("id");
        DynamicObject newElim = this.buildNewElim(adjustDy);
        List<DynamicObject> newEntries = this.buildNewElimEntries(adjustDy, newElim, adjustDataList);
        if (this.isNeedConvert(adjustDy)) {
            this.adjConvertSer.batchConvert(newEntries);
        }
        if (!newEntries.isEmpty()) {
            AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)newElim, newEntries, (boolean)false);
            AdjustmentServiceHelper.rebuildAdjustCommembEntry(this.actx.getModelId(), Collections.singletonList(newElim), newEntries);
            newElim.set("extend", (Object)adjustDy.getLong("id"));
            Pair<Boolean, String> result1 = AdjustmentServiceHelper.validateSceneVersion(this.actx, newElim, newEntries);
            if (((Boolean)result1.p1).booleanValue()) {
                this.addSuccessOper(adjustDy.getLong("id"));
                this.src2tarAdjustIdMap.put(adjustDy.getLong("id"), newElim.getLong("id"));
                this.actx.addUserObject("bcm_rptadjust", newElim);
                newEntries.forEach(entry -> this.actx.addUserObject("bcm_rptadjustdata", entry));
            } else {
                this.addErrorOper(adjustDy.getString("number"), adjustDy.getLong("id"), (String)result1.p2);
            }
        } else {
            this.addErrorOper(adjustDy.getString("number"), srcAdjId, ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u6ca1\u6709\u7b26\u5408\u590d\u5236\u8981\u6c42\u7684\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"AdjustCopyOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    protected boolean isNeedConvert(DynamicObject adjustDy) {
        if (this.srcScene == this.tarScene.getLong("id") && this.srcYear == this.tarYear.getLong("id") && this.srcPeriod == this.tarPeriod.getLong("id")) {
            return false;
        }
        return adjustDy.getBoolean("multiplecurrency") || adjustDy.get("cvtbeforecurrency") instanceof DynamicObject;
    }

    private DynamicObject buildNewElim(DynamicObject oldElim) {
        oldElim.getDynamicObjectCollection("commembentry").sort(Comparator.comparingLong(e -> e.getLong("id")));
        oldElim.getDynamicObjectCollection("commembentry").sort(Comparator.comparingInt(e -> e.getInt("seq")));
        oldElim.getDynamicObjectCollection("spreadmembentry").sort(Comparator.comparingLong(e -> e.getLong("id")));
        oldElim.getDynamicObjectCollection("spreadmembentry").sort(Comparator.comparingInt(e -> e.getInt("seq")));
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newElim = (DynamicObject)cloneUtils.clone(oldElim.getDataEntityType(), (Object)oldElim);
        this.resetOldElimData(newElim);
        newElim.set("period", (Object)this.tarPeriod);
        newElim.set("year", (Object)this.tarYear);
        if (this.tarScene != null) {
            newElim.set("scenario", (Object)this.tarScene);
        }
        newElim.set("creator", (Object)this.actx.getUser());
        newElim.set("createtime", (Object)TimeServiceHelper.now());
        this.dealAdjustDimension(oldElim, newElim);
        this.dealElimOtherProperities(oldElim, newElim);
        return newElim;
    }

    private void resetOldElimData(DynamicObject newElim) {
        newElim.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        newElim.getDynamicObjectCollection("shareentry").clear();
        newElim.set("allshareorg", null);
        newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
        newElim.set("extend", null);
        newElim.set("extendfrom", null);
        newElim.set("submitter", null);
        newElim.set("submittime", null);
        newElim.set("cancelsubmitter", null);
        newElim.set("cancelsubmittime", null);
        newElim.set("ratifier", null);
        newElim.set("ratifytime", null);
        newElim.set("cancelratifier", null);
        newElim.set("cancelratifytime", null);
        newElim.set("reviewer", null);
        newElim.set("reviewtime", null);
        newElim.set("callbacker", null);
        newElim.set("callbacktime", null);
        newElim.set("modifier", null);
        newElim.set("modifytime", null);
        newElim.set("creator", null);
        newElim.set("createtime", null);
        newElim.set("spreadjson", null);
        newElim.set("data", null);
        newElim.set("checkstatus", (Object)RptAdjustCheckStatusEnum.NOTCHECKED.getStatus());
        newElim.set("iscontinuous", (Object)1);
        newElim.set("linkagelinksource", (Object)0L);
        newElim.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        newElim.set("checkrecord", null);
    }

    protected void dealAdjustDimension(DynamicObject oldElim, DynamicObject newElim) {
        if (this.manJourMem != null && (this.isAutoAdjust(oldElim) || this.isLinkAdjust(oldElim))) {
            newElim.set("audittrail", (Object)this.manJourMem);
        }
        DynamicObjectCollection commembentry = newElim.getDynamicObjectCollection("commembentry");
        for (DynamicObject commemb : commembentry) {
            commemb.set("id", null);
            if (DimTypesEnum.YEAR.getNumber().equals(commemb.getString("comdimension.number"))) {
                commemb.set("commembid", (Object)this.tarYear.getLong("id"));
                continue;
            }
            if (DimTypesEnum.PERIOD.getNumber().equals(commemb.getString("comdimension.number"))) {
                commemb.set("commembid", (Object)this.tarPeriod.getLong("id"));
                continue;
            }
            if (DimTypesEnum.SCENARIO.getNumber().equals(commemb.getString("comdimension.number")) && this.tarScene != null) {
                commemb.set("commembid", (Object)this.tarScene.getLong("id"));
                continue;
            }
            if (this.manJourMem == null || !DimTypesEnum.AUDITTRIAL.getNumber().equals(commemb.getString("comdimension.number"))) continue;
            commemb.set("commembid", (Object)this.manJourMem.getLong("id"));
        }
        DynamicObjectCollection spreadmembentry = newElim.getDynamicObjectCollection("spreadmembentry");
        for (DynamicObject spreadmemb : spreadmembentry) {
            spreadmemb.set("id", null);
        }
    }

    protected void dealElimOtherProperities(DynamicObject adjustDy, DynamicObject newElim) {
        newElim.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.COPY.getValue());
    }

    protected List<DynamicObject> buildNewElimEntries(DynamicObject oldElim, DynamicObject newElim, List<DynamicObject> adjustDataList) {
        ArrayList<DynamicObject> newEntries = new ArrayList<DynamicObject>(adjustDataList.size());
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject entryClone = null;
        boolean isLink = this.isLinkAdjust(oldElim);
        for (DynamicObject adjustData : adjustDataList) {
            entryClone = (DynamicObject)cloneUtils.clone(adjustData.getDataEntityType(), (Object)adjustData);
            entryClone.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            entryClone.set("adjust", (Object)newElim);
            entryClone.set("year", (Object)this.tarYear);
            entryClone.set("period", (Object)this.tarPeriod);
            if (this.tarScene != null) {
                entryClone.set("scenario", (Object)this.tarScene);
            }
            if (this.manJourMem != null && (this.isAutoAdjust(newElim) || isLink)) {
                entryClone.set("audittrail", (Object)this.manJourMem);
                entryClone.set("checkrecordentry", (Object)0);
            }
            if (!isLink && EntrySourceEnum.getLinkList().contains(adjustData.getInt("entrysource"))) {
                entryClone.set("entrysource", (Object)4);
            } else {
                entryClone.set("entrysource", (Object)3);
                newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
            }
            entryClone.set("ischanged", (Object)Character.valueOf('0'));
            if (OrgRelaProcessMembPool.isRelaProcess((String)oldElim.getString("process"))) {
                this.dealEntryEffectEntity(newElim.getString("number"), entryClone);
            }
            entryClone.set("checkrecordentry", (Object)0L);
            this.dealEntryOtherProperities(entryClone);
            this.changeCarryYearAdjustElim(entryClone);
            this.dealEntryPrecision(entryClone);
            newEntries.add(entryClone);
        }
        AdjustConvertUtil.setAdjustDataShowSeq(newEntries, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
        return newEntries;
    }

    private void dealEntryEffectEntity(String number, DynamicObject entryClone) {
        if (ConfigServiceHelper.getBoolParam(this.getModelId(), "CM040")) {
            long oldOrgId = DynUtils.getBaseId((DynamicObject)entryClone, (String)"entity");
            long mergeId = DynUtils.getBaseId((DynamicObject)entryClone, (String)"merge");
            IDNumberTreeNode oldOrgNode = BcmThreadCache.findNodeById((String)this.getModelNum(), (String)"Entity", (long)oldOrgId);
            Set<Long> effOrgList = InvestServiceHelper.queryEffectiveOrgList(this.getModelId(), this.tarScene.getLong("id"), this.tarYear.getLong("id"), this.tarPeriod.getLong("id"), mergeId, oldOrgNode.getNumber());
            if (effOrgList == null || effOrgList.isEmpty()) {
                entryClone.set("entity", null);
                this.addWarnOper(number, null, String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7%1$s\u5e8f\u53f7%2$s\u7684\u660e\u7ec6\u5206\u5f55\u7684\u7ec4\u7ec7%3$s|%4$s\u5728\u5f53\u524d\u7ec4\u7ec7\u67b6\u6784\u627e\u4e0d\u5230\u94fe\u8def\u751f\u6548\u4e14\u53c2\u4e0e\u5408\u5e76\u7684\u7ec4\u7ec7;", (String)"AdjustCopyOperation_5", (String)"fi-bcm-business", (Object[])new Object[0]), entryClone.getString("groupnum"), entryClone.getString("dseq"), oldOrgNode.getNumber(), oldOrgNode.getName()));
                AdjustOperationHelper.fillAdjustDataOfOlapOrg(this.getModelNum(), entryClone, (boolean)Boolean.TRUE);
            } else if (oldOrgId != effOrgList.iterator().next()) {
                IDNumberTreeNode newOrgNode = BcmThreadCache.findNodeById((String)this.getModelNum(), (String)"Entity", (long)effOrgList.iterator().next());
                DynamicObject orgDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
                orgDy.set("id", (Object)newOrgNode.getId());
                entryClone.set("entity", (Object)orgDy);
                this.addWarnOper(number, null, String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7%1$s\u5e8f\u53f7%2$s\u7684\u660e\u7ec6\u5206\u5f55\u7684\u7ec4\u7ec7%3$s|%4$s\u8fdb\u884c\u4e86\u66ff\u6362,\uff08%5$s->%6$s\uff09;", (String)"AdjustCopyOperation_6", (String)"fi-bcm-business", (Object[])new Object[0]), entryClone.getString("groupnum"), entryClone.getString("dseq"), oldOrgNode.getNumber(), oldOrgNode.getName(), oldOrgNode.getLongNumber(), newOrgNode.getLongNumber()));
                AdjustOperationHelper.fillAdjustDataOfOlapOrg(this.getModelNum(), entryClone, (boolean)Boolean.TRUE);
            }
        }
    }

    protected void dealEntryPrecision(DynamicObject entryClone) {
        int precision = CurrencyScaleHandler.getNewCurrencyScale(this.getModelId(), this.tarScene.getString("number"), entryClone.getString("currency.number"), entryClone.getString("account.number"));
        entryClone.set("debit", (Object)entryClone.getBigDecimal("debit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("credit", (Object)entryClone.getBigDecimal("credit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("summoney", (Object)entryClone.getBigDecimal("summoney").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforecredit", (Object)entryClone.getBigDecimal("cvtbeforecredit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforedebit", (Object)entryClone.getBigDecimal("cvtbeforedebit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforesummoney", (Object)entryClone.getBigDecimal("cvtbeforesummoney").setScale(precision, RoundingMode.HALF_UP));
    }

    protected void changeCarryYearAdjustElim(DynamicObject entryClone) {
        HashMap<String, String> dimComb = new HashMap<String, String>(16);
        if (!this.actx.getLossCarrySchemes().isEmpty()) {
            for (Dimension dim : LossCarryScheme.getLossCarryDimCtx(this.getModelId()).getDimensions()) {
                if ("Scenario".equals(dim.getNumber())) {
                    dimComb.put(dim.getFieldmapped(), MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)this.tarScene.getLong("id")).getNumber());
                }
                if ("Year".equals(dim.getNumber())) {
                    dimComb.put(dim.getFieldmapped(), MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)this.tarYear.getLong("id")).getNumber());
                }
                if ("Period".equals(dim.getNumber())) {
                    dimComb.put(dim.getFieldmapped(), MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)this.tarPeriod.getLong("id")).getNumber());
                    continue;
                }
                if ("Entity".equals(dim.getNumber())) {
                    dimComb.put(dim.getFieldmapped(), OrgRelaProcessMembPool.isRelaProcess((String)entryClone.getString("process.number")) ? entryClone.getString("merge.number") : entryClone.getString("entity.number"));
                    continue;
                }
                dimComb.put(dim.getFieldmapped(), entryClone.getString(dim.getFieldmapped() + ".number"));
            }
            AdjustmentServiceHelper.changeCarryYearAdjustElim(AdjustOperationHelper.createVersionParam(this.getModelId(), this.tarScene.getLong("id"), this.tarYear.getLong("id"), this.tarPeriod.getLong("id")), dimComb, this.actx.getLossCarrySchemes(), entryClone);
        }
    }

    protected void dealEntryOtherProperities(DynamicObject entryClone) {
    }

    boolean isAutoAdjust(DynamicObject newElim) {
        return StringUtils.isEmpty((String)newElim.getString("audittrail.number")) || "AutoJournal".equals(newElim.getString("audittrail.number"));
    }

    boolean isLinkAdjust(DynamicObject newElim) {
        return ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(newElim.getString("entrysource")) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(newElim.getString("entrysource")) || ElimRptAdjSourceTypeEnum.LINK.getValue() == newElim.getInt("sourcetype");
    }

    @Override
    protected void afterExcute() {
        if (this.getOperationResult().getSuccessPkIds() != null && this.getOperationResult().getSuccessPkIds().size() > 0) {
            try {
                Object[] elims = this.actx.getUserObject("bcm_rptadjust").toArray(new DynamicObject[0]);
                AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", Lists.newArrayList((Object[])elims));
                SaveServiceHelper.save((DynamicObject[])elims);
                AdjustAttachmentHelper.copyAttachment(this.src2tarAdjustIdMap);
                AdjustOperationHelper.clonePermClassFromSrcAdjust(this.getModelId(), this.src2tarAdjustIdMap);
                SaveServiceHelper.save((DynamicObject[])this.actx.getUserObject("bcm_rptadjustdata").toArray(new DynamicObject[0]));
            }
            finally {
                this.actx.getUserObject().removeAll((Object)"bcm_rptadjust");
                this.actx.getUserObject().removeAll((Object)"bcm_rptadjustdata");
            }
        }
    }

    @Override
    protected boolean needBatchExcute() {
        return this.actx.getUserObject().containsKey((Object)"bcm_rptadjustdata") && this.actx.getUserObject("bcm_rptadjustdata").size() > 5000;
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", this.getModelId());
        param.put("scenario", this.tarScene.getLong("id"));
        param.put("year", this.tarYear.getLong("id"));
        param.put("period", this.tarPeriod.getLong("id"));
        return param;
    }

    public Map<Long, Long> getSrc2tarAdjustIdMap() {
        return this.src2tarAdjustIdMap;
    }
}

