/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustMutexLockedCheckValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AdjustCreateLinkageOperation
extends AbstractAdjustOperation {
    private boolean isKeepModified = Boolean.TRUE;
    protected long year;
    protected long period;
    protected long scene;
    private final List<String> availableStatus = Arrays.asList(RptAdjustStatusEnum.BACK.status(), RptAdjustStatusEnum.SAVE.status(), RptAdjustStatusEnum.TEMPSAVE.status());

    public AdjustCreateLinkageOperation(Long modelId, long scene, long year, long period, List<Long> pkids, boolean isKeepModified) {
        super(modelId, pkids);
        this.year = year;
        this.period = period;
        this.scene = scene;
        this.isKeepModified = isKeepModified;
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.addValidator(new AdjustMutexLockedCheckValidator());
        e.addValidator(new AdjustSceneVersionValidator());
        e.addValidator(new AdjustCheckPermValidator());
        e.addOnlyWarningValidator(new AdjustCheckDataNotNullValidator());
        e.addOnlyWarningValidator(new AdjustCheckDimMemValidator());
        e.addValidator(new AbstractValidator(){

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                if (AdjustLinkCreateEnum.COMMONADJUST.getStatus().equals(adjust.getString("linkcreatetype"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u8054\u52a8\u751f\u6210\u65b9\u5f0f\u4e3a\u4e0d\u751f\u6210\u8054\u52a8\u5206\u5f55\u7684\u5206\u5f55\u4e0d\u5141\u8bb8\u751f\u6210\u8054\u52a8\u6570\u636e\u3002", (String)"AdjustCreateLinkageOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (ElimRptAdjSourceTypeEnum.LINK.getValue() == adjust.getInt("sourcetype")) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u5f55\u4e3a\u8054\u52a8\u5206\u5f55\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustCreateLinkageOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (!AdjustCreateLinkageOperation.this.availableStatus.contains(adjust.getString("status"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u6709\u6253\u56de\uff0c\u6682\u5b58\u548c\u4fdd\u5b58\u72b6\u6001\u7684\u5206\u5f55\u624d\u80fd\u751f\u6210\u8054\u52a8\u5206\u5f55\u3002", (String)"AdjustCreateLinkageOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            }

            @Override
            protected String getValidatorKey() {
                return "AdjustCreateLinkageValidator";
            }
        });
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.CREATE_LINKAGE_OPERATION;
    }

    @Override
    protected void beforeExcute() {
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        this.addSuccessOper(adjustDy.getLong("id"));
    }

    @Override
    protected void afterExcute() {
        List<Long> pks = this.getOperationResult().getSuccessPkIds().parallelStream().map(LongUtil::toLong).collect(Collectors.toList());
        if (!pks.isEmpty()) {
            LinkageMappingService linkageMappingService = new LinkageMappingService(this.getModelId(), (Long)this.year, (Long)this.scene, (Long)this.period, pks, this.isKeepModified);
            LinkageDataCollector dataCollector = linkageMappingService.rebuildLinkage();
            dataCollector.getOperationResult().getAllErrorInfo().forEach(p -> this.addWarnOper("", (Long)p.getPkValue(), p.getMessage()));
        }
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("model", this.getModelId());
        param.put("scenario", this.scene);
        param.put("year", this.year);
        param.put("period", this.period);
        return param;
    }
}

