/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.CslSchemeAdjustShareHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustFlowOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckArchiveStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataSysToMDDValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOlapLockValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOperPersonValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckRelativeDataValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustFlowStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AdjustFlowCancelOperation
extends AdjustFlowOperation {
    private static final String SHARE_RECORDS_CACHE = "shareRecords";

    public AdjustFlowCancelOperation(AdjustOperationContext ctx, List<Long> pkids, AdjustOperTypeEnum opType) {
        super(ctx, pkids, opType);
    }

    @Override
    protected void beforeExcute() {
        switch (this.getOperationType()) {
            case CANCELCOMITOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.SAVE;
                break;
            }
            case CANCELRATIFYOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.COMMIT;
                break;
            }
            case BACKOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.BACK;
                break;
            }
            default: {
                throw new KDBizException("only support cancel operation");
            }
        }
    }

    @Override
    protected boolean isSysToMDD() {
        return AdjustOperTypeEnum.BACKOPERATION == this.getOperationType();
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        e.setOperationKey(this.getOperationType().getOperation());
        e.addValidator(new AdjustSceneVersionValidator());
        e.addValidator(new AdjustFlowStatusValidator());
        e.addValidator(new AdjustCheckRelativeDataValidator());
        e.addValidator(new AdjustCheckPermValidator());
        e.addValidator(new AdjustCheckArchiveStatusValidator());
        e.addValidator(new AdjustCheckOperPersonValidator(this.getOperationType()));
        if (this.isSysToMDD()) {
            e.addValidator(new AdjustCheckOlapLockValidator().setCheckByLinkId(true));
            e.addValidator(new AdjustCheckDataSysToMDDValidator());
            e.addValidator(new AbstractValidator(){

                @Override
                protected void beforeValidate() {
                    DynamicObject[] query = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"allshareorg, process, shareentry.shareadjust,model,number,id", (QFilter[])new QFilter("id", "in", AdjustFlowCancelOperation.this.getPkids()).and("entrysource", "in", (Object)new String[]{"0", "2"}).toArray());
                    if (query.length > 0) {
                        HashMap share2SrcMap = Maps.newHashMap();
                        for (DynamicObject q : query) {
                            DynamicObjectCollection shareEntry = q.getDynamicObjectCollection("shareentry");
                            shareEntry.forEach(v -> {
                                DynamicObject shareAdjust = v.getDynamicObject("shareadjust");
                                if (shareAdjust != null) {
                                    share2SrcMap.put(shareAdjust.getLong("id"), q);
                                }
                            });
                        }
                        OperationResult tempResult = AdjustmentServiceHelper.checkAdjustByValidator(this.getModelId(), new ArrayList<Object>(share2SrcMap.keySet()), e -> {
                            e.setValidateResult(new OperationResult());
                            e.addValidator(new AdjustCheckArchiveStatusValidator());
                            e.addValidator(new AdjustCheckDataSysToMDDValidator());
                        });
                        tempResult.getAllErrorInfo().stream().forEach(e -> {
                            DynamicObject dy = (DynamicObject)share2SrcMap.remove(e.getPkValue());
                            this.addErrorMessage(dy, String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5206\u5f55%s", (String)"AdjustFlowCancelOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
                        });
                        this.getCtx().addUserObject(AdjustFlowCancelOperation.SHARE_RECORDS_CACHE, share2SrcMap);
                    }
                }

                @Override
                protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                }

                @Override
                protected String getValidatorKey() {
                    return "AdjustFlowCancelOpartion.ShareValidtor";
                }
            });
        }
    }

    @Override
    protected void afterExcute() {
        if (this.getOperationResult().getSuccessPkIds().size() > 0) {
            if (this.isSysToMDD()) {
                Map share2SrcMap = (Map)this.actx.getProperty(SHARE_RECORDS_CACHE);
                CslSchemeAdjustShareHelper.handleShareEntry(this.getModelId(), this.getScene(), this.getYear(), this.getPeriod(), share2SrcMap);
                List<Long> pks = this.getOperationResult().getSuccessPkIds().parallelStream().map(LongUtil::toLong).collect(Collectors.toList());
                AdjustCheckServiceHelper.doSysToMdd(this.getModelId(), this.getScene(), this.getYear(), this.getPeriod(), pks, false, this.getRecordLog());
                LinkageMappingServiceHelper.backLinkLinkageAdjust(this.getModelId(), this.getScene(), this.getYear(), this.getPeriod(), pks);
                this.batchUpdateSrcAdjustStatus();
            } else {
                this.batchUpdateAdjustStatus(this.getOperationResult().getSuccessPkIds());
            }
        }
        this.writeOperationLog(this.getOperationResult(), this.getModelId(), this.getPkids(), this.tarStatus.text());
    }

    private void batchUpdateSrcAdjustStatus() {
        if (this.getOperationResult().getSuccessPkIds().isEmpty()) {
            return;
        }
        CharSequence[] succids = (String[])this.getOperationResult().getSuccessPkIds().stream().map(Object::toString).distinct().toArray(String[]::new);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)("update t_bcm_rptadjust set fallshareorg = ' ' " + " where fid in (" + String.join((CharSequence)",", succids) + ")" + " and fentrysource in ('0','2')"));
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
    }
}

