/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AbstractAdjustOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.IAdjustOperationLogService;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckArchiveStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataSysToMDDValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOlapLockValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOperPersonValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckRelativeDataValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustFlowStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AdjustFlowOperation
extends AbstractAdjustOperation
implements IAdjustOperationLogService {
    private final long year;
    private final long period;
    private final long scene;
    private final AdjustOperTypeEnum opType;
    protected RptAdjustStatusEnum tarStatus;

    public AdjustFlowOperation(AdjustOperationContext ctx, List<Long> pkids, AdjustOperTypeEnum opType) {
        super(ctx.getModelId(), pkids);
        this.setActx(ctx);
        DynamicObject one = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"year,scenario,period", (QFilter[])new QFilter("id", "in", pkids).toArray());
        if (one == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"AdjustSaveOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.opType = opType;
        this.year = one.getLong("year");
        this.period = one.getLong("period");
        this.scene = one.getLong("scenario");
        this.setOpenMutex(true);
    }

    @Override
    protected void beforeExcute() {
        switch (this.getOperationType()) {
            case COMITOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.COMMIT;
                break;
            }
            case RATIFYOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.RATIFY;
                break;
            }
            case AUDITOPERATION: 
            case AUTOAUDITOPERATION: {
                this.tarStatus = RptAdjustStatusEnum.AUDIT;
                break;
            }
            default: {
                throw new KDBizException("only support COMIT & RATIFY & AUDIT operation");
            }
        }
    }

    @Override
    protected void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        super.onPrepareQueryParam(queryParam);
        if (this.isSysToMDD()) {
            queryParam.setLoadType(3);
            queryParam.addExtraAdjustField("allshareorg");
            queryParam.addExtraAdjustField("spreadjson");
            queryParam.addExtraAdjustField("data");
            queryParam.addExtraAdjustField("description");
            queryParam.addExtraAdjustField("checkstatus");
            queryParam.addExtraAdjustField("iscontinuous");
            queryParam.addExtraAdjustField("checkrecord");
            queryParam.addExtraAdjustDataField("ruleexpr");
            queryParam.addExtraAdjustDataField("calculatecontent");
            queryParam.addExtraAdjustDataField("description");
        }
    }

    protected boolean isSysToMDD() {
        return AdjustOperTypeEnum.AUDITOPERATION == this.getOperationType();
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.addValidator(new AdjustSceneVersionValidator());
        e.addValidator(new AdjustFlowStatusValidator());
        e.addValidator(new AdjustCheckRelativeDataValidator());
        e.addValidator(new AdjustCheckDataNotNullValidator());
        e.addValidator(new AdjustCheckPermValidator());
        e.addValidator(new AdjustCheckDimMemValidator());
        e.addValidator(new AdjustCheckArchiveStatusValidator());
        e.addValidator(new AdjustCheckOperPersonValidator(this.getOperationType()));
        if (this.isSysToMDD()) {
            e.addValidator(new AdjustCheckOlapLockValidator().setCheckByLinkId(true));
            e.addValidator(new AdjustCheckDataSysToMDDValidator());
        }
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        this.addSuccessOper(adjustDy.getLong("id"));
    }

    @Override
    protected void afterExcute() {
        if (this.getOperationResult().getSuccessPkIds().size() > 0) {
            if (this.isSysToMDD()) {
                List<Long> pks = this.getOperationResult().getSuccessPkIds().parallelStream().map(LongUtil::toLong).collect(Collectors.toList());
                AdjustCheckServiceHelper.doSysToMdd(this.getModelId(), this.scene, this.year, this.period, pks, true, this.getRecordLog());
            } else {
                this.batchUpdateAdjustStatus(this.getOperationResult().getSuccessPkIds());
            }
        }
        this.writeOperationLog(this.getOperationResult(), this.getModelId(), this.getPkids(), this.tarStatus.text());
    }

    protected void batchUpdateAdjustStatus(List<Object> successPkIds) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
        String nowTime = String.format(" {ts'%s'} ", df.format(TimeServiceHelper.now()));
        String userId = String.format(" %s ", RequestContext.get().getCurrUserId());
        CharSequence[] succids = (String[])successPkIds.stream().map(Object::toString).distinct().toArray(String[]::new);
        StringBuilder sb = new StringBuilder("update t_bcm_rptadjust set ");
        sb.append("fstatus =").append(this.tarStatus.status()).append(",");
        switch (this.getOperationType()) {
            case COMITOPERATION: {
                sb.append("fsubmittime =").append(nowTime).append(",");
                sb.append("fsubmitterid =").append(userId).append(",");
                break;
            }
            case RATIFYOPERATION: {
                sb.append("fratifytime =").append(nowTime).append(",");
                sb.append("fratifierid =").append(userId).append(",");
                break;
            }
            case CANCELRATIFYOPERATION: {
                sb.append("fratifytime = null").append(",");
                sb.append("fratifierid = 0").append(",");
                break;
            }
            case CANCELCOMITOPERATION: {
                sb.append("fsubmittime = null").append(",");
                sb.append("fsubmitterid = 0").append(",");
            }
        }
        sb.append("fmodifytime = ").append(nowTime).append(",");
        sb.append("fmodifierid = ").append(userId);
        sb.append(" where fid in (").append(String.join((CharSequence)",", succids)).append(")");
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb.toString());
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjustdata");
    }

    @Override
    protected Map<String, Object> createRecordParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", this.getModelId());
        param.put("scenario", this.actx.getScenarioId());
        param.put("year", this.actx.getFyId());
        param.put("period", this.actx.getPeriodId());
        return param;
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return this.opType;
    }

    @Override
    public long getYear() {
        return this.year;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    public long getScene() {
        return this.scene;
    }
}

