/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import org.apache.commons.lang3.StringUtils;

public class AdjustOperationContext
extends AbstractContext
implements Cloneable {
    private SchemeContext sctx = null;
    private DynamicObject user;
    private Long cslId;
    private final Date now = TimeServiceHelper.now();
    private AdjustOperTypeEnum operTypeEnum;
    private final HashMultimap<String, String> refPathParserPool = HashMultimap.create();
    private final Set<String> circularRefSet = new HashSet<String>();
    private final HashMultimap<String, Object> userObject = HashMultimap.create();
    private List<LossCarryScheme> lossCarrySchemes;
    private List<Integer> entrySourceList;

    public AdjustOperationContext(Long modelId) {
        super(modelId, 0L, 0L, 0L);
    }

    public AdjustOperationContext(long modelId, long scenarioId, long fyId, long periodId) {
        super(modelId, scenarioId, fyId, periodId);
    }

    public void setOperTypeEnum(AdjustOperTypeEnum operTypeEnum) {
        this.operTypeEnum = operTypeEnum;
    }

    public AdjustOperTypeEnum getOperTypeEnum() {
        return this.operTypeEnum;
    }

    public SchemeContext getSctx() {
        if (this.sctx == null) {
            this.sctx = SchemeContext.getInstance(this.getModelId());
        }
        return this.sctx;
    }

    public boolean addExrToRefPosPool(String srcPos, String tarPos) {
        this.refPathParserPool.put((Object)srcPos, (Object)tarPos);
        ArrayList<String> pahList = new ArrayList<String>(16);
        if (this.checkCircularReference(srcPos, pahList)) {
            this.circularRefSet.add(srcPos);
            return false;
        }
        return true;
    }

    private boolean checkCircularReference(String tarPos, List<String> pahList) {
        if (this.circularRefSet.contains(tarPos)) {
            return true;
        }
        Set refPosSet = this.refPathParserPool.get((Object)tarPos);
        if (CollectionUtils.isEmpty((Collection)refPosSet)) {
            return false;
        }
        for (String refPos : refPosSet) {
            if (pahList.contains(refPos)) {
                this.circularRefSet.add(refPos);
                return true;
            }
            pahList.add(refPos);
            if (this.checkCircularReference(refPos, pahList)) {
                this.circularRefSet.add(refPos);
                pahList.remove(pahList.size() - 1);
                return true;
            }
            pahList.remove(pahList.size() - 1);
        }
        return false;
    }

    public void clear() {
        this.circularRefSet.clear();
        this.refPathParserPool.clear();
    }

    public void addUserObject(String key, Object value) {
        this.userObject.put((Object)key, value);
    }

    public HashMultimap<String, Object> getUserObject() {
        return this.userObject;
    }

    public Set<Object> getUserObject(String key) {
        return this.userObject.get((Object)key);
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)(this.getUserObject(key) == null || this.getUserObject(key).isEmpty() ? null : this.getUserObject(key).iterator().next());
    }

    public <T> T getUserObject(String key, CacheLoader<T> loader) {
        Object value = this.getProperty(key);
        if (value == null && (value = loader.load()) != null) {
            this.addUserObject(key, value);
        }
        return value;
    }

    public <T> T getUsetObjectFromCache(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        return (T)ThreadCache.get((Object)key, () -> {
            String processId = (String)ThreadCache.get((Object)"cache_node_prefix");
            if (StringUtils.isEmpty((CharSequence)processId)) {
                return loader.load();
            }
            return GlobalCacheServiceHelper.getCommonCache().getOrLoad(processId.concat("_").concat(key), loader);
        });
    }

    public DynamicObject getUser() {
        if (this.user == null) {
            this.user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            this.user.set("id", (Object)RequestContext.get().getUserId());
        }
        return this.user;
    }

    public void initLossCarrySchemes() {
        this.lossCarrySchemes = AdjustmentServiceHelper.getLossCarrySchemes(this.getSctx());
        this.lossCarrySchemes.removeIf(lossCarryScheme -> !lossCarryScheme.isOpen());
    }

    public List<LossCarryScheme> getLossCarrySchemes() {
        if (this.lossCarrySchemes == null) {
            this.lossCarrySchemes = new ArrayList<LossCarryScheme>();
        }
        return this.lossCarrySchemes;
    }

    public boolean checkCanOperAutoElim(int entrysource) {
        if (this.entrySourceList == null) {
            this.entrySourceList = new ArrayList<Integer>(4);
            if (!ConfigServiceHelper.getBoolChildParam(this.getModelId(), "CM003", ChildConfigEnum.INVAUTOCREATE.getBusinesstypevalue())) {
                this.entrySourceList.add(EntrySourceEnum.INVAUTOCREATE.getValue());
                this.entrySourceList.add(EntrySourceEnum.INVLINKAGECREATE.getValue());
            }
            if (!ConfigServiceHelper.getBoolChildParam(this.getModelId(), "CM003", ChildConfigEnum.INTEGRATIONAUTOCREATE.getBusinesstypevalue())) {
                this.entrySourceList.add(EntrySourceEnum.AUTOCREATE.getValue());
            }
            if (!ConfigServiceHelper.getBoolChildParam(this.getModelId(), "CM003", ChildConfigEnum.CHECKAUTOCREATE.getBusinesstypevalue())) {
                this.entrySourceList.add(EntrySourceEnum.CHECKAUTOCREATE.getValue());
                this.entrySourceList.add(EntrySourceEnum.CHECKLINKAGECREATE.getValue());
            }
            this.entrySourceList.add(EntrySourceEnum.RULECREATE.getValue());
        }
        return !this.entrySourceList.contains(entrysource);
    }

    public Date getNowTime() {
        return this.now;
    }

    public Long getCslId() {
        return this.cslId;
    }

    public void setCslId(Long cslId) {
        this.cslId = cslId;
    }

    public Object clone() {
        try {
            AdjustOperationContext copy = (AdjustOperationContext)super.clone();
            copy.sctx = null;
            copy.clear();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return new AdjustOperationContext(0L);
        }
    }
}

