/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.CslSchemeAdjustShareHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AdjConsumer;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.OperationRunable;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustShareCheckValidator;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperationStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class AdjustOperationThreadHelper {
    private static Integer defaultLimit = 2000;
    private static final String ADJLOGCACHESIGN = "BCM-AdjRecordLog-";

    public static DynamicObject excuteInThread(AdjustOperTypeEnum adjustOperTypeEnum, Map<String, Object> params, OperationRunable op) {
        long model = (Long)params.get("model");
        long scene = (Long)params.get("scenario");
        long year = (Long)params.get("year");
        long period = (Long)params.get("period");
        DynamicObject record = AdjustOperationThreadHelper.createAdjustOperRecord(adjustOperTypeEnum, model, scene, year, period, op.getCount());
        ThreadPoolService.runInAdjustOperThread(() -> {
            AdjRecordLog log = new AdjRecordLog();
            try {
                log.loadRecord(record);
                log.startLog();
                op.run(params, log);
            }
            catch (Throwable e) {
                log.setStatus(AdjustOperationStatusEnum.ERRORSTATUS.getStatus());
                log.addErrorMsg(AdjustmentServiceHelper.toString_Adj(e));
                log.getSuccessConut().set(0);
                if (op.getCount() > 0) {
                    log.setCount(op.getCount());
                }
            }
            finally {
                log.endLog();
                AdjustOperationThreadHelper.releaseAdjLogCache(record.getLong("id"));
                if (!adjustOperTypeEnum.isFlowControl() && adjustOperTypeEnum != AdjustOperTypeEnum.DELETEOPERATION || StringUtils.isNotEmpty((String)record.getString("failedlog"))) {
                    ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
                    AppLogInfo logInfo = OperationLogUtil.buildLogInfo(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)adjustOperTypeEnum.getNameBridge(), (String)adjustOperTypeEnum.getOperation()), OPDescMultiLangEnumBridge.genUnTransBridge((String)record.getString("failedlog")), (Long)model, "bcm_rptadjustentry_list");
                    logService.addLog(logInfo);
                }
            }
        });
        return record;
    }

    public static DynamicObject createAdjustOperRecord(AdjustOperTypeEnum oper, long model, long scenario, long year, long period, int count) {
        long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjustprogressentity");
        record.set("id", (Object)id);
        record.set("count", (Object)count);
        record.set("userid", (Object)RequestContext.get().getUserId());
        record.set("operationtype", (Object)oper.getValue());
        record.set("model", (Object)model);
        record.set("status", (Object)"1");
        record.set("begintime", (Object)TimeServiceHelper.now());
        record.set("scenario", (Object)scenario);
        record.set("year", (Object)year);
        record.set("period", (Object)period);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        return record;
    }

    public static void openAdjustOperLog(IFormView view, AdjustOperTypeEnum continueoperation, Map<String, Object> f7Map, CloseCallBack closedcallback) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_adjust_process");
        param.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u64cd\u4f5c\u8fdb\u5ea6", (String)"AdjustOperationThreadHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("KEY_MODEL_ID", f7Map.get("model"));
        param.setCustomParam("scenario", f7Map.get("scenario"));
        param.setCustomParam("year", f7Map.get("year"));
        param.setCustomParam("period", f7Map.get("period"));
        param.setCustomParam("operationtype", (Object)continueoperation.getValue());
        param.setCloseCallBack(closedcallback);
        view.showForm(param);
    }

    public static void shareAdjustOperation(Map<String, Object> f7Map, final boolean iscover, final Multimap<Long, Long> commonSettingOrgs, final Map<String, Object> paramMap) {
        paramMap.putAll(f7Map);
        if (commonSettingOrgs.keySet().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u5171\u4eab\u7684\u8c03\u6574\u62b5\u9500\u5206\u5f55\u3002", (String)"AdjustOperationThreadHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Long modelId = LongUtil.toLong((Object)f7Map.get("model"));
        IDNumberTreeNode tarNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)LongUtil.toLong((Object)paramMap.get("selectorgid")));
        if (tarNode != IDNumberTreeNode.NotFoundTreeNode && !PermissionServiceImpl.getInstance(modelId).hasWritePerm(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), tarNode.getId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d%s\u7ec4\u7ec7\u65e0\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustOperationThreadHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), tarNode.getNumber()));
        }
        AdjustOperationThreadHelper.excuteInThread(AdjustOperTypeEnum.SHAREOPERATION, f7Map, new OperationRunable(){

            @Override
            public int getCount() {
                return commonSettingOrgs.keySet().size();
            }

            @Override
            public void run(Map<String, Object> f7Map, AdjRecordLog adjLog) {
                Set ids = commonSettingOrgs.keySet();
                OperationResult tempResult = AdjustmentServiceHelper.checkAdjustByValidator((Long)f7Map.get("model"), new ArrayList<Object>(ids), e -> {
                    e.setValidateResult(new OperationResult());
                    e.setAdjLog(adjLog);
                    e.getCtx().addUserObject("selectorgid", paramMap.get("selectorgid"));
                    e.getCtx().addUserObject("commonSettingOrgs", commonSettingOrgs);
                    e.setOperationKey(AdjustOperTypeEnum.SHAREOPERATION.getOperation());
                    e.addValidator(new AdjustShareCheckValidator());
                    e.addValidator(new AdjustCheckDataNotNullValidator());
                    e.addValidator(new AdjustCheckDimMemValidator());
                    e.addValidator(new AdjustCheckPermValidator().setSkipOrg());
                });
                adjLog.setSuccessConut(tempResult.getSuccessPkIds().size());
                if (tempResult.getSuccessPkIds().size() > 0) {
                    ids.removeIf(pk -> !tempResult.getSuccessPkIds().contains(pk));
                    CslSchemeAdjustShareHelper helper = new CslSchemeAdjustShareHelper((Multimap<Long, Long>)commonSettingOrgs, iscover, true, paramMap, adjLog);
                    OperationResult operationResult = helper.createShareEntry(paramMap);
                    if (operationResult.getAllErrorInfo() != null && !operationResult.getAllErrorInfo().isEmpty()) {
                        operationResult.getAllErrorInfo().stream().forEach(e -> {
                            tempResult.addErrorInfo(e);
                            tempResult.getSuccessPkIds().remove(e.getPkValue());
                        });
                    }
                    adjLog.setSuccessConut(operationResult.getSuccessPkIds().size());
                }
            }
        });
    }

    public static void iterator(List pkids, boolean isBatch, AdjConsumer consumer) {
        AdjustOperQueryParam queryParam = new AdjustOperQueryParam(isBatch, 0);
        AdjustOperationThreadHelper.iterator(pkids, queryParam, consumer);
    }

    public static void iterator(List pkids, AdjustOperQueryParam queryParam, AdjConsumer consumer) {
        AdjustOperationThreadHelper.groupAdjustList(pkids, queryParam, (adjustDys, adjustDatas) -> adjustDys.forEach(p -> {
            consumer.accept((DynamicObject)p, (List)adjustDatas.get(p.getLong("id")));
            adjustDatas.remove(p.getLong("id"));
        }));
    }

    public static void groupAdjustList(List pkids, AdjustOperQueryParam param, AdjGroupByConsumer consumer) {
        AdjustOperationThreadHelper.groupList(pkids, param.isBatch()).forEach((index, idSet) -> {
            ArrayList<DynamicObject> adjustDys = new ArrayList<DynamicObject>(idSet.size());
            Map<Long, List<DynamicObject>> adjustDataDys = null;
            switch (param.getLoadType()) {
                case 0: {
                    Collections.addAll(adjustDys, BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust")));
                    adjustDataDys = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)param.getEntryFieldStr(), (QFilter[])new QFilter("adjust", "in", idSet).toArray())).collect(Collectors.groupingBy(p -> DynUtils.getBaseId((DynamicObject)p, (String)"adjust")));
                    break;
                }
                case 1: {
                    Collections.addAll(adjustDys, BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)param.getAdjustFieldStr(), (QFilter[])new QFilter("id", "in", idSet).toArray()));
                    adjustDataDys = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)param.getEntryFieldStr(), (QFilter[])new QFilter("adjust", "in", idSet).toArray())).collect(Collectors.groupingBy(p -> DynUtils.getBaseId((DynamicObject)p, (String)"adjust")));
                    break;
                }
                case 2: {
                    adjustDys.addAll((Collection<DynamicObject>)QueryServiceHelper.query((String)"bcm_rptadjust", (String)param.getAdjustFieldStr(), (QFilter[])new QFilter("id", "in", idSet).toArray()));
                    adjustDataDys = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)param.getEntryFieldStr(), (QFilter[])new QFilter("adjust", "in", idSet).toArray()).stream().collect(Collectors.groupingBy(p -> DynUtils.getBaseId((DynamicObject)p, (String)"adjust")));
                    break;
                }
                case 3: {
                    Collections.addAll(adjustDys, BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)param.getAdjustFieldStr(), (QFilter[])new QFilter("id", "in", idSet).toArray()));
                    adjustDataDys = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)param.getEntryFieldStr(), (QFilter[])new QFilter("model", "=", (Object)param.getModelId()).and("isdefaultcurrency", "=", (Object)"1").and("adjust", "in", idSet).toArray()).stream().collect(Collectors.groupingBy(p -> DynUtils.getBaseId((DynamicObject)p, (String)"adjust")));
                    break;
                }
            }
            consumer.accept(adjustDys, adjustDataDys);
        });
    }

    public static Map<Integer, List> groupList(List pkids, boolean isBatch) {
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        if (isBatch) {
            int listSize = pkids.size();
            int toIndex = defaultLimit;
            for (int i = 0; i < pkids.size(); i += defaultLimit.intValue()) {
                if (i + defaultLimit > listSize) {
                    toIndex = listSize - i;
                }
                List newList = pkids.subList(i, i + toIndex);
                map.put(i, newList);
            }
        } else {
            map.put(0, pkids);
        }
        return map;
    }

    public static void showDetailLogForm(IFormView view, long logId) {
        DynamicObject record = AdjustOperationThreadHelper.getAdjLogFromCache(logId);
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u4fe1\u606f", (String)"AdjustOperationThreadHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("operationtype", (Object)record.getString("operationtype"));
        param.setCustomParam("status", (Object)record.getString("status"));
        param.setCustomParam("log", (Object)record.getString("failedlog"));
        param.setFormId("bcm_adjustprogress_tip");
        view.showForm(param);
    }

    public static void updateAdjLogCache(long recordId, int count, int successcount, int errorcount) {
        HashMap<String, Integer> redis_Sign = new HashMap<String, Integer>();
        redis_Sign.put("successcount", successcount);
        redis_Sign.put("errorcount", errorcount);
        redis_Sign.put("count", count);
        AppCacheServiceHelper.put(ADJLOGCACHESIGN + recordId, ObjectSerialUtil.toByteSerialized(redis_Sign));
    }

    public static DynamicObject getAdjLogFromCache(Long recordId) {
        String cache = (String)AppCacheServiceHelper.get(ADJLOGCACHESIGN + recordId);
        DynamicObject log = BusinessDataServiceHelper.loadSingleFromCache((Object)recordId, (String)"bcm_adjustprogressentity");
        if (StringUtils.isNotEmpty((String)cache)) {
            Map result = (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
            log.set("successcount", result.get("successcount"));
            log.set("errorcount", result.get("errorcount"));
            log.set("count", result.get("count"));
        }
        return log;
    }

    public static void releaseAdjLogCache(Long recordId) {
        AppCacheServiceHelper.remove(ADJLOGCACHESIGN + recordId);
    }

    public static interface AdjGroupByConsumer {
        public void accept(List<DynamicObject> var1, Map<Long, List<DynamicObject>> var2);
    }
}

