/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.convert.AdjustRateDiffCreateService;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.AdjustDataSaveParam;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustFlowOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AdjustSaveOperation
extends AdjustFlowOperation {
    private static final String RPTADJUST_RECORDS = "rptadjust_records";
    public static final Set<Integer> NOCHANGESOURCETYPESET = Collections.unmodifiableSet(new HashSet(5){
        {
            this.add(ElimRptAdjSourceTypeEnum.CONTINUE.getValue());
            this.add(ElimRptAdjSourceTypeEnum.LINK.getValue());
            this.add(ElimRptAdjSourceTypeEnum.SHARE.getValue());
            this.add(ElimRptAdjSourceTypeEnum.CHARGE.getValue());
            this.add(ElimRptAdjSourceTypeEnum.IMPORT.getValue());
            this.add(ElimRptAdjSourceTypeEnum.COPY.getValue());
        }
    });
    private boolean isSource;
    protected OperationResult op = new OperationResult();
    private final List<Long> allElimIds;
    protected AdjustDataSaveParam dataSaveParam;
    private AdjustRateDiffCreateService rateDiff;
    private AdjustBalanceCheckService balanceCheckService;

    public AdjustSaveOperation(AdjustOperationContext ctx, List<Long> pkids, AdjustDataSaveParam dataSaveParam) {
        super(ctx, pkids, AdjustOperTypeEnum.SAVEOPERATION);
        this.dataSaveParam = dataSaveParam;
        this.allElimIds = pkids;
        this.op.setBillCount(pkids.size());
        if (dataSaveParam.isAutoCreateRiff()) {
            try {
                this.rateDiff = new AdjustRateDiffCreateService(ctx.getModelId(), this.getScene(), this.getYear(), this.getPeriod());
            }
            catch (KDBizException e) {
                this.log.info(e.getMessage());
            }
        }
        this.balanceCheckService = new AdjustBalanceCheckService(this.getModelId());
    }

    @Override
    protected void beforeExcute() {
        this.tarStatus = RptAdjustStatusEnum.SAVE;
    }

    @Override
    public void excute() {
        this.excuteBySourceType(true);
        this.excuteBySourceType(false);
        this.setOp(this.op);
    }

    protected void writeLog(OperationResult operationResult) {
        this.writeOperationLog(operationResult, this.getModelId(), this.allElimIds, this.tarStatus.text());
    }

    protected void excuteBySourceType(boolean isSource) {
        this.isSource = isSource;
        QFBuilder qb = new QFBuilder();
        qb.add("id", "in", this.allElimIds);
        qb.add("sourcetype", isSource ? "!=" : "=", (Object)Integer.toString(ElimRptAdjSourceTypeEnum.LINK.getValue()));
        this.setPkids(QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])qb.toArray(), null, (int)-1).stream().map(p -> (Long)p).collect(Collectors.toList()));
        if (this.getPkids().size() > 0) {
            super.excute();
            this.op.getAllErrorInfo().addAll(this.getOperationResult().getAllErrorInfo());
            this.op.getSuccessPkIds().addAll(this.getOperationResult().getSuccessPkIds());
            this.clearOperationRseult();
        }
    }

    @Override
    protected void dealAdjustDatas(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        long id = adjustDy.getLong("id");
        if (!this.getOperationResult().getSuccessPkIds().contains(id)) {
            this.getOperationResult().getSuccessPkIds().add(id);
        }
        if (this.isEnable(id) && !adjustDatas.isEmpty()) {
            adjustDatas.parallelStream().forEach(adjustData -> {
                adjustData.set("cvtbeforesummoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)adjustData.getBigDecimal("cvtbeforedebit"), (BigDecimal)adjustData.getBigDecimal("cvtbeforecredit")));
                adjustData.set("summoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)adjustData.getBigDecimal("debit"), (BigDecimal)adjustData.getBigDecimal("credit")));
            });
            this.actx.addUserObject(RPTADJUST_RECORDS, Pair.onePair((Object)adjustDy, adjustDatas));
        }
    }

    private void dealOperData(DynamicObject newElim, String status) {
        newElim.set("submitter", null);
        newElim.set("submittime", null);
        newElim.set("cancelsubmitter", null);
        newElim.set("cancelsubmittime", null);
        newElim.set("ratifier", null);
        newElim.set("ratifytime", null);
        newElim.set("cancelratifier", null);
        newElim.set("cancelratifytime", null);
        newElim.set("reviewer", null);
        newElim.set("reviewtime", null);
        newElim.set("callbacker", null);
        newElim.set("callbacktime", null);
        newElim.set("modifier", null);
        newElim.set("modifytime", null);
        newElim.set("status", (Object)status);
        if (newElim.getBoolean("multiplecurrency") || ConfigServiceHelper.getBoolParam(this.getModelId(), "isNoKeepAdjustSpreadJson")) {
            newElim.set("spreadjson", null);
            newElim.set("data", null);
        }
        newElim.set("modifier", (Object)this.actx.getUser());
        newElim.set("modifytime", (Object)TimeServiceHelper.now());
        if (RptAdjustStatusEnum.COMMIT.status().equals(status)) {
            newElim.set("submitter", (Object)this.actx.getUser());
            newElim.set("submittime", (Object)TimeServiceHelper.now());
        }
        if (!NOCHANGESOURCETYPESET.contains(newElim.getInt("sourcetype"))) {
            newElim.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.MANUAL.getValue());
        }
    }

    protected void createRow4RateDiff(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        try {
            List<DynamicObject> riffs = this.rateDiff.createRateDiffSingleElim(adjustDatas, adjustDy.getBoolean("multiplecurrency"));
            adjustDatas.clear();
            adjustDatas.addAll(riffs);
        }
        catch (CvtExchangeException e) {
            this.addErrorOper(adjustDy.getString("number"), adjustDy.getLong("id"), e.toString().substring(CvtExchangeException.class.getName().length() + 1));
        }
        catch (Exception e) {
            this.addErrorOper(adjustDy.getString("number"), adjustDy.getLong("id"), String.format(ResManager.loadKDString((String)"\u751f\u6210\u6c47\u7387\u6298\u7b97\u5dee\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"AdjustSaveOperation_23", (String)"fi-bcm-business", (Object[])new Object[0]), ThrowableHelper.toString((Exception)e)));
        }
    }

    private boolean checkBalance(DynamicObject adjustDy, List<DynamicObject> adjustDatas) {
        boolean isBalance = true;
        if (this.isSource() && !(isBalance = this.balanceCheckService.isBalance(adjustDy, adjustDatas))) {
            this.addWarnOper(adjustDy.getString("number"), adjustDy.getLong("id"), ResManager.loadKDString((String)"\u5206\u7ec4\u5931\u8d25\u6216\u8005\u501f\u8d37\u4e0d\u5e73\u8861\uff0c\u5df2\u81ea\u52a8\u8f6c\u4e3a\u6682\u5b58\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustSaveOperation_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return isBalance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExcute() {
        try {
            if (this.getOperationResult().getSuccessPkIds() != null && !this.getOperationResult().getSuccessPkIds().isEmpty()) {
                Map<Long, Pair<DynamicObject, List<DynamicObject>>> adjusts = this.actx.getUserObject(RPTADJUST_RECORDS).stream().map(e -> (Pair)e).collect(Collectors.toMap(k -> ((DynamicObject)k.p1).getLong("id"), v -> v));
                this.generateLinkageData(adjusts);
                this.generateAdjustRateDiff(adjusts);
                if (this.dataSaveParam.isResetGmSeq()) {
                    adjusts.forEach((adjustId, adjustPair) -> {
                        if (this.isEnable((Long)adjustId)) {
                            AdjustConvertUtil.resetSeq((List)adjustPair.p2);
                        }
                    });
                }
                String tarStatus = this.dataSaveParam.isAutoSubmit() ? RptAdjustStatusEnum.COMMIT.status() : RptAdjustStatusEnum.SAVE.status();
                ArrayList<DynamicObject> adjustHeaderList = new ArrayList<DynamicObject>(adjusts.size());
                ArrayList adjustDataList = new ArrayList(adjusts.size());
                ArrayList needDelRateDiffList = new ArrayList();
                adjusts.forEach((adjustId, adjustPair) -> {
                    if (this.isEnable((Long)adjustId) && !((List)adjustPair.p2).isEmpty()) {
                        boolean isBalance = this.checkBalance((DynamicObject)adjustPair.p1, (List)adjustPair.p2);
                        this.dealOperData((DynamicObject)adjustPair.p1, isBalance ? tarStatus : RptAdjustStatusEnum.TEMPSAVE.status());
                        ((List)adjustPair.p2).forEach(entry -> {
                            entry.set("merge", (Object)DynUtils.getBaseId((DynamicObject)((DynamicObject)adjustPair.p1), (String)"entity"));
                            AdjustOperationHelper.fillAdjustDataOfOlapOrg(this.getModelNum(), ((DynamicObject)adjustPair.p1).getString("process"), entry);
                        });
                        if (this.dataSaveParam.isAutoCreateRiff()) {
                            needDelRateDiffList.add(adjustId);
                        }
                        adjustHeaderList.add((DynamicObject)adjustPair.p1);
                        adjustDataList.addAll((Collection)adjustPair.p2);
                        this.addSuccessOper((Long)adjustId);
                    }
                });
                if (this.dataSaveParam.isAutoCreateRiff() && !needDelRateDiffList.isEmpty()) {
                    DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])new QFilter[]{new QFilter("adjust", "in", needDelRateDiffList), new QFilter("entryrowtype", "in", (Object)new String[]{AdjustEntryRowTypeEnum.CURR_DIFF.getValue() + "", AdjustEntryRowTypeEnum.RATE_DIFF.getValue() + ""})});
                }
                if (!adjustHeaderList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])adjustHeaderList.toArray(new DynamicObject[0]));
                    AdjustmentServiceHelper.saveContinueHistory(adjustHeaderList);
                    AdjustmentServiceHelper.updateCheckTmplState(this.getModelId(), adjustHeaderList.stream().map(e -> e.getLong("id")).collect(Collectors.toList()), true);
                }
                if (!adjustDataList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])adjustDataList.toArray(new DynamicObject[0]));
                }
            }
        }
        finally {
            this.actx.getUserObject().removeAll((Object)"bcm_rptadjust");
            this.actx.getUserObject().removeAll((Object)"bcm_rptadjustdata");
            this.writeLog(this.op);
        }
    }

    private void generateAdjustRateDiff(Map<Long, Pair<DynamicObject, List<DynamicObject>>> adjusts) {
        if (this.dataSaveParam.isAutoCreateRiff()) {
            if (this.rateDiff == null) {
                this.addWarnOper(ResManager.loadKDString((String)"\u4f53\u7cfb\u7ef4\u5ea6", (String)"AdjustSaveOperation_25", (String)"fi-bcm-business", (Object[])new Object[0]), 0L, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u7f3a\u5c11\u5f00\u542f\u7528\u4e8e\u751f\u6210\u6c47\u7387\u6298\u7b97\u5dee\u7684\u6210\u5458\u3002", (String)"AdjustSaveOperation_26", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            if (adjusts != null && !adjusts.isEmpty()) {
                adjusts.forEach((adjustId, adjust) -> {
                    if (this.isEnable((Long)adjustId)) {
                        this.createRow4RateDiff((DynamicObject)adjust.p1, (List)adjust.p2);
                    }
                });
            }
        }
    }

    private void generateLinkageData(Map<Long, Pair<DynamicObject, List<DynamicObject>>> adjusts) {
        if (this.isSource() && !adjusts.isEmpty()) {
            boolean isCM017 = this.isCM017();
            Map<Long, DynamicObject> ids = adjusts.values().stream().map(e -> (DynamicObject)e.p1).filter(adjustDy -> this.isEnable(adjustDy.getLong("id")) && !AdjustLinkCreateEnum.COMMONADJUST.getStatus().equals(adjustDy.getString("linkcreatetype")) && (this.dataSaveParam.isRebuildLinkMap() || !isCM017 && AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus().equals(adjustDy.getString("linkcreatetype")))).collect(Collectors.toMap(k -> k.getLong("id"), k -> k));
            if (!ids.isEmpty()) {
                LinkageMappingService linkageMappingService = new LinkageMappingService(this.getModelId(), (Long)this.getYear(), (Long)this.getScene(), (Long)this.getPeriod(), ids.keySet(), this.dataSaveParam.isKeepMotify());
                LinkageDataCollector linkageDataCollector = linkageMappingService.rebuildLinkage();
                ids.forEach((k, v) -> {
                    if (!linkageDataCollector.createLinkageIsOk((Long)k)) {
                        this.addWarnOper(v.getString("number"), v.getLong("id"), ResManager.loadKDString((String)"\u751f\u6210\u7684\u8054\u52a8\u5206\u5f55\u6709\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5728\u8054\u52a8\u5206\u5f55\u754c\u9762\u7ef4\u62a4\u518d\u91cd\u65b0\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"AdjustSaveOperation_27", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                });
                Map<Long, Long> sourceId2LinkageIdMap = linkageDataCollector.getSourceId2LinkageIdMap();
                HashSet<Long> sets = new HashSet<Long>(sourceId2LinkageIdMap.keySet());
                sets.addAll(sourceId2LinkageIdMap.values());
                DynamicObject[] rptadjustdatas = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("adjust", "in", sets)}, null);
                HashMap<Long, List> listMap = new HashMap<Long, List>(sourceId2LinkageIdMap.size());
                if (rptadjustdatas != null && rptadjustdatas.length > 0) {
                    HashMap linkageId2SourceId = new HashMap();
                    sourceId2LinkageIdMap.forEach((k, v) -> {
                        if (v != 0L) {
                            linkageId2SourceId.put(v, (Long)k);
                        }
                    });
                    for (DynamicObject rptadjustdata : rptadjustdatas) {
                        long adjustId = rptadjustdata.getLong("adjust.id");
                        long l = adjustId = sourceId2LinkageIdMap.containsKey(adjustId) ? adjustId : linkageId2SourceId.getOrDefault(adjustId, 0L);
                        if (adjustId == 0L) continue;
                        listMap.computeIfAbsent(adjustId, e -> new ArrayList()).add(rptadjustdata);
                    }
                }
                for (Map.Entry entry : listMap.entrySet()) {
                    Pair<DynamicObject, List<DynamicObject>> adjustPair = adjusts.get(entry.getKey());
                    if (adjustPair == null) continue;
                    ((List)adjustPair.p2).clear();
                    ((List)adjustPair.p2).addAll((Collection)entry.getValue());
                }
            }
        }
    }

    @Override
    protected boolean needBatchExcute() {
        return this.actx.getUserObject().containsKey((Object)"bcm_rptadjustdata") && this.actx.getUserObject("bcm_rptadjustdata").size() > 5000;
    }

    @Override
    protected AdjustOperTypeEnum getOperationType() {
        return AdjustOperTypeEnum.SAVEOPERATION;
    }

    private boolean isCM017() {
        return ConfigServiceHelper.getBoolParam(this.getModelId(), "CM017");
    }

    protected boolean isSource() {
        return this.isSource;
    }

    protected boolean isEnable(Long id) {
        return this.getOperationResult().getSuccessPkIds().contains(id);
    }
}

