/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustCopySetParam;
import kd.fi.bcm.business.adjust.operation.AdjustCopyOperation;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustSkipOrgCopyOperaiton
extends AdjustCopyOperation {
    private final AdjustCopySetParam copySetting;
    private final DynamicObject tarOrgNode;

    public AdjustSkipOrgCopyOperaiton(Long modelId, List<Long> pkids, AdjustCopySetParam copySetting) {
        super(modelId, copySetting.getTarScene(), copySetting.getTarYear(), copySetting.getTarPeriod(), pkids, false);
        this.copySetting = copySetting;
        this.tarOrgNode = BusinessDataServiceHelper.loadSingle((Object)copySetting.getTarOrg(), (String)"bcm_entitymembertree");
        this.tarScene = BusinessDataServiceHelper.loadSingle((Object)copySetting.getTarScene(), (String)"bcm_scenemembertree");
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.getValidators().stream().filter(a -> a instanceof AdjustCheckPermValidator).forEach(a -> ((AdjustCheckPermValidator)a).setSkipOrg());
        e.addValidator(new AbstractValidator(){
            boolean isTarOrgNoPerm;

            @Override
            protected void beforeValidate() {
                super.beforeValidate();
                this.isTarOrgNoPerm = !PermissionServiceImpl.getInstance(this.getModelId()).hasWritePerm(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Entity"), AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getLong("id"));
            }

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                if (this.isTarOrgNoPerm) {
                    this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u65e0\u6743\u6216\u8005\u53ea\u8bfb\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"AdjustSkipOrgCopyOperaiton_1", (String)"fi-bcm-business", (Object[])new Object[0]), AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getString("number")));
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String processNum = adjust.getString("process");
                if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
                    adjustDataList.removeIf(adjustData -> {
                        if (CollectionUtil.isEmpty(InvestServiceHelper.queryEffectiveOrgList(this.getModelId(), AdjustSkipOrgCopyOperaiton.this.tarScene.getLong("id"), AdjustSkipOrgCopyOperaiton.this.tarYear.getLong("id"), AdjustSkipOrgCopyOperaiton.this.tarPeriod.getLong("id"), AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getLong("id"), adjustData.getString("entity.number"))) && ConfigServiceHelper.getBoolParam(this.getModelId(), "isDeleteAdjustEntryWhenCopying")) {
                            if (adjustData.getBoolean("isdefaultcurrency")) {
                                sb.append(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7%1$s\u5e8f\u53f7%2$s\u7684\u5206\u5f55\u5df2\u88ab\u5254\u9664\uff0c\u539f\u56e0\u4e3a\u5f53\u524d\u5408\u5e76\u8282\u70b9\u4e0d\u5305\u542b\u6709\u6548\u7684\u8be5\u884c\u7ec4\u7ec7(%3$s)\u6216\u8005\u4e0d\u53c2\u4e0e\u5408\u5e76\u3002", (String)"AdjustSkipOrgCopyOperaiton_3", (String)"fi-bcm-business", (Object[])new Object[0]), adjustData.getString("groupnum"), adjustData.getString("dseq"), adjustData.getString("entity.number")));
                            }
                            return true;
                        }
                        return false;
                    });
                }
                if (AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getBoolean("isleaf") && !"ERAdj".equals(processNum) && !"RAdj".equals(processNum)) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7\u4e0d\u53ef\u590d\u5236\u62b5\u9500\u7c7b\u7684\u5206\u5f55\u3002", (String)"AdjustSkipOrgCopyOperaiton_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (!OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
                    adjust.getDynamicObjectCollection("commembentry").forEach(e -> {
                        if (DimTypesEnum.MYCOMPANY.getNumber().equals(e.getString("comdimension.number"))) {
                            long commembid = e.getLong("commembid");
                            if (commembid != 0L) {
                                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_mycompanymembertree", (Long)commembid);
                                if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) {
                                    IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getString("number"));
                                    if (mc == IDNumberTreeNode.NotFoundTreeNode) {
                                        this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u89e3\u6790\u627e\u4e0d\u5230\u6307\u5b9a\u6210\u5458%s\u3002", (String)"AdjustSkipOrgCopyOperaiton_5", (String)"fi-bcm-business", (Object[])new Object[0]), AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getString("number")));
                                    } else if (StorageTypeEnum.LABEL == mc.getStorageType()) {
                                        this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u7f16\u7801%s \u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u3002", (String)"AdjustSkipOrgCopyOperaiton_6", (String)"fi-bcm-business", (Object[])new Object[0]), AdjustSkipOrgCopyOperaiton.this.tarOrgNode.getString("number")));
                                    }
                                }
                            }
                            return;
                        }
                    });
                }
                if (WatchLoggerUtil.isDebug() && sb.length() > 0) {
                    this.addWarningMessage(adjust, sb.toString());
                }
            }

            @Override
            protected String getValidatorKey() {
                return "CheckAdjustSkipOrgCopyOperaiton";
            }
        });
    }

    private DynamicObject queryDefaultMergeDy() {
        return (DynamicObject)ThreadCache.get((Object)"defBelongOrgDy", () -> {
            QFBuilder qf = new QFBuilder("parent.number", "=", (Object)"Entity");
            qf.and("cslscheme", "=", (Object)this.copySetting.getCsl());
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"number,id", (QFilter[])qf.toArray());
        });
    }

    @Override
    protected void dealAdjustDimension(DynamicObject oldElim, DynamicObject newElim) {
        super.dealAdjustDimension(oldElim, newElim);
        DynamicObjectCollection commembentry = newElim.getDynamicObjectCollection("commembentry");
        for (DynamicObject commemb : commembentry) {
            commemb.set("id", null);
            if (!DimTypesEnum.ENTITY.getNumber().equals(commemb.getString("comdimension.number"))) continue;
            if (OrgRelaProcessMembPool.isRelaProcess((String)oldElim.getString("process"))) {
                commemb.set("commembid", (Object)this.tarOrgNode.getLong("id"));
                continue;
            }
            commemb.set("commembid", (Object)this.queryDefaultMergeDy().getLong("id"));
        }
    }

    @Override
    protected void dealElimOtherProperities(DynamicObject adjustDy, DynamicObject newElim) {
        super.dealElimOtherProperities(adjustDy, newElim);
        String processNum = adjustDy.getString("process");
        if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
            this.replaceMergeAdjustHead(newElim);
        } else {
            this.replaceSingleAdjustHead(newElim);
        }
    }

    private void replaceMergeAdjustHead(DynamicObject newElim) {
        newElim.set("belongorg", (Object)this.tarOrgNode);
        newElim.set("entity", (Object)this.tarOrgNode);
        if (newElim.getBoolean("multiplecurrency") && this.copySetting.getNewInputCurrency() != null) {
            newElim.set("cvtbeforecurrency", (Object)this.parseRealCurrency(newElim.getString("process"), this.copySetting.getNewInputCurrency()));
        }
        newElim.set("year", (Object)this.tarYear);
        newElim.set("period", (Object)this.tarPeriod);
        if (this.copySetting.getTarCalLog() != null) {
            newElim.set("templatecatalog", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)this.copySetting.getTarCalLog(), (String)"bcm_templatecatalog"));
        }
    }

    private void replaceSingleAdjustHead(DynamicObject newElim) {
        newElim.set("belongorg", (Object)this.tarOrgNode);
        newElim.set("entity", (Object)this.tarOrgNode);
        newElim.set("scenario", (Object)this.tarScene);
        newElim.set("year", (Object)this.tarYear);
        newElim.set("period", (Object)this.tarPeriod);
        if (this.copySetting.getTarCalLog() != null) {
            newElim.set("templatecatalog", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)this.copySetting.getTarCalLog(), (String)"bcm_templatecatalog"));
        }
    }

    @Override
    protected List<DynamicObject> buildNewElimEntries(DynamicObject oldElim, DynamicObject newElim, List<DynamicObject> adjustDataList) {
        ArrayList<DynamicObject> newEntries = new ArrayList<DynamicObject>(adjustDataList.size());
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject entryClone = null;
        boolean isLink = this.isLinkAdjust(oldElim);
        for (DynamicObject adjustData : adjustDataList) {
            if (!adjustData.getBoolean("isdefaultcurrency")) continue;
            entryClone = (DynamicObject)cloneUtils.clone(adjustData.getDataEntityType(), (Object)adjustData);
            entryClone.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            entryClone.set("adjust", (Object)newElim);
            entryClone.set("scenario", (Object)this.tarScene);
            entryClone.set("year", (Object)this.tarYear);
            entryClone.set("period", (Object)this.tarPeriod);
            if (this.manJourMem != null && (this.isAutoAdjust(newElim) || isLink)) {
                entryClone.set("audittrail", (Object)this.manJourMem);
                entryClone.set("checkrecordentry", (Object)0);
            }
            if (!isLink && EntrySourceEnum.getLinkList().contains(adjustData.getInt("entrysource"))) {
                entryClone.set("entrysource", (Object)4);
            } else {
                entryClone.set("entrysource", (Object)3);
                newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
            }
            entryClone.set("ischanged", (Object)Character.valueOf('0'));
            if (OrgRelaProcessMembPool.isRelaProcess((String)newElim.getString("process"))) {
                entryClone.set("merge", (Object)this.tarOrgNode);
                DynamicObject entityDyn = this.queryTarOrgChildren(entryClone.getString("entity.number"));
                entryClone.set("entity", (Object)entityDyn);
                if (entityDyn == null) {
                    entryClone.set("olaporg", (Object)this.tarOrgNode.getString("number"));
                }
            } else {
                entryClone.set("entity", (Object)this.tarOrgNode);
                this.convertMyCompanyVar(newElim, entryClone);
            }
            AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)newElim, newEntries, (boolean)true);
            AdjustOperationHelper.fillAdjustDataOfOlapOrg(MemberReader.findModelNumberById((Object)this.getModelId()), newElim.getString("process"), entryClone);
            Long defaultCurr = newElim.getDynamicObjectCollection("commembentry").stream().filter(p -> DimTypesEnum.CURRENCY.getNumber().equals(p.getString("comdimension.number"))).findFirst().map(curr -> curr.getLong("commembid")).orElse(null);
            entryClone.set("currency", (Object)this.parseRealCurrency(newElim.getString("process"), defaultCurr));
            this.changeCarryYearAdjustElim(entryClone);
            this.dealEntryPrecision(entryClone);
            if (this.isNeedConvert(oldElim) && entryClone.get("entity") != null) {
                Set<Long> multipleCurrency = AdjustConvertUtil.getMultipleCurrency(this.getModelId(), this.tarOrgNode.getLong("id"), newElim.getString("bussnesstype"));
                for (Long curr2 : multipleCurrency) {
                    DynamicObject otherCurrEntryClone = (DynamicObject)cloneUtils.clone(entryClone.getDataEntityType(), (Object)entryClone);
                    otherCurrEntryClone.set("currency", (Object)this.parseRealCurrency(newElim.getString("process"), curr2));
                    otherCurrEntryClone.set("isdefaultcurrency", (Object)"0");
                    newEntries.add(otherCurrEntryClone);
                }
            }
            newEntries.add(entryClone);
        }
        return newEntries;
    }

    private DynamicObject queryTarOrgChildren(String childNum) {
        Long orgId = InvestServiceHelper.queryEffectiveOrg(this.getModelId(), this.tarScene.getLong("id"), this.tarYear.getLong("id"), this.tarPeriod.getLong("id"), this.tarOrgNode.getLong("id"), childNum);
        if (orgId == 0L) {
            return null;
        }
        DynamicObject orgDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
        orgDy.set("id", (Object)orgId);
        return orgDy;
    }

    private void convertMyCompanyVar(DynamicObject adjust, DynamicObject adjustData) {
        adjust.getDynamicObjectCollection("commembentry").forEach(e -> {
            long commembid;
            if (DimTypesEnum.MYCOMPANY.getNumber().equals(e.getString("comdimension.number")) && (commembid = e.getLong("commembid")) != 0L) {
                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_mycompanymembertree", (Long)commembid);
                if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) {
                    IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)this.tarOrgNode.getString("number"));
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mycompanymembertree");
                    dy.set("id", (Object)mc.getId());
                    dy.set("name", (Object)mc.getName());
                    dy.set("number", (Object)mc.getNumber());
                    adjustData.set("mycompany", (Object)dy);
                    return;
                }
            }
        });
    }

    @Override
    protected boolean isNeedConvert(DynamicObject adjustDy) {
        return adjustDy.getBoolean("multiplecurrency") || adjustDy.get("cvtbeforecurrency") instanceof DynamicObject;
    }

    private DynamicObject parseRealCurrency(String processNum, Long currencyId) {
        DynamicObject currDy = null;
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)this.getModelNum(), (Long)currencyId);
        if (IDNumberTreeNode.NotFoundTreeNode != currencyNode) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)this.tarOrgNode.getLong("id"));
            if ("DC".equals(currencyNode.getNumber())) {
                currencyNode = "Entity".equals(orgNode.getParent().getNumber()) ? MemberReader.findCurrencyMemberByNum((String)this.getModelNum(), (String)orgNode.getCurrency()) : (OrgRelaProcessMembPool.isRelaProcess((String)processNum) || "RAdj".equals(processNum) ? MemberReader.findCurrencyMemberByNum((String)this.getModelNum(), (String)orgNode.getParent().getCurrency()) : MemberReader.findCurrencyMemberByNum((String)this.getModelNum(), (String)orgNode.getCurrency()));
            } else if ("EC".equals(currencyNode.getNumber())) {
                currencyNode = MemberReader.findCurrencyMemberByNum((String)this.getModelNum(), (String)orgNode.getCurrency());
            }
            currDy = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyNode.getId(), (String)"bcm_currencymembertree");
        }
        return currDy;
    }
}

