/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import com.google.common.collect.HashMultimap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class DebugLogCollector {
    private HashMultimap<String, String> debugInfos = HashMultimap.create();
    private HashMultimap<String, String> errorInfos = HashMultimap.create();
    private final StringBuilder msgHandler = new StringBuilder();
    private boolean isDebug = WatchLoggerUtil.isDebug();

    public void addErrorLog(String key, String msg) {
        this.errorInfos.put((Object)key, (Object)msg);
    }

    public void addDebugLog(String key, String msg) {
        if (this.isDebug) {
            this.debugInfos.put((Object)key, (Object)msg);
        }
    }

    public void addDebugLog(String key, Supplier<String> supplier) {
        String msg;
        if (this.isDebug && !StringUtils.isEmpty((CharSequence)(msg = supplier.get()))) {
            this.debugInfos.put((Object)key, (Object)msg);
        }
    }

    public void addDebugLog(Consumer<HashMultimap<String, String>> consumer) {
        if (this.isDebug) {
            consumer.accept(this.debugInfos);
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void end(String prefix) {
        this.end(prefix, "&&");
    }

    public void end(String prefix, String split) {
        if (this.isDebug && !this.debugInfos.isEmpty() || !this.errorInfos.isEmpty()) {
            this.errorInfos.asMap().forEach((tmpNumber, errorMsgList) -> this.msgHandler.append((String)tmpNumber).append("[").append(String.join((CharSequence)"&&", errorMsgList)).append("]"));
            this.debugInfos.asMap().forEach((tmpNumber, errorMsgList) -> this.msgHandler.append((String)tmpNumber).append("[").append(String.join((CharSequence)"&&", errorMsgList)).append("]"));
            this.debugInfos.clear();
        }
    }

    public String log() {
        return this.msgHandler.toString();
    }
}

