/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;

public interface IAdjustOperationLogService {
    public long getYear();

    public long getPeriod();

    default public void writeOperationLog(OperationResult operationResult, long modelId, Collection<Long> pkids, String operationText) {
        try {
            List errorList = operationResult.getAllErrorInfo();
            HashSet<String> errNumbers = new HashSet<String>(10);
            for (OperateErrorInfo operateErrorInfo : errorList) {
                String number = operateErrorInfo.toString().substring(0, operateErrorInfo.toString().indexOf(58));
                errNumbers.add(number);
            }
            QFilter qFilter = new QFilter("id", "in", pkids);
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            String msgFormat = "%s %s ".concat(MemberReader.findFyMemberById((String)modelNumber, (Long)this.getYear()).getName()).concat(" ").concat(MemberReader.findPeriodMemberById((String)modelNumber, (Long)this.getPeriod()).getName()).concat(",").concat(operationText).concat("%s");
            ArrayList<String> opDescriotions = new ArrayList<String>(10);
            QueryServiceHelper.query((String)"bcm_rptadjust", (String)"number,entity.name,process", (QFilter[])new QFilter[]{qFilter}).forEach(dy -> {
                boolean isErr = errNumbers.contains(dy.getString("number"));
                String tips = isErr ? ResultStatusEnum.FAIL.getName() : ResultStatusEnum.SUCCESS.getName();
                String orgName = "";
                if (OrgRelaProcessMembPool.isRelaProcess((String)dy.getString("process"))) {
                    orgName = dy.getString("entity.name");
                }
                opDescriotions.add(String.format(msgFormat, dy.getString("number"), orgName, tips));
            });
            OperationLogUtil.batchWriteOperationLog(operationText, opDescriotions, modelId, "bcm_rptadjust_list");
        }
        catch (Exception e) {
            BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass()).error((Throwable)e);
        }
    }
}

