/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.query;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.DynUtils;

class PackDataModel {
    private DynamicObject currDy;
    private SchemeContext _cxt;
    private boolean isMerge = false;
    Map<String, Dimension> dimFields;
    private Map<String, String> bizType;

    public PackDataModel(SchemeContext schemeContext) {
        this._cxt = schemeContext;
    }

    public void formatRow(DynamicObject dy) {
        if (dy == this.currDy) {
            return;
        }
        this.isMerge = OrgRelaProcessMembPool.isRelaProcess((String)dy.getString("process.number"));
        this.currDy = dy;
    }

    public Map<String, Dimension> getDimFields() {
        if (this.dimFields == null) {
            this.dimFields = new HashMap<String, Dimension>(this._cxt.getDimensions().size() + 1);
            this._cxt.getDimensions().stream().forEach(e -> this.dimFields.put(e.getFieldmapped() + ".number", (Dimension)e));
        }
        return this.dimFields;
    }

    public void getFormatValue(PackageDataEvent e) {
        String key = ((ColumnDesc)e.getSource()).getKey();
        if (DecimalColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            if ("debit".equals(key) || "credit".equals(key)) {
                DynUtils.formatNumber((PackageDataEvent)e);
            }
        } else if (BaseDataColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            if ("adjust.bussnesstype".equals(key)) {
                e.setFormatValue((Object)this.getBizType().getOrDefault(e.getFormatValue(), e.getFormatValue().toString()));
            } else if ("merge.number".equals(key)) {
                if (this.isMerge) {
                    IDNumberTreeNode idNumberTreeNode = MemberReader.findMemberById((long)this._cxt.getModel(), (String)"bcm_entitymembertree", (Long)DynUtils.getBaseId((DynamicObject)e.getRowData(), (String)"adjust.entity"));
                    e.setFormatValue((Object)(idNumberTreeNode.getNumber() + " | " + idNumberTreeNode.getName()));
                } else {
                    e.setFormatValue((Object)"-");
                }
            } else {
                Dimension dim = this.getDimFields().get(key);
                if (dim != null) {
                    IDNumberTreeNode idNumberTreeNode = MemberReader.findMemberById((long)this._cxt.getModel(), (String)dim.getEntity(), (Long)DynUtils.getBaseId((DynamicObject)e.getRowData(), (String)dim.getFieldmapped()));
                    e.setFormatValue((Object)(idNumberTreeNode.getNumber() + " | " + idNumberTreeNode.getName()));
                }
            }
        }
    }

    public Map<String, String> getBizType() {
        if (this.bizType == null) {
            this.bizType = AdjustBusinessTypeUtil.getBizType(this._cxt.getModel());
        }
        return this.bizType;
    }
}

