/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.servicehelper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.model.export.QueryAdjustParam;
import kd.fi.bcm.business.adjust.model.export.QueryAdjustResult;
import kd.fi.bcm.business.adjust.model.export.QueryOrgRange;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.AdjustLoadTypeEnum;
import kd.fi.bcm.common.dynamicObjectModel.DataSetDynamicModel;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.dynamicObjectModel.LoadDynamicModel;
import kd.fi.bcm.common.dynamicObjectModel.LoadFromCacheDynamicModel;
import kd.fi.bcm.common.dynamicObjectModel.QueryDynamicModel;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class AdjustQueryServiceHelper {
    private static final Integer DEFAULTADJUSTLIMIT = 500;
    private static final Integer DEFAULTENTRYLIMIT = 10000;
    public static final String queryBelongOrgNumberFieldStr = new StringJoiner(" ").add("case when process.number in (" + String.join((CharSequence)",", OrgRelaProcessMembPool.getRelaProcessMembPool().stream().map(p -> "'" + p + "'").collect(Collectors.toSet())) + ")").add("then CONVERT(VARCHAR(50),adjust.entity.number) else CONVERT(VARCHAR(50),entity.number) end as queryBelongOrg").toString();
    public static final String queryBelongOrgIdFieldStr = new StringJoiner(" ").add("case when process.number in (" + String.join((CharSequence)",", OrgRelaProcessMembPool.getRelaProcessMembPool().stream().map(p -> "'" + p + "'").collect(Collectors.toSet())) + ")").add("then adjust.entity else entity end as queryBelongOrg").toString();

    public static DynamicObject loadSingle(String modelNum, String entityName, Long memeId) {
        return (DynamicObject)BcmThreadCache.get((Object)"loadSingle", (Object)entityName, (Object)memeId, () -> {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dy.set("id", (Object)memeId);
            if ("bcm_entitymembertree".equals(entityName)) {
                IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)memeId);
                dy.set("number", (Object)orgNode.getNumber());
                dy.set("longnumber", (Object)orgNode.getLongNumber());
            } else if ("bcm_scenemembertree".equals(entityName)) {
                dy.set("number", (Object)BcmThreadCache.findNodeById((String)modelNum, (String)"Scenario", (long)memeId).getNumber());
            } else if ("bcm_fymembertree".equals(entityName)) {
                dy.set("number", (Object)BcmThreadCache.findNodeById((String)modelNum, (String)"Year", (long)memeId).getNumber());
            } else if ("bcm_periodmembertree".equals(entityName)) {
                dy.set("number", (Object)BcmThreadCache.findNodeById((String)modelNum, (String)"Period", (long)memeId).getNumber());
            } else if ("bcm_audittrialmembertree".equals(entityName)) {
                dy.set("number", (Object)BcmThreadCache.findNodeById((String)modelNum, (String)"AuditTrail", (long)memeId).getNumber());
            }
            return dy;
        });
    }

    public static QueryAdjustResult queryDataForExport(QueryAdjustParam param) {
        String modelIdStr = param.getModelId() + "";
        String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
        boolean isAdmin = PermissionServiceImpl.getInstance(param.getModelId()).isAdmin();
        Long orgDimId = MemberReader.getDimensionIdByNum((long)param.getModelId(), (String)"Entity");
        SchemeContext ctx = new SchemeContext(param.getModelId());
        Dimension entityDim = ctx.getDimensionByNumber("Entity");
        QueryAdjustResult result = new QueryAdjustResult();
        QueryOrgRange orgRange = param.getOrgRange();
        ThreadPoolService.runInWaiting4AdjustChildTaskThread((IRunner[])param.getFyPeriodPairs().stream().map(fyPeriodPair -> () -> {
            IDNumberTreeNode year = MemberReader.findFyMemberById((String)modelNum, (Long)((Long)fyPeriodPair.p1));
            IDNumberTreeNode period = MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)fyPeriodPair.p2));
            String fy2PeriodKey = year.getNumber() + "_" + period.getNumber();
            try {
                Set<Long> orgScope = new HashSet<Long>(16);
                FilterOrgStructParam filterParam = new FilterOrgStructParam(param.getModelId(), param.getSceneId(), year.getNumber(), (long)period.getId());
                for (Pair<Long, Integer> pair : orgRange.getRangeItems()) {
                    if (orgRange.isCustom()) {
                        orgScope.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(entityDim.getEntity(), (Long)pair.p1, (Integer)pair.p2, modelIdStr, null));
                        continue;
                    }
                    if (((Integer)pair.p2).intValue() == RangeEnum.VALUE_10.getValue()) {
                        orgScope.add((Long)pair.p1);
                        continue;
                    }
                    Set<Long> childRange = QueryMemberDetailsHelper.queryMemberIdsByRange(entityDim.getEntity(), (Long)pair.p1, (Integer)pair.p2, modelIdStr, DetailTypeEnum.MEMBERPERM);
                    if (childRange.remove(pair.p1)) {
                        orgScope.add((Long)pair.p1);
                    }
                    orgScope.addAll(EntityVersioningUtil.filterEffectiveOrgByMergeStruct(filterParam, childRange).keySet());
                }
                if (!isAdmin) {
                    orgScope = PermissionServiceImpl.getInstance(param.getModelId()).matchReadOrWritePermMembers(orgDimId, "bcm_entitymembertree", orgScope);
                }
                HashMultimap pk2BelongOrg = HashMultimap.create();
                if (param.getAdjustIds() != null && !param.getAdjustIds().isEmpty()) {
                    Set<Long> finalOrgScope = orgScope;
                    BatchProcessHelper.batchConsume(new ArrayList<Long>(param.getAdjustIds()), (int)5000, sublist -> {
                        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(param.getModelId(), param.getSceneId(), year.getId(), period.getId(), finalOrgScope, Collections.singleton(queryBelongOrgNumberFieldStr), Collections.singletonList(new QFilter("adjust", "in", sublist)), null, false);){
                            ds.forEachRemaining(row -> pk2BelongOrg.put((Object)row.getLong("adjust"), (Object)row.getString("queryBelongOrg")));
                        }
                    });
                } else {
                    try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(param.getModelId(), param.getSceneId(), year.getId(), period.getId(), orgScope, Collections.singleton(queryBelongOrgNumberFieldStr), null, null, false);){
                        ds.forEachRemaining(row -> pk2BelongOrg.put((Object)row.getLong("adjust"), (Object)row.getString("queryBelongOrg")));
                    }
                }
                QFBuilder adjustBuilder = new QFBuilder();
                if (!isAdmin) {
                    PermClassEntityHelper.getPermissionMapBatch("bcm_rptadjust", param.getModelId() + "", RequestContext.getOrCreate().getUserId(), new ArrayList<Long>(pk2BelongOrg.keySet())).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()).forEach(x$0 -> pk2BelongOrg.removeAll(x$0));
                    adjustBuilder.add("templatecatalog", "not in", (Object)PermClassEntityHelper.getPermissionMapBatch("bcm_templatecatalog", modelIdStr, RequestContext.getOrCreate().getUserId(), new ArrayList<Long>(pk2BelongOrg.keySet())).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
                }
                adjustBuilder.add("id", "in", (Object)pk2BelongOrg.keySet());
                if (!CollectionUtil.isEmpty(param.getAdjStatus())) {
                    adjustBuilder.and("status", "in", param.getAdjStatus());
                }
                if (!param.isIncludeLink()) {
                    adjustBuilder.and("sourcetype", "!=", (Object)(ElimRptAdjSourceTypeEnum.LINK.getValue() + ""));
                }
                HashSet<String> headFieldList = new HashSet<String>(param.getHeadFields());
                headFieldList.add("id");
                AdjustQueryServiceHelper.loadDataFromDB(AdjustLoadTypeEnum.DataSetRow, "bcm_rptadjust", String.join((CharSequence)",", headFieldList), adjustBuilder.toArray(), param.getOrderBy()).forEach(adjust -> result.populate(fy2PeriodKey, pk2BelongOrg.get((Object)adjust.getLong("id")), (IDynamicObjectModel)adjust));
                QFBuilder entryBuilder = new QFBuilder("adjust", "in", result.getAdjustPkSet(fy2PeriodKey));
                if (!param.isIncludeLink()) {
                    entryBuilder.add("entrysource", "not in", (Object)EntrySourceEnum.getLinkListToString());
                }
                HashSet<String> entryFieldList = new HashSet<String>(param.getEntryFields());
                for (Dimension dim : ctx.getDimensions()) {
                    entryFieldList.add(dim.getFieldmapped() + ".id");
                    entryFieldList.add(dim.getFieldmapped() + ".number");
                    entryFieldList.add(dim.getFieldmapped() + ".name");
                }
                result.cacheEntryDataSet(fy2PeriodKey, AdjustQueryServiceHelper.queryAdjustEntryDataSet(entryFieldList, entryBuilder, "showseq asc,groupnum asc,dseq asc", -1));
            }
            catch (Throwable t) {
                result.populateErrorLog(fy2PeriodKey, AdjustmentServiceHelper.toString_Adj(t));
            }
        }).toArray(IRunner[]::new));
        return result;
    }

    public static Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>> loadAdjustDataFromDB(List pkids, AdjustOperQueryParam param) {
        List<IDynamicObjectModel> adjustDys = AdjustQueryServiceHelper.loadDataFromDB(param.getAdjustLoadType(), "bcm_rptadjust", param.getAdjustFieldStr(), new QFilter("id", "in", (Object)pkids).toArray(), null);
        List<IDynamicObjectModel> adjustEntryDys = AdjustQueryServiceHelper.loadDataFromDB(param.getEntryLoadType(), "bcm_rptadjustdata", param.getEntryFieldStr(), new QFilter("adjust", "in", (Object)pkids).toArray(), null);
        Map<Long, List<IDynamicObjectModel>> adjustEntryMap = adjustEntryDys.parallelStream().collect(Collectors.groupingBy(p -> p.getBaseDataId("adjust")));
        return Pair.onePair(adjustDys, adjustEntryMap);
    }

    public static List<IDynamicObjectModel> loadDataFromDB(AdjustLoadTypeEnum loadType, String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        String algoKey = GlobalIdUtil.genStringId();
        switch (loadType) {
            case DataSetRow: {
                ArrayList<IDynamicObjectModel> resultList = new ArrayList<IDynamicObjectModel>(16);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"loadDataFromDB", (String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy);){
                    ds.forEachRemaining(row -> resultList.add((IDynamicObjectModel)new DataSetDynamicModel(row)));
                }
                return resultList;
            }
            case LoadNoFields: {
                Object[] pkIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, (String)orderBy, (int)-1).stream().toArray(Object[]::new);
                return Arrays.stream(BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType())).map(dy -> new LoadDynamicModel(algoKey, dy)).collect(Collectors.toList());
            }
            case LoadWithFields: {
                return Arrays.stream(BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy)).map(dy -> new LoadDynamicModel(algoKey, dy)).collect(Collectors.toList());
            }
            case LoadFromCache: {
                return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy).values().stream().map(dy -> new LoadFromCacheDynamicModel(algoKey, dy)).collect(Collectors.toList());
            }
            case Query: {
                return QueryServiceHelper.query((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBy).stream().map(dy -> new QueryDynamicModel(algoKey, dy)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<List<Long>> batchHandlerAdjustDataList(List<Long> pkids, boolean forceBatch) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        if (forceBatch && !pkids.isEmpty()) {
            Integer defaultAdjustLimit = Integer.getInteger("bcm.AdjustQueryServiceHelper.groupDynamicList.defaultAdjustLimit", DEFAULTADJUSTLIMIT);
            Integer defaultEntryLimit = Integer.getInteger("bcm.AdjustQueryServiceHelper.groupDynamicList.defaultEntryLimit", DEFAULTENTRYLIMIT);
            CharSequence[] succids = (String[])pkids.stream().map(Object::toString).distinct().toArray(String[]::new);
            String sql = String.format("SELECT fadjustid,count(fadjustid) as count from t_bcm_rptadjustdata where fadjustid in (%s) group by fadjustid", String.join((CharSequence)",", succids));
            ArrayList tempGroupList = new ArrayList();
            AtomicInteger tempGroupEntrySize = new AtomicInteger();
            try (DataSet ds = DB.queryDataSet((String)"groupDynamicList", (DBRoute)BCMConstant.DBROUTE, (String)sql);){
                int adjustIndex = ds.getRowMeta().getFieldIndex("fadjustid");
                int countIndex = ds.getRowMeta().getFieldIndex("count");
                ds.forEachRemaining(p -> {
                    int entrySize = p.getInteger(countIndex);
                    if (tempGroupList.size() == defaultAdjustLimit.intValue() || !tempGroupList.isEmpty() && tempGroupEntrySize.get() + entrySize > defaultEntryLimit) {
                        result.add(new ArrayList(tempGroupList));
                        tempGroupList.clear();
                        tempGroupEntrySize.set(0);
                    }
                    tempGroupList.add(p.getLong(adjustIndex));
                    tempGroupEntrySize.addAndGet(entrySize);
                });
                if (tempGroupList.isEmpty()) return result;
                result.add(tempGroupList);
                return result;
            }
        } else {
            result.add(pkids);
        }
        return result;
    }

    @Deprecated
    public static Set<Long> queryAdjustIds(long model, long scene, long year, long period, Set<Long> belongOrgSet, List<QFilter> otherList) {
        return AdjustQueryServiceHelper.queryAdjustIds(model, scene, year, period, belongOrgSet, otherList, null, false);
    }

    @Deprecated
    public static Set<Long> queryAdjustIds(long model, long scene, long year, long period, Set<Long> belongOrgSet, List<QFilter> otherList, String order, boolean hasQuoteScene) {
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(model, scene, year, period, belongOrgSet, null, otherList, order, hasQuoteScene);){
            int adjustIndex = ds.getRowMeta().getFieldIndex("adjust");
            LinkedHashSet<Long> resultSet = new LinkedHashSet<Long>(16);
            ds.forEachRemaining(p -> resultSet.add(p.getLong(adjustIndex)));
            LinkedHashSet<Long> linkedHashSet = resultSet;
            return linkedHashSet;
        }
    }

    @Deprecated
    public static Set<String> queryAdjustExistOrgSet(long model, long scene, long year, long period, Set<Long> belongOrgSet, List<QFilter> otherList) {
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(model, scene, year, period, belongOrgSet, Collections.singleton(queryBelongOrgNumberFieldStr), otherList, null, true);){
            HashSet<String> existOrgSet = new HashSet<String>(16);
            ds.forEachRemaining(row -> existOrgSet.add(row.getString("queryBelongOrg")));
            HashSet<String> hashSet = existOrgSet;
            return hashSet;
        }
    }

    @Deprecated
    @SDKMark
    public static Map<Long, Set<Object>> queryAdjustIdsGroupByBelongOrg(long model, long scene, long year, long period, Set<Long> belongOrgSet, List<QFilter> otherList) {
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(model, scene, year, period, belongOrgSet, Collections.singleton(queryBelongOrgIdFieldStr), otherList, null, false);){
            HashMap<Long, Set<Object>> resultMap = new HashMap<Long, Set<Object>>(16);
            ds.forEachRemaining(row -> resultMap.computeIfAbsent(row.getLong("queryBelongOrg"), a -> Sets.newHashSet()).add(row.getLong("adjust")));
            HashMap<Long, Set<Object>> hashMap = resultMap;
            return hashMap;
        }
    }

    public static DataSet queryAdjustEntryByBelongOrg(long modelId, long scenarioId, long yearId, long periodId, Set<Long> belongOrgSet, Set<String> selectFields, List<QFilter> otherList, String orderBy, boolean hasQuoteScene) {
        QFBuilder qf = AdjustQueryServiceHelper.buildBelongOrgQFilterForQuery(modelId, scenarioId, yearId, periodId, belongOrgSet, hasQuoteScene, false);
        qf.add("isdefaultcurrency", "=", (Object)"1");
        if (otherList != null && !otherList.isEmpty()) {
            qf.add(otherList);
        }
        return AdjustQueryServiceHelper.queryAdjustEntryDataSet(selectFields, qf, orderBy, -1);
    }

    public static Set<Long> queryAdjustIdsFast(long modelId, long sceneId, long yearId, long periodId, Set<Long> belongOrgSet, List<QFilter> otherList, String order) {
        if (AdjustQueryServiceHelper.isUseNewRefreshType(modelId, yearId)) {
            QFBuilder qfBuilder = AdjustQueryServiceHelper.buildBelongOrgQFilterForQuery(modelId, sceneId, yearId, periodId, belongOrgSet, false, true);
            if (otherList != null) {
                qfBuilder.add(otherList);
            }
            try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(Collections.singleton("id"), qfBuilder, null, -1);){
                LinkedHashSet<Long> resultSet = new LinkedHashSet<Long>(16);
                ds.forEachRemaining(p -> resultSet.add(p.getLong("id")));
                LinkedHashSet<Long> linkedHashSet = resultSet;
                return linkedHashSet;
            }
        }
        if (otherList != null) {
            otherList.forEach(qf -> qf.__setProperty("adjust." + qf.getProperty()));
        }
        return AdjustQueryServiceHelper.queryAdjustIds(modelId, sceneId, yearId, periodId, belongOrgSet, otherList, order, false);
    }

    public static Map<Long, Set<Object>> queryAdjustIdsGroupByBelongOrgFast(long modelId, long sceneId, long yearId, long periodId, Set<Long> belongOrgSet, List<QFilter> otherList) {
        if (AdjustQueryServiceHelper.isUseNewRefreshType(modelId, yearId)) {
            HashMap<Long, Set<Object>> resultMap = new HashMap<Long, Set<Object>>(16);
            QFBuilder qfBuilder = AdjustQueryServiceHelper.buildBelongOrgQFilterForQuery(modelId, sceneId, yearId, periodId, belongOrgSet, false, true);
            if (otherList != null) {
                qfBuilder.add(otherList);
            }
            HashSet<String> selectFields = new HashSet<String>(2);
            selectFields.add("id");
            selectFields.add("belongorglist.belongorgmem as belongorg");
            try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(selectFields, qfBuilder, null, -1);){
                ds.forEachRemaining(row -> resultMap.computeIfAbsent(row.getLong("belongorg"), a -> Sets.newHashSet()).add(row.getLong("id")));
            }
            return resultMap;
        }
        if (otherList != null) {
            otherList.forEach(qf -> qf.__setProperty("adjust." + qf.getProperty()));
        }
        return AdjustQueryServiceHelper.queryAdjustIdsGroupByBelongOrg(modelId, sceneId, yearId, periodId, belongOrgSet, otherList);
    }

    public static QFBuilder buildBelongOrgQFilterForQuery(long modelId, long scenarioId, long yearId, long periodId, Set<Long> belongOrgSet, boolean hasQuoteScene, boolean isUseNewRefreshType) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        if (belongOrgSet != null) {
            Set<IDNumberTreeNode> belongOrgNumSet = belongOrgSet.stream().map(p -> BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)p)).collect(Collectors.toSet());
            if (hasQuoteScene && MergeControlHelper.isQuoteScene(modelId, scenarioId)) {
                long srcScene = MergeControlHelper.getSrcScene(modelId, scenarioId);
                Set<String> allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs(modelId, scenarioId, yearId, periodId);
                Map<Boolean, List<IDNumberTreeNode>> ver2OrgNums = belongOrgNumSet.stream().collect(Collectors.groupingBy(p -> allVersionedOrgs.contains(p.getNumber())));
                List<IDNumberTreeNode> noVersionedOrgs = ver2OrgNums.get(Boolean.FALSE);
                List<IDNumberTreeNode> versionedOrgs = ver2OrgNums.get(Boolean.TRUE);
                if (CollectionUtil.isEmpty(noVersionedOrgs)) {
                    qf.add("scenario", "=", (Object)scenarioId);
                    qf.add("year", "=", (Object)yearId);
                    qf.add("period", "=", (Object)periodId);
                    qf.add(AdjustQueryServiceHelper.buildBelongOrgQFilter(versionedOrgs, isUseNewRefreshType));
                } else if (CollectionUtil.isEmpty(versionedOrgs)) {
                    qf.add("scenario", "=", (Object)srcScene);
                    qf.add("year", "=", (Object)yearId);
                    qf.add("period", "=", (Object)periodId);
                    qf.add(AdjustQueryServiceHelper.buildBelongOrgQFilter(noVersionedOrgs, isUseNewRefreshType));
                } else {
                    qf.add("year", "=", (Object)yearId);
                    qf.add("period", "=", (Object)periodId);
                    QFilter noVersionedQf = new QFilter("scenario", "=", (Object)srcScene).and(AdjustQueryServiceHelper.buildBelongOrgQFilter(noVersionedOrgs, isUseNewRefreshType));
                    QFilter versionedQf = new QFilter("scenario", "=", (Object)scenarioId).and(AdjustQueryServiceHelper.buildBelongOrgQFilter(versionedOrgs, isUseNewRefreshType));
                    qf.add(noVersionedQf.or(versionedQf));
                }
            } else {
                qf.add("scenario", "=", (Object)scenarioId);
                qf.add("year", "=", (Object)yearId);
                qf.add("period", "=", (Object)periodId);
                qf.add(AdjustQueryServiceHelper.buildBelongOrgQFilter(belongOrgNumSet, isUseNewRefreshType));
            }
        } else {
            qf.add("scenario", "=", (Object)scenarioId);
            qf.add("year", "=", (Object)yearId);
            qf.add("period", "=", (Object)periodId);
        }
        return qf;
    }

    public static boolean isUseNewRefreshType(long modelId, long yearId) {
        return false;
    }

    private static QFilter buildBelongOrgQFilter(Collection<IDNumberTreeNode> belongOrgNumSet, boolean isUseNewRefreshType) {
        if (belongOrgNumSet == null) {
            return new QFilter("1", "=", (Object)1);
        }
        if (isUseNewRefreshType) {
            return new QFilter("belongorglist.belongorgmem.number", "in", belongOrgNumSet.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet()));
        }
        HashSet<String> olapOrgSet = new HashSet<String>(belongOrgNumSet.size());
        for (IDNumberTreeNode orgNode : belongOrgNumSet) {
            olapOrgSet.add(orgNode.getNumber());
            orgNode.getChildren().forEach(childNode -> olapOrgSet.add(childNode.getParent_SonNumber()));
        }
        return new QFilter("olaporg", "in", olapOrgSet);
    }

    public static DataSet queryAdjustElimDataSet(Collection<String> selectFields, QFBuilder qf, String orderBys, int top) {
        HashSet<String> fields = new HashSet<String>(3);
        fields.add("id");
        if (selectFields != null) {
            fields.addAll(selectFields);
        }
        return QueryServiceHelper.queryDataSet((String)"queryAdjustElimDataSet", (String)"bcm_rptadjust", (String)String.join((CharSequence)",", fields), (QFilter[])qf.toArray(), (String)orderBys, (int)top);
    }

    public static DataSet queryAdjustEntryDataSet(Set<String> selectFields, QFBuilder qf, String orderBys, int top) {
        HashSet<String> fields = new HashSet<String>(3);
        fields.add("id");
        fields.add("adjust");
        if (selectFields != null) {
            fields.addAll(selectFields);
        }
        return QueryServiceHelper.queryDataSet((String)"queryAdjustEntryFastDataSet", (String)"bcm_rptadjustdata", (String)String.join((CharSequence)",", fields), (QFilter[])qf.toArray(), (String)orderBys, (int)top);
    }
}

