/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.IBatchOperationTask;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;

public abstract class AbstractBatchNewOperationTask
implements IBatchOperationTask {
    private final AtomicInteger successCount = new AtomicInteger(0);
    private GlobalIdDistributer idDistributor;
    private AdjRecordLog log = new AdjRecordLog();
    private AdjustOperationContext _ctx;
    private AdjustOperTypeEnum operTypeEnum;
    private Map<String, Object> userDefineParam;
    private List<Long> pkIds;
    private final AdjustOperQueryParam queryParam = new AdjustOperQueryParam(Boolean.FALSE, 0);
    private AdjustValidatorExecute<Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>>> validatorExecute;

    @Override
    public void doJob() {
        this.validatorExecute = new AdjustValidatorExecute(this._ctx());
        this.validatorExecute.setAdjLog(this.getRecordLog());
        try {
            this.beforeDispose();
            this.onAddValidators(this.validatorExecute);
            this.onPrepareQueryParam(this.queryParam.setModelId(this._ctx().getModelId()));
            Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>> adjustDataPair = AdjustQueryServiceHelper.loadAdjustDataFromDB(this.getPkIds(), this.queryParam);
            this.beforeValidatorData((List)adjustDataPair.p1, (Map)adjustDataPair.p2);
            this.validatorExecute.excute(adjustDataPair);
            this.afterValidatorData((List)adjustDataPair.p1, (Map)adjustDataPair.p2);
            this.dispose((List)adjustDataPair.p1, (Map)adjustDataPair.p2);
        }
        catch (Throwable t) {
            this.getRecordLog().addErrorMsg(AdjustmentServiceHelper.toString_Adj(t));
            this.getRecordLog().getSuccessConut().addAndGet(this.successCount.get() * -1);
        }
    }

    void beforeValidatorData(List<IDynamicObjectModel> adjustDys, Map<Long, List<IDynamicObjectModel>> adjustDatas) {
    }

    void onAddValidators(AdjustValidatorExecute e) {
    }

    void beforeDispose() {
    }

    void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
    }

    void afterValidatorData(List<IDynamicObjectModel> adjustDys, Map<Long, List<IDynamicObjectModel>> adjustDatas) {
    }

    abstract void dispose(List<IDynamicObjectModel> var1, Map<Long, List<IDynamicObjectModel>> var2);

    void addErrorOper(long pkId, String msg) {
        this.getRecordLog().addErrorMsg(pkId, msg);
    }

    protected void addWarnOper(long pkId, String msg) {
        this.getRecordLog().addWarningMsg(pkId, msg);
    }

    protected void addSuccessCount() {
        this.successCount.incrementAndGet();
        this.getRecordLog().addSuccessCount();
    }

    public List<Long> getPkIds() {
        return this.pkIds;
    }

    public AdjRecordLog getRecordLog() {
        return this.log;
    }

    @Override
    public void setLog(AdjRecordLog log) {
        this.log = log;
    }

    public AdjustOperationContext _ctx() {
        return this._ctx;
    }

    @Override
    public void set_ctx(AdjustOperationContext _ctx) {
        this._ctx = _ctx;
    }

    @Override
    public void setPkIds(List<Long> pkIds) {
        this.pkIds = pkIds;
    }

    @Override
    public void setUserDefineParam(Map<String, Object> userDefineParam) {
        this.userDefineParam = userDefineParam;
    }

    <T> T getUserDefineParam(String key) {
        return this.getUserDefineParam(key, null);
    }

    <T> T getUserDefineParam(String key, T defaultVal) {
        return (T)(this.userDefineParam == null ? defaultVal : this.userDefineParam.get(key));
    }

    public AdjustOperQueryParam getQueryParam() {
        return this.queryParam;
    }

    public GlobalIdDistributer getIdDistributor() {
        if (this.idDistributor == null) {
            this.idDistributor = new GlobalIdDistributer(Math.max(this.getPkIds().size(), 20), 1);
        }
        return this.idDistributor;
    }

    @Override
    public void setAdjustOperTypeEnum(AdjustOperTypeEnum operTypeEnum) {
        this.operTypeEnum = operTypeEnum;
    }

    public AdjustOperTypeEnum getOperTypeEnum() {
        return this.operTypeEnum;
    }
}

