/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.model.GlobalNumberDistributer;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.IBatchOperationTask;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;

abstract class AbstractBatchOperationTask
implements IBatchOperationTask {
    private final AtomicInteger successCount = new AtomicInteger(0);
    private final GlobalIdDistributer idDistributor = new GlobalIdDistributer(20, 10);
    private static final GlobalNumberDistributer numberDistributor = new GlobalNumberDistributer("bcm_rptadjust", "createtime");
    private AdjRecordLog log = new AdjRecordLog();
    private AdjustOperationContext _ctx;
    private AdjustOperTypeEnum operTypeEnum;
    private Map<String, Object> userDefineParam;
    private List<Long> pkIds;
    private final AdjustOperQueryParam queryParam = new AdjustOperQueryParam(Boolean.FALSE, 0);
    private AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> validatorExecute;

    AbstractBatchOperationTask() {
    }

    @Override
    public void doJob() {
        this.validatorExecute = new AdjustValidatorExecute(this._ctx());
        this.validatorExecute.setAdjLog(this.getRecordLog());
        try {
            this.beforeDispose();
            this.onAddValidators(this.validatorExecute);
            this.onPrepareQueryParam(this.queryParam.setModelId(this._ctx().getModelId()));
            AdjustOperationThreadHelper.groupAdjustList(this.getPkIds(), this.queryParam, (adjustDys, adjustDatas) -> {
                this.beforeValidatorData(adjustDys, adjustDatas);
                this.validatorExecute.excute((Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>)Pair.onePair((Object)adjustDys, (Object)adjustDatas));
                this.afterValidatorData(adjustDys, adjustDatas);
                this.dispose(adjustDys, adjustDatas);
            });
        }
        catch (Throwable t) {
            this.getRecordLog().addErrorMsg(AdjustmentServiceHelper.toString_Adj(t));
            this.getRecordLog().getSuccessConut().addAndGet(this.successCount.get() * -1);
        }
    }

    void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
    }

    void onAddValidators(AdjustValidatorExecute e) {
        e.addValidator(new AbstractValidator(){

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                if (CollectionUtil.isEmpty(adjustDataList)) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBatchOperationTask_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            }
        });
    }

    void beforeDispose() {
    }

    void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
    }

    void afterValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
    }

    abstract void dispose(List<DynamicObject> var1, Map<Long, List<DynamicObject>> var2);

    void addErrorOper(String msg) {
        this.getRecordLog().addErrorMsg(msg);
    }

    protected void addWarnOper(String msg) {
        this.getRecordLog().addWarningMsg(msg);
    }

    protected void addSuccessCount() {
        this.successCount.incrementAndGet();
        this.getRecordLog().addSuccessCount();
    }

    public List<Long> getPkIds() {
        return this.pkIds;
    }

    public AdjRecordLog getRecordLog() {
        return this.log;
    }

    @Override
    public void setLog(AdjRecordLog log) {
        this.log = log;
    }

    public AdjustOperationContext _ctx() {
        return this._ctx;
    }

    @Override
    public void set_ctx(AdjustOperationContext _ctx) {
        this._ctx = _ctx;
    }

    @Override
    public void setPkIds(List<Long> pkIds) {
        this.pkIds = pkIds;
    }

    @Override
    public void setUserDefineParam(Map<String, Object> userDefineParam) {
        this.userDefineParam = userDefineParam;
    }

    <T> T getUserDefineParam(String key) {
        return (T)(this.userDefineParam == null ? null : this.userDefineParam.get(key));
    }

    public AdjustOperQueryParam getQueryParam() {
        return this.queryParam;
    }

    public GlobalIdDistributer getIdDistributor() {
        return this.idDistributor;
    }

    public static GlobalNumberDistributer getNumberDistributor() {
        return numberDistributor;
    }

    @Override
    public void setAdjustOperTypeEnum(AdjustOperTypeEnum operTypeEnum) {
        this.operTypeEnum = operTypeEnum;
    }

    public AdjustOperTypeEnum getOperTypeEnum() {
        return this.operTypeEnum;
    }
}

