/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.convert.AdjustRateDiffCreateService;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AbstractBatchOperationTask;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;

abstract class AbstractShareEntryTask
extends AbstractBatchOperationTask {
    private AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> tarValidator;
    private AdjustConvertService adjConvert;
    private AdjustRateDiffCreateService ardiffor;
    private Table<Long, String, Long> oldShareEntryTable;
    private List<Object[]> insertRelationParamList = new ArrayList<Object[]>();

    AbstractShareEntryTask() {
    }

    @Override
    void beforeValidatorData(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDatas) {
        super.beforeValidatorData(adjustDys, adjustDatas);
        this.oldShareEntryTable = this.findOldShareEntryIds(adjustDys);
    }

    @Override
    protected void beforeDispose() {
        super.beforeDispose();
        this.adjConvert = new AdjustConvertService(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId());
        this.ardiffor = new AdjustRateDiffCreateService(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId());
        this.ardiffor.setFromDataBase(true);
    }

    @Override
    void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
    }

    protected void onTarAddValidators(AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> tarValidator) {
    }

    protected Pair<DynamicObject, List<DynamicObject>> shareEntry(DynamicObject adjust, List<DynamicObject> adjustDatas, IDNumberTreeNode comParentNode) {
        if (comParentNode == null || comParentNode == IDNumberTreeNode.NotFoundTreeNode || CollectionUtil.isEmpty(adjustDatas)) {
            return null;
        }
        Pair<DynamicObject, List<DynamicObject>> resultPair = adjust.getBoolean("multiplecurrency") || adjust.get("cvtbeforecurrency") instanceof DynamicObject ? this.shareMultiEntry(adjust, adjustDatas, comParentNode) : (OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process")) ? this.shareOrgRelaEntry(adjust, adjustDatas, comParentNode) : this.shareSingleEntry(adjust, adjustDatas, comParentNode));
        return resultPair;
    }

    private Pair<DynamicObject, List<DynamicObject>> shareOrgRelaEntry(DynamicObject oldAdjust, List<DynamicObject> adjustDatas, IDNumberTreeNode comParentNode) {
        DynamicObject adjustClone = AdjustOperationHelper.copyDynamicObject(oldAdjust, true);
        this.initCloneAdjust(oldAdjust, adjustClone);
        DynamicObject mergeDy = AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", comParentNode.getId());
        adjustClone.set("belongorg", (Object)mergeDy);
        adjustClone.set("entity", (Object)mergeDy);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(adjustDatas.size());
        boolean isLinkPage = ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equalsIgnoreCase(oldAdjust.getString("entrysource"));
        for (DynamicObject adjustData : adjustDatas) {
            DynamicObject adjustDataClone = AdjustOperationHelper.copyDynamicObject(adjustData, true);
            adjustDataClone.set("adjust", (Object)adjustClone);
            adjustDataClone.set("merge", (Object)mergeDy);
            adjustDataClone.set("isdefaultcurrency", (Object)"1");
            IDNumberTreeNode newDetailOrgNode = InvestServiceHelper.queryEffectiveOrgNode(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId(), comParentNode.getId(), adjustDataClone.getString("entity.number"));
            adjustDataClone.set("entity", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", newDetailOrgNode.getId()));
            if (isLinkPage) {
                adjustDataClone.set("entrysource", (Object)3);
            }
            this.transformMyCompanyVar(oldAdjust, newDetailOrgNode.getId(), adjustDataClone);
            AdjustOperationHelper.fillAdjustDataOfOlapOrg(this._ctx().getModelNum(), adjustDataClone, true);
            resultList.add(adjustDataClone);
        }
        return Pair.onePair((Object)adjustClone, resultList);
    }

    private Pair<DynamicObject, List<DynamicObject>> shareMultiEntry(DynamicObject oldAdjust, List<DynamicObject> adjustDatas, IDNumberTreeNode comParentNode) {
        DynamicObject adjustClone = AdjustOperationHelper.copyDynamicObject(oldAdjust, true);
        this.initCloneAdjust(oldAdjust, adjustClone);
        DynamicObject mergeDy = AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", comParentNode.getId());
        adjustClone.set("belongorg", (Object)mergeDy);
        adjustClone.set("entity", (Object)mergeDy);
        adjustClone.set("multiplecurrency", (Object)"0");
        IDNumberTreeNode tarCurrencyNode = MemberReader.findCurrencyMemberByNum((String)this._ctx().getModelNum(), (String)comParentNode.getCurrency());
        adjustClone.getDynamicObjectCollection("commembentry").forEach(c -> {
            if ("Currency".equals(c.getDynamicObject("comdimension").getString("number"))) {
                c.set("commembid", (Object)tarCurrencyNode.getId());
                return;
            }
        });
        DynamicObject tarCurrency = AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_currencymembertree", MemberReader.findCurrencyMemberByNum((String)this._ctx().getModelNum(), (String)comParentNode.getCurrency()).getId());
        tarCurrency.set("number", (Object)tarCurrencyNode.getNumber());
        DynamicObject adjustDataClone = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        HashMap<String, DynamicObject> needConvertEntrys = new HashMap<String, DynamicObject>(16);
        boolean isLinkPage = ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equalsIgnoreCase(oldAdjust.getString("entrysource"));
        for (DynamicObject adjustData : adjustDatas) {
            adjustDataClone = null;
            String entryRowType = adjustData.getString("entryrowtype");
            if ("2".equals(entryRowType) || "1".equals(entryRowType)) continue;
            String specKey = adjustData.getString("groupnum") + "_" + adjustData.getString("dseq");
            if (StringUtil.equals((String)adjustData.getString("currency.number"), (String)comParentNode.getCurrency())) {
                adjustDataClone = AdjustOperationHelper.copyDynamicObject(adjustData, true);
                resultMap.put(specKey, adjustDataClone);
            } else if (adjustData.getBoolean("isdefaultcurrency")) {
                adjustDataClone = AdjustOperationHelper.copyDynamicObject(adjustData, true);
                adjustDataClone.set("debit", (Object)BigDecimal.ZERO);
                adjustDataClone.set("credit", (Object)BigDecimal.ZERO);
                adjustDataClone.set("summoney", (Object)BigDecimal.ZERO);
                adjustDataClone.set("rate", (Object)BigDecimal.ZERO);
                adjustDataClone.set("currency", (Object)tarCurrency);
                needConvertEntrys.put(specKey, adjustDataClone);
            }
            if (adjustDataClone == null) continue;
            adjustDataClone.set("isdefaultcurrency", (Object)"1");
            adjustDataClone.set("adjust", (Object)adjustClone);
            adjustDataClone.set("merge", (Object)mergeDy);
            IDNumberTreeNode newDetailNode = InvestServiceHelper.queryEffectiveOrgNode(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId(), comParentNode.getId(), adjustDataClone.getString("entity.number"));
            adjustDataClone.set("entity", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", newDetailNode.getId()));
            if (isLinkPage) {
                adjustDataClone.set("entrysource", (Object)3);
            }
            this.transformMyCompanyVar(oldAdjust, newDetailNode.getId(), adjustDataClone);
            AdjustOperationHelper.fillAdjustDataOfOlapOrg(this._ctx().getModelNum(), adjustDataClone, true);
        }
        needConvertEntrys.keySet().removeAll(resultMap.keySet());
        this.adjConvert.batchConvert(needConvertEntrys.values());
        resultMap.putAll(needConvertEntrys);
        return Pair.onePair((Object)adjustClone, this.ardiffor.createRateDiffSingleElim(new ArrayList<DynamicObject>(resultMap.values()), true));
    }

    private Pair<DynamicObject, List<DynamicObject>> shareSingleEntry(DynamicObject oldAdjust, List<DynamicObject> adjustDatas, IDNumberTreeNode comParentNode) {
        DynamicObject adjustClone = AdjustOperationHelper.copyDynamicObject(oldAdjust, true);
        this.initCloneAdjust(oldAdjust, adjustClone);
        DynamicObject detailOrg = AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", comParentNode.getId());
        adjustClone.set("belongorg", (Object)detailOrg);
        adjustClone.set("entity", (Object)detailOrg);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(adjustDatas.size());
        boolean isLinkPage = ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equalsIgnoreCase(oldAdjust.getString("entrysource"));
        for (DynamicObject adjustData : adjustDatas) {
            DynamicObject adjustDataClone = AdjustOperationHelper.copyDynamicObject(adjustData, true);
            adjustDataClone.set("adjust", (Object)adjustClone);
            adjustDataClone.set("merge", (Object)detailOrg);
            adjustDataClone.set("isdefaultcurrency", (Object)"1");
            adjustDataClone.set("entity", (Object)detailOrg);
            if (isLinkPage) {
                adjustDataClone.set("entrysource", (Object)3);
            }
            this.transformMyCompanyVar(oldAdjust, comParentNode.getId(), adjustDataClone);
            AdjustOperationHelper.fillAdjustDataOfOlapOrg(this._ctx().getModelNum(), adjustDataClone, false);
            resultList.add(adjustDataClone);
        }
        return Pair.onePair((Object)adjustClone, resultList);
    }

    protected Map<IDNumberTreeNode, List<DynamicObject>> resolveCommonParentNode(DynamicObject adjust, List<DynamicObject> adjustEntryList, IDNumberTreeNode mergeOrgNode) {
        HashMap<IDNumberTreeNode, List<DynamicObject>> cpMap = new HashMap<IDNumberTreeNode, List<DynamicObject>>();
        if (!CollectionUtil.isEmpty(adjustEntryList)) {
            Map<String, List<DynamicObject>> groupByGroupNum = adjustEntryList.stream().collect(Collectors.groupingBy(p -> p.getString("groupnum")));
            groupByGroupNum.forEach((groupNum, entrys) -> {
                try {
                    IDNumberTreeNode commonParentNode = AdjustOperationHelper.resolveCommonParentNode(this._ctx(), entrys, mergeOrgNode);
                    if (commonParentNode != IDNumberTreeNode.NotFoundTreeNode && (StringUtil.equals((String)mergeOrgNode.getNumber(), (String)commonParentNode.getNumber()) || commonParentNode.getLongNumber().startsWith(mergeOrgNode.getLongNumber() + "!"))) {
                        if (!(StringUtil.equals((String)mergeOrgNode.getCurrency(), (String)commonParentNode.getCurrency()) || adjust.getBoolean("multiplecurrency") || adjust.get("cvtbeforecurrency") instanceof DynamicObject)) {
                            this.addWarnOper(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55%1$s\uff08%2$s\uff09\u5206\u7ec4%3$s\u6700\u5c0f\u5171\u540c\u7236\u7ea7\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u4e3a \uff1a%4$s", (String)"AbstractShareEntryTask_4", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), adjust.getString("name"), groupNum, ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u6700\u5c0f\u5171\u540c\u7236\u7ea7\u548c\u6e90\u5206\u5f55\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u5171\u4eab\u3002", (String)"AbstractShareEntryTask_12", (String)"fi-bcm-business", (Object[])new Object[0])));
                            return;
                        }
                        cpMap.computeIfAbsent(commonParentNode, a -> Lists.newArrayList()).addAll(entrys);
                    }
                }
                catch (Throwable t) {
                    this.addWarnOper(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55%1$s\uff08%2$s\uff09\u5206\u7ec4%3$s\u6700\u5c0f\u5171\u540c\u7236\u7ea7\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u4e3a \uff1a%4$s", (String)"AbstractShareEntryTask_4", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), adjust.getString("name"), groupNum, AdjustmentServiceHelper.toString_Adj(t)));
                    cpMap.computeIfAbsent(IDNumberTreeNode.NotFoundTreeNode, a -> Lists.newArrayList()).addAll(entrys);
                }
            });
        }
        return cpMap;
    }

    protected Table<Long, String, Long> findOldShareEntryIds(List<DynamicObject> adjustDys) {
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject adjust : adjustDys) {
            DynamicObjectCollection shareentrys = adjust.getDynamicObjectCollection("shareentry");
            if (CollectionUtil.isEmpty((Collection)shareentrys)) continue;
            for (DynamicObject shareentry : shareentrys) {
                IDNumberTreeNode shareOrgNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)DynUtils.getBaseId((DynamicObject)shareentry, (String)"shareorg"));
                long shareadjust = DynUtils.getBaseId((DynamicObject)shareentry, (String)"shareadjust");
                if (shareadjust == 0L || shareOrgNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                table.put((Object)adjust.getLong("id"), (Object)shareOrgNode.getNumber(), (Object)shareadjust);
            }
        }
        return table;
    }

    protected void prepareInsertShareRelation(DynamicObject srcAdjust, DynamicObject tarAdjust) {
        long srcId = srcAdjust.getLong("id");
        long tarId = tarAdjust.getLong("id");
        this.insertRelationParamList.add(new Object[]{this.getIdDistributor().getLongId(), srcId, DynUtils.getBaseId((DynamicObject)tarAdjust, (String)"entity"), tarId});
        this.insertRelationParamList.add(new Object[]{this.getIdDistributor().getLongId(), tarId, DynUtils.getBaseId((DynamicObject)srcAdjust, (String)"entity"), srcId});
    }

    protected void batchUpdateNewShareRelation() {
        if (!CollectionUtil.isEmpty(this.insertRelationParamList)) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)"INSERT t_bcm_adjustshareentry (FEntryID,FID,FSHAREORGID,FSHAREADJUSTID) VALUES (?,?,?,?)", this.insertRelationParamList);
        }
        BusinessDataWriter.clearDataEntityCache((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectCollection("shareentry").getDynamicObjectType());
    }

    protected void batchDeleteOldShareRelation(List<Long> deleteRelationIdList) {
        if (!CollectionUtil.isEmpty(deleteRelationIdList)) {
            CharSequence[] succids = (String[])deleteRelationIdList.stream().map(Object::toString).distinct().toArray(String[]::new);
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)("DELETE FROM t_bcm_adjustshareentry WHERE FSHAREADJUSTID IN (" + String.join((CharSequence)",", succids) + ")"));
            AdjustCheckServiceHelper.doSysToMddSameProcess(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId(), deleteRelationIdList, false);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"), (Object[])deleteRelationIdList.toArray());
            DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])new QFBuilder("adjust", "in", deleteRelationIdList).toArray());
        }
        BusinessDataWriter.clearDataEntityCache((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectCollection("shareentry").getDynamicObjectType());
    }

    protected void initCloneAdjust(DynamicObject oldAdjust, DynamicObject adjustClone) {
        adjustClone.set("id", (Object)this.getIdDistributor().getLongId());
        adjustClone.set("spreadjson", (Object)" ");
        adjustClone.set("data", (Object)" ");
        adjustClone.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        adjustClone.set("creator", (Object)this._ctx().getUser());
        adjustClone.set("createtime", (Object)this._ctx().getNowTime());
        adjustClone.set("modifier", (Object)this._ctx().getUser());
        adjustClone.set("modifytime", (Object)this._ctx().getNowTime());
        adjustClone.set("linkagelinksource", (Object)0L);
        adjustClone.set("multiplecurrency", (Object)"0");
        adjustClone.set("extendfrom", (Object)oldAdjust.getString("number"));
        adjustClone.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.SHARE.getValue());
        adjustClone.set("entrysource", (Object)"1");
        adjustClone.set("allshareorg", (Object)oldAdjust.getString("entity.number"));
        adjustClone.getDynamicObjectCollection("shareentry").clear();
    }

    protected void updateAllShareOrg(List<DynamicObject> oldAdjustHeaders) {
        CharSequence[] succids = new String[oldAdjustHeaders.size()];
        for (int i = 0; i < oldAdjustHeaders.size(); ++i) {
            succids[i] = oldAdjustHeaders.get(i).getString("id");
        }
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)("DELETE t_bcm_adjustshareentry WHERE fid IN (" + String.join((CharSequence)",", succids) + ") and FSHAREADJUSTID NOT IN (SELECT FID FROM T_BCM_RPTADJUST)"));
        HashSet shareOrgSet = new HashSet(16);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try (DataSet ds = DB.queryDataSet((String)"updateAllShareOrg", (DBRoute)BCMConstant.DBROUTE, (String)("SELECT FID,FSHAREORGID,FSHAREADJUSTID FROM t_bcm_adjustshareentry WHERE fid IN (" + String.join((CharSequence)",", succids) + ")"));){
            for (DataSet dsChild : ds.splitByGroup(new String[]{"FID"})) {
                Long fid = ((Row)dsChild.copy().iterator().next()).getLong("FID");
                dsChild.forEach(row -> {
                    IDNumberTreeNode shareOrgNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)row.getLong("FSHAREORGID"));
                    if (shareOrgNode != IDNumberTreeNode.NotFoundTreeNode) {
                        shareOrgSet.add(shareOrgNode.getNumber());
                    }
                });
                paramList.add(new Object[]{String.join((CharSequence)",", shareOrgSet.toArray(new String[0])), fid});
            }
            shareOrgSet.clear();
        }
        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)"UPDATE t_bcm_rptadjust SET FALLSHAREORG = ? WHERE FID = ?", paramList);
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
    }

    protected void transformMyCompanyVar(DynamicObject oldAdjustHeader, long orgId, DynamicObject newEntry) {
        if (!OrgRelaProcessMembPool.isRelaProcess((String)oldAdjustHeader.getString("process"))) {
            for (DynamicObject e : oldAdjustHeader.getDynamicObjectCollection("commembentry")) {
                if (!DimTypesEnum.MYCOMPANY.getNumber().equals(e.getString("comdimension.number"))) continue;
                long commembid = e.getLong("commembid");
                if (commembid == 0L) break;
                IDNumberTreeNode node = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"bcm_mycompanymembertree", (long)commembid);
                if (!SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) break;
                IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)orgId);
                IDNumberTreeNode mc = BcmThreadCache.findMemberByNum((String)this._ctx().getModelNum(), (String)"MyCompany", (String)orgNode.getNumber());
                if (IDNumberTreeNode.NotFoundTreeNode == mc) break;
                newEntry.set("mycompany", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_mycompanymembertree", mc.getId()));
                break;
            }
        }
    }

    protected AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> getTarValidator() {
        if (this.tarValidator == null) {
            this.tarValidator = new AdjustValidatorExecute(this._ctx());
            this.tarValidator.setAdjLog(this.getRecordLog());
            this.onTarAddValidators(this.tarValidator);
        }
        return this.tarValidator;
    }

    protected Long searchOldRelationId(long srcId, String belongorgNum) {
        return this.oldShareEntryTable == null ? null : (Long)this.oldShareEntryTable.get((Object)srcId, (Object)belongorgNum);
    }
}

