/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustApplicationLocker;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AdjustOperTaskStrategy;
import kd.fi.bcm.business.adjust.task.batchOperationTask.IBatchOperationTask;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLockOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperationStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AdjustOperTaskSchedulePlan {
    public static void dispatchOperTaskUnSync(AdjustOperationContext _ctx, AdjustOperTypeEnum adjustOperType, List<Long> pkIds, Map<String, Object> userDefineParam) {
        ThreadPoolService.runInAdjustOperThread(() -> AdjustOperTaskSchedulePlan.dispatchOperTaskSync(_ctx, adjustOperType, pkIds, userDefineParam, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdjRecordLog dispatchOperTaskSync(AdjustOperationContext _ctx, AdjustOperTypeEnum adjustOperType, List<Long> pkIds, Map<String, Object> userDefineParam, AdjRecordLog log) {
        if (pkIds == null) {
            return new AdjRecordLog();
        }
        if (log == null) {
            log = AdjustOperTaskSchedulePlan.buildAdjRecordLog(_ctx, adjustOperType, pkIds.size());
        }
        try {
            boolean isForceBatch = AdjustOperTaskStrategy.isForceBatch(adjustOperType);
            List<List<Long>> groupList = AdjustQueryServiceHelper.batchHandlerAdjustDataList(pkIds, isForceBatch);
            ArrayList<IRunner> taskList = new ArrayList<IRunner>(16);
            for (List<Long> group : groupList) {
                AdjRecordLog finalLog = log;
                _ctx.setOperTypeEnum(adjustOperType);
                taskList.add(() -> {
                    try {
                        IBatchOperationTask operTask = AdjustOperTaskStrategy.getStrategy(adjustOperType);
                        if (operTask != null) {
                            operTask.setLog(finalLog);
                            operTask.setAdjustOperTypeEnum(adjustOperType);
                            operTask.set_ctx((AdjustOperationContext)_ctx.clone());
                            operTask.setPkIds(group);
                            operTask.setUserDefineParam(userDefineParam);
                            operTask.doJob();
                        }
                    }
                    catch (Throwable e) {
                        finalLog.addErrorMsg(AdjustmentServiceHelper.toString_Adj(e));
                    }
                });
            }
            if (taskList.size() == 1) {
                ((IRunner)taskList.get(0)).doRun();
            } else {
                ThreadPoolService.runInWaiting4AdjustChildTaskThread(taskList.toArray(new IRunner[0]));
            }
            log.setStatus(log.getCount() <= log.getSuccessConut().get() ? AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus() : AdjustOperationStatusEnum.ERRORSTATUS.getStatus());
        }
        catch (Throwable t) {
            try {
                log.addErrorMsg(AdjustmentServiceHelper.toString_Adj(t));
                log.setStatus(log.getCount() <= log.getSuccessConut().get() ? AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus() : AdjustOperationStatusEnum.ERRORSTATUS.getStatus());
            }
            catch (Throwable throwable) {
                log.setStatus(log.getCount() <= log.getSuccessConut().get() ? AdjustOperationStatusEnum.SUCCESSSTATUS.getStatus() : AdjustOperationStatusEnum.ERRORSTATUS.getStatus());
                log.endLog();
                ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)adjustOperType.getNameBridge(), (String)adjustOperType.getOperation()), OPDescMultiLangEnumBridge.genUnTransBridge((String)log.getRecordLogDy().getString("failedlog")), (Long)_ctx.getModelId(), "bcm_rptadjustentry_list");
                logService.addLog(logInfo);
                throw throwable;
            }
            log.endLog();
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)adjustOperType.getNameBridge(), (String)adjustOperType.getOperation()), OPDescMultiLangEnumBridge.genUnTransBridge((String)log.getRecordLogDy().getString("failedlog")), (Long)_ctx.getModelId(), "bcm_rptadjustentry_list");
            logService.addLog(logInfo);
        }
        log.endLog();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)adjustOperType.getNameBridge(), (String)adjustOperType.getOperation()), OPDescMultiLangEnumBridge.genUnTransBridge((String)log.getRecordLogDy().getString("failedlog")), (Long)_ctx.getModelId(), "bcm_rptadjustentry_list");
        logService.addLog(logInfo);
        return log;
    }

    public static void dispatchContinueTaskUnSync(AdjustOperationContext _ctx, AdjustOperTypeEnum adjustOperType, Set<Long> selectOrgs, Map<String, Object> userDefineParam) {
        ThreadPoolService.runInAdjustOperThread(() -> AdjustOperTaskSchedulePlan.dispatchContinueTaskSync(_ctx, adjustOperType, selectOrgs, userDefineParam));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdjRecordLog dispatchContinueTaskSync(AdjustOperationContext _ctx, AdjustOperTypeEnum adjustOperType, Set<Long> selectOrgs, Map<String, Object> userDefineParam) {
        AdjRecordLog log = AdjustOperTaskSchedulePlan.buildAdjRecordLog(_ctx, adjustOperType, 0);
        AdjustApplicationLocker locker = new AdjustApplicationLocker(AdjustLockOperTypeEnum.OrgEntryDataLocker);
        try {
            long srcPeriod;
            long srcYear;
            log.startLog();
            String groupId = String.format("%s_%s_%s_%s_%s", _ctx.getModelNum(), _ctx.getScenariodNum(), _ctx.getFyNum(), _ctx.getPeriodNum(), adjustOperType.getName());
            selectOrgs.removeIf(selectOrg -> {
                if (MergeControlHelper.isQuoteLocked(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId(), selectOrg)) {
                    return true;
                }
                locker.addPreparedLockKey(groupId, selectOrg.toString(), ResManager.loadKDString((String)"\u5f53\u671f%s\u7ec4\u7ec7\u6b63\u5728\u88ab\u5ef6\u7eed\uff0c\u8bf7\u52ff\u64cd\u4f5c\u3002", (String)"AdjustOperTaskSchedulePlan_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            });
            Optional<String> errorLockerOp = locker.batchRequest().entrySet().stream().filter(p -> (Boolean)p.getValue() == false).map(Map.Entry::getKey).findFirst();
            if (errorLockerOp.isPresent()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u671f%s\u7ec4\u7ec7\u6b63\u5728\u88ab\u5ef6\u7eed\uff0c\u8bf7\u7b49\u5f85\u5176\u4ed6\u8fdb\u7a0b\u6267\u884c\u5b8c\u5728\u64cd\u4f5c\u3002", (String)"AdjustOperTaskSchedulePlan_1", (String)"fi-bcm-business", (Object[])new Object[0]), BcmThreadCache.findNodeById((String)_ctx.getModelNum(), (String)"Entity", (long)LongUtil.toLong((Object)errorLockerOp.get())).getNumber()));
            }
            long srcScene = _ctx.getScenarioId();
            String specialFirstPeriod = (String)userDefineParam.get("specialFirstPeriod");
            String specialLastPeriod = (String)userDefineParam.get("specialLastPeriod");
            boolean isFirstPeriod = StringUtil.equals((String)_ctx.getPeriodNum(), (String)specialFirstPeriod) || PeriodUtils.isFirstPeriod((String)_ctx.getModelNum(), (String)_ctx.getPeriodNum());
            JournalTypeEnum journalType = AdjustOperTypeEnum.PERIODCONTINUEOPERATION == adjustOperType ? JournalTypeEnum.PERIOD : JournalTypeEnum.YEAR;
            HashMap<Long, Set> specialPeriodMap = new HashMap<Long, Set>();
            ConcurrentHashSet toContinueAdjustIds = new ConcurrentHashSet(16);
            if (AdjustOperTypeEnum.PERIODCONTINUEOPERATION == adjustOperType && !isFirstPeriod) {
                String[] yearAndPeriod = PeriodUtils.getLastPeriodIncludeYear((String)_ctx.getModelNum(), (String)_ctx.getFyNum(), (String)_ctx.getPeriodNum(), (boolean)true);
                srcYear = MemberReader.findFyMemberByNum((String)_ctx.getModelNum(), (String)yearAndPeriod[0]).getId();
                srcPeriod = MemberReader.findPeriodMemberByNum((String)_ctx.getModelNum(), (String)(StringUtils.isEmpty((String)specialLastPeriod) ? yearAndPeriod[1] : specialLastPeriod)).getId();
            } else {
                Pair<Long, String> carryList = CarryServiceHelper.getCarryLast(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId());
                srcYear = MemberReader.findFyMemberByNum((String)_ctx.getModelNum(), (String)((String)carryList.getRight())).getId();
                long l = srcPeriod = StringUtils.isNotEmpty((String)specialLastPeriod) ? MemberReader.findPeriodMemberByNum((String)_ctx.getModelNum(), (String)specialLastPeriod).getId().longValue() : ((Long)carryList.getLeft()).longValue();
                if (StringUtils.isEmpty((String)specialLastPeriod) && !ConfigServiceHelper.getBoolParam(_ctx.getModelId(), "isIgnoreContinueSpecSet")) {
                    Map<Long, String> specialCarryLastMap = CarryServiceHelper.getBatchEntityCarryLast(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId(), selectOrgs);
                    specialCarryLastMap.forEach((orgId, period) -> {
                        selectOrgs.remove(orgId);
                        specialPeriodMap.computeIfAbsent(MemberReader.findPeriodMemberByNum((String)_ctx.getModelNum(), (String)period).getId(), a -> Sets.newHashSet()).add(orgId);
                    });
                }
            }
            specialPeriodMap.computeIfAbsent(srcPeriod, a -> Sets.newHashSet()).addAll(selectOrgs);
            ThreadPoolService.runInWaiting4AdjustChildTaskThread((IRunner[])specialPeriodMap.entrySet().stream().map(arg_0 -> AdjustOperTaskSchedulePlan.lambda$dispatchContinueTaskSync$9((Set)toContinueAdjustIds, _ctx, srcScene, srcYear, journalType, arg_0)).toArray(IRunner[]::new));
            QFBuilder currQF = new QFBuilder();
            currQF.add("model", "=", (Object)_ctx.getModelId());
            currQF.add("scenario", "=", (Object)_ctx.getScenarioId());
            currQF.add("year", "=", (Object)_ctx.getFyId());
            currQF.add("period", "=", (Object)_ctx.getPeriodId());
            currQF.add("sourcetype", "=", (Object)Integer.toString(ElimRptAdjSourceTypeEnum.CONTINUE.getValue()));
            try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(Collections.singleton("extend"), currQF, null, -1);){
                ds.forEachRemaining(arg_0 -> AdjustOperTaskSchedulePlan.lambda$dispatchContinueTaskSync$11((Set)toContinueAdjustIds, arg_0));
            }
            if (toContinueAdjustIds.isEmpty()) {
                log.addWarningMsg(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c : \u4e0d\u5b58\u5728\u53ef\u5ef6\u7eed\u7684\u5206\u5f55\u3002", (String)"AdjustOperTaskSchedulePlan_2", (String)"fi-bcm-business", (Object[])new Object[0]), adjustOperType.getName()));
            }
            log.setCount(toContinueAdjustIds.size());
            userDefineParam.put("srcScene", srcScene);
            userDefineParam.put("srcYear", srcYear);
            userDefineParam.put("srcPeriod", specialPeriodMap);
            log = AdjustOperTaskSchedulePlan.dispatchOperTaskSync(_ctx, adjustOperType, new ArrayList<Long>((Collection<Long>)toContinueAdjustIds), userDefineParam, log);
        }
        catch (Throwable t) {
            log.addErrorMsg(AdjustmentServiceHelper.toString_Adj(t));
        }
        finally {
            log.endLog();
            locker.batchRelease();
        }
        return log;
    }

    private static AdjRecordLog buildAdjRecordLog(AdjustOperationContext _ctx, AdjustOperTypeEnum adjustOperType, int size) {
        AdjRecordLog log = new AdjRecordLog();
        log.loadRecord(AdjustOperationThreadHelper.createAdjustOperRecord(adjustOperType, _ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId(), size));
        return log.startLog();
    }

    private static /* synthetic */ void lambda$dispatchContinueTaskSync$11(Set toContinueAdjustIds, Row row) {
        toContinueAdjustIds.remove(row.getLong("extend"));
    }

    private static /* synthetic */ IRunner lambda$dispatchContinueTaskSync$9(Set toContinueAdjustIds, AdjustOperationContext _ctx, long srcScene, long srcYear, JournalTypeEnum journalType, Map.Entry period2OrgScope) {
        return () -> toContinueAdjustIds.addAll(AdjustQueryServiceHelper.queryAdjustIds(_ctx.getModelId(), srcScene, srcYear, (Long)period2OrgScope.getKey(), (Set)period2OrgScope.getValue(), new QFBuilder("adjust.journaltype", "=", (Object)journalType.getKey()).add("adjust.status", "=", (Object)RptAdjustStatusEnum.AUDIT.status()).add("adjust.sourcetype", "!=", (Object)(ElimRptAdjSourceTypeEnum.LINK.getValue() + "")).toList()));
    }
}

