/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.attachment.AdjustAttachmentHelper;
import kd.fi.bcm.business.adjust.convert.NewAdjustConvertService;
import kd.fi.bcm.business.adjust.model.AdjustEntryConfig;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AbstractBatchNewOperationTask;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AbstractDynamicModelValidator;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AdjustCheckDimMemDynaModelValidator;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AdjustCheckPermDynaModelValidator;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.dynamicObjectModel.AdjustLoadTypeEnum;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ContinueOperationTask
extends AbstractBatchNewOperationTask {
    private List<LossCarryScheme> lossCarrySchemes;
    private NewAdjustConvertService adjConvertSer;

    @Override
    void onPrepareQueryParam(AdjustOperQueryParam queryParam) {
        super.onPrepareQueryParam(queryParam);
        queryParam.setEntryLoadType(AdjustLoadTypeEnum.LoadNoFields);
        queryParam.setEntryLoadType(AdjustLoadTypeEnum.DataSetRow);
    }

    @Override
    void onAddValidators(AdjustValidatorExecute e) {
        e.addValidator(new AdjustCheckPermDynaModelValidator());
        e.addOnlyWarningValidator(new AdjustCheckDimMemDynaModelValidator());
        e.addValidator(new AbstractDynamicModelValidator(){

            @Override
            protected void validateSingle(IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
                if (!JournalTypeEnum.YEAR.getKey().equals(adjust.getString("journaltype")) && !JournalTypeEnum.PERIOD.getKey().equals(adjust.getString("journaltype"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u4e0d\u662f\u5ef6\u7eed\u7c7b\u5206\u5f55\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustContinueOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (!RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u5df2\u5ba1\u6838\u7684\u8c03\u6574\u62b5\u9500\u5206\u5f55\u8fdb\u884c\u5ef6\u7eed\u64cd\u4f5c\u3002", (String)"AdjustContinueCheckValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (ElimRptAdjSourceTypeEnum.LINK.getValue() == adjust.getInt("sourcetype")) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u5f55\u4e3a\u8054\u52a8\u5206\u5f55\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustCreateLinkageOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    @Override
    void beforeValidatorData(List<IDynamicObjectModel> adjustDys, Map<Long, List<IDynamicObjectModel>> adjustDatas) {
        super.beforeValidatorData(adjustDys, adjustDatas);
        HashMap link2SrcMap = new HashMap(adjustDys.size());
        adjustDys.stream().filter(p -> p.getInt("sourcetype") != ElimRptAdjSourceTypeEnum.LINK.getValue()).forEach(p -> {
            long linkSourceId = p.getLong("linkagelinksource");
            if (linkSourceId != 0L) {
                link2SrcMap.put(linkSourceId, p.getLong("id"));
            }
        });
        if (!link2SrcMap.isEmpty()) {
            QFilter qf = new QFilter("adjust", "in", link2SrcMap.keySet()).and("adjust.status", "=", (Object)RptAdjustStatusEnum.AUDIT.status());
            List<IDynamicObjectModel> linkEntries = AdjustQueryServiceHelper.loadDataFromDB(this.getQueryParam().getEntryLoadType(), "bcm_rptadjustdata", this.getQueryParam().getEntryFieldStr(), qf.toArray(), null);
            Map<Long, List<IDynamicObjectModel>> src2LinkEntries = linkEntries.stream().collect(Collectors.groupingBy(p -> link2SrcMap.getOrDefault(p.getBaseDataId("adjust"), 0L)));
            src2LinkEntries.forEach((srcId, entries) -> adjustDatas.computeIfAbsent((Long)srcId, a -> Lists.newArrayList()).addAll(entries));
        }
    }

    @Override
    void dispose(List<IDynamicObjectModel> newElims, Map<Long, List<IDynamicObjectModel>> newEntrys) {
        boolean isCM040 = ConfigServiceHelper.getBoolParam(this._ctx().getModelId(), "CM040");
        boolean isOverYear = this.getSrcYear() != this.getTarYear();
        String continueType = ConfigServiceHelper.getAdjustContinueType(this._ctx().getModelId());
        ArrayList<DynamicObject> resultNewElimList = new ArrayList<DynamicObject>(newElims.size());
        ArrayList<DynamicObject> resultEntryList = new ArrayList<DynamicObject>(newEntrys.size());
        ArrayList<IDynamicObjectModel> tempEntryList = new ArrayList<IDynamicObjectModel>(16);
        this.prepareBatchConvert(newElims, newEntrys);
        this.getAdjConvertService().prepareConvertData(newElims);
        for (IDynamicObjectModel oldElim : newElims) {
            try {
                long srcAdjustId = oldElim.getLong("id");
                boolean isLinkPage = ElimRptAdjSourceTypeEnum.LINK.getValue() == oldElim.getInt("sourcetype");
                List<IDynamicObjectModel> tempEntryModelList = newEntrys.get(srcAdjustId);
                if (!CollectionUtil.isEmpty(tempEntryModelList)) {
                    IDynamicObjectModel tempNewElim = oldElim.copy(true);
                    AdjustOperationHelper.resetElim(tempNewElim, true);
                    tempNewElim.set("id", (Object)this.getIdDistributor().getLongId());
                    tempNewElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
                    tempNewElim.set("scenario", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_scenemembertree", this.getTarScene()));
                    tempNewElim.set("year", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_fymembertree", this.getTarYear()));
                    tempNewElim.set("period", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_periodmembertree", this.getTarPeriod()));
                    IDNumberTreeNode manualNode = BcmThreadCache.findMemberByNum((String)this._ctx().getModelNum(), (String)"AuditTrail", (String)"ManualJournal");
                    IDNumberTreeNode autoNode = BcmThreadCache.findMemberByNum((String)this._ctx().getModelNum(), (String)"AuditTrail", (String)"AutoJournal");
                    if (manualNode != IDNumberTreeNode.NotFoundTreeNode && autoNode != IDNumberTreeNode.NotFoundTreeNode && (isLinkPage || autoNode.getId().longValue() == tempNewElim.getBaseDataId("audittrail"))) {
                        tempNewElim.set("audittrail", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_audittrialmembertree", manualNode.getId()));
                    }
                    AdjustOperationHelper.resetElimCommonEntries(tempNewElim);
                    tempNewElim.set("creator", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bos_user", RequestContext.get().getCurrUserId()));
                    tempNewElim.set("createtime", (Object)TimeServiceHelper.now());
                    tempNewElim.set("iscontinuous", (Object)1);
                    tempNewElim.set("extend", (Object)srcAdjustId);
                    tempNewElim.set("extendfrom", (Object)oldElim.getString("number"));
                    tempNewElim.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.CONTINUE.getValue());
                    switch (continueType) {
                        case "0": {
                            tempNewElim.set("linkcreatetype", (Object)AdjustLinkCreateEnum.COMMONADJUST.getStatus());
                            break;
                        }
                        case "1": {
                            tempNewElim.set("linkcreatetype", (Object)AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus());
                            break;
                        }
                        case "2": {
                            tempNewElim.set("linkcreatetype", (Object)AdjustLinkCreateEnum.MANUALCREATEADJUST.getStatus());
                            break;
                        }
                    }
                    for (IDynamicObjectModel entryModel : tempEntryModelList) {
                        String msg;
                        IDynamicObjectModel entry = AdjustOperationHelper.cloneNewEntry(entryModel);
                        entry.set("id", (Object)this.getIdDistributor().getLongId());
                        entry.set("adjust", tempNewElim.get("id"));
                        entry.set("scenario", (Object)tempNewElim.getBaseDataId("scenario"));
                        entry.set("year", (Object)tempNewElim.getBaseDataId("year"));
                        entry.set("period", (Object)tempNewElim.getBaseDataId("period"));
                        entry.set("checkrecordentry", (Object)0);
                        entry.set("ischanged", (Object)Character.valueOf('0'));
                        entry.set("entrysource", (Object)(EntrySourceEnum.getLinkList().contains(entry.getInt("entrysource")) ? 4 : 3));
                        if (manualNode != IDNumberTreeNode.NotFoundTreeNode && autoNode != IDNumberTreeNode.NotFoundTreeNode && (isLinkPage || autoNode.getId().longValue() == entry.getBaseDataId("audittrail"))) {
                            entry.set("audittrail", (Object)manualNode.getId());
                        }
                        if (isCM040 && !StringUtil.isEmptyString((String)(msg = AdjustOperationHelper.dealEntryEffectEntity(entry)))) {
                            this.addWarnOper(tempNewElim.getLong("id"), msg);
                        }
                        if (isOverYear) {
                            AdjustOperationHelper.changeCarryYearAdjustElim(AdjustOperationHelper.createVersionParam(this._ctx().getModelId(), this.getTarScene(), this.getTarYear(), this.getTarPeriod()), entry, this.getLossCarrySchemes());
                        }
                        AdjustOperationHelper.dealEntryPrecision(this._ctx().getModelId(), this._ctx().getScenariodNum(), entry);
                        tempEntryList.add(entry);
                    }
                    this.getAdjConvertService().singleConvert(tempNewElim, tempEntryList, false);
                    List<DynamicObject> tempEntries = tempEntryList.stream().map(p -> (DynamicObject)p.getData()).collect(Collectors.toList());
                    AdjustConvertUtil.setAdjustDataShowSeq(tempEntries, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)((DynamicObject)tempNewElim.getData()), tempEntries, (boolean)false);
                    resultNewElimList.add((DynamicObject)tempNewElim.getData());
                    resultEntryList.addAll(tempEntries);
                    tempEntryList.clear();
                }
                this.addSuccessCount();
            }
            catch (Throwable t) {
                this.addErrorOper(oldElim.getLong("id"), oldElim.getString("number") + " : " + AdjustmentServiceHelper.toString_Adj(t));
            }
        }
        AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", resultNewElimList);
        AdjustmentServiceHelper.rebuildAdjustCommembEntry(this._ctx().getModelId(), resultNewElimList, resultEntryList);
        Map<Long, Long> src2tarAdjustMap = resultNewElimList.parallelStream().collect(Collectors.toMap(p -> p.getLong("extend"), p -> p.getLong("id")));
        PlatUtil.executeWithTX(tx -> {
            SaveServiceHelper.save((DynamicObject[])resultNewElimList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])resultEntryList.toArray(new DynamicObject[0]));
            AdjustOperationHelper.clonePermClassFromSrcAdjust(this._ctx().getModelId(), src2tarAdjustMap);
        });
        ThreadPoolService.runInThread(() -> AdjustAttachmentHelper.copyAttachment(src2tarAdjustMap));
    }

    private void prepareBatchConvert(List<IDynamicObjectModel> elims, Map<Long, List<IDynamicObjectModel>> entrys) {
        HashSet<Long> toConvertOrgSet = new HashSet<Long>(16);
        for (IDynamicObjectModel elim : elims) {
            if (!AdjustOperationHelper.isMultipleCurrencyElim(elim)) continue;
            if (OrgRelaProcessMembPool.isRelaProcess((String)elim.getString("process"))) {
                toConvertOrgSet.add(elim.getBaseDataId("entity"));
                continue;
            }
            entrys.getOrDefault(elim.getLong("id"), Collections.emptyList()).forEach(entry -> toConvertOrgSet.add(entry.getBaseDataId("entity")));
        }
        this.getAdjConvertService().prepareRateData(toConvertOrgSet);
    }

    public List<LossCarryScheme> getLossCarrySchemes() {
        if (this.lossCarrySchemes == null) {
            this.lossCarrySchemes = AdjustEntryConfig.get().getLossCarrySchemes(this._ctx().getModelId());
            this.lossCarrySchemes.removeIf(lossCarryScheme -> !lossCarryScheme.isOpen());
        }
        return this.lossCarrySchemes;
    }

    long getSrcScene() {
        return (Long)this.getUserDefineParam("srcScene");
    }

    long getSrcYear() {
        return (Long)this.getUserDefineParam("srcYear");
    }

    Map<Long, Set<Long>> getSrcPeriod() {
        return (Map)this.getUserDefineParam("srcPeriod");
    }

    long getTarScene() {
        return this._ctx().getScenarioId();
    }

    long getTarYear() {
        return this._ctx().getFyId();
    }

    long getTarPeriod() {
        return this._ctx().getPeriodId();
    }

    public NewAdjustConvertService getAdjConvertService() {
        if (this.adjConvertSer == null) {
            this.adjConvertSer = new NewAdjustConvertService(this._ctx());
        }
        return this.adjConvertSer;
    }
}

