/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.attachment.AdjustAttachmentHelper;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AbstractLightWeightOperationTask;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustCheckStatusEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.spread.common.util.StringUtil;

public class MixOperationTask
extends AbstractLightWeightOperationTask {
    private static final Set<String> checkSingleElimFieldSet = Collections.unmodifiableSet(new HashSet(){
        {
            this.add("sourcetype");
            this.add("journaltype");
            this.add("bussnesstype");
            this.add("entity.number");
            this.add("balancetype");
            this.add("linkcreatetype");
            this.add("templatecatalog.number");
            this.add("multiplecurrency");
            this.add("cvtbeforecurrency.id");
        }
    });
    private boolean isSuccess = true;

    @Override
    public void doJob() {
        this.isSuccess = true;
        Table<String, Long, Row> toMixElimTable = this.queryAdjustElimData(this.getPkIds());
        this.repairMixAdjustElimData(toMixElimTable);
        Map sourceMap = toMixElimTable.row((Object)ElimHeaderSourceEnum.SOURCE.getValue());
        if (toMixElimTable.row((Object)ElimHeaderSourceEnum.SOURCE.getValue()).size() < 2) {
            this.addWarnOper(ResManager.loadKDString((String)"\u6e90\u5206\u5f55\u6570\u5c11\u4e8e\u4e24\u4e2a\uff0c\u65e0\u9700\u8fdb\u884c\u878d\u5408\u3002", (String)"MixOperationTask_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        if (toMixElimTable.containsRow((Object)ElimHeaderSourceEnum.SHARE.getValue())) {
            toMixElimTable.row((Object)ElimHeaderSourceEnum.SHARE.getValue()).forEach((pkId, share) -> this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u4e3a\u5171\u4eab\u5206\u5f55\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_2", (String)"fi-bcm-business", (Object[])new Object[0]), share.getString("number"))));
        }
        if (toMixElimTable.containsRow((Object)ElimHeaderSourceEnum.SHARE_LINKAGE.getValue())) {
            toMixElimTable.row((Object)ElimHeaderSourceEnum.SHARE.getValue()).forEach((pkId, share) -> this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u4e3a\u5171\u4eab-\u8054\u52a8\u5206\u5f55\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_3", (String)"fi-bcm-business", (Object[])new Object[0]), share.getString("number"))));
        }
        if (this.isSuccess && !sourceMap.isEmpty()) {
            Optional<Long> srcOp = this.getPkIds().stream().filter(sourceMap::containsKey).findFirst();
            DynamicObject mainElim = BusinessDataServiceHelper.loadSingle((Object)srcOp.orElseGet(() -> (Long)sourceMap.keySet().iterator().next()), (String)"bcm_rptadjust");
            DynamicObject mainElimClone = AdjustOperationHelper.copyDynamicObject(mainElim, true);
            HashMap<Long, Row> sourceMapClone = new HashMap<Long, Row>(sourceMap);
            sourceMapClone.putAll(toMixElimTable.row((Object)ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()));
            this.checkMainElimProperty(mainElim, sourceMapClone, mainElimClone);
            Set<String> toMoveDimSet = this.checkCommembentrys(mainElim, sourceMap);
            this.doMixOperation(mainElim, mainElimClone, toMixElimTable, toMoveDimSet);
        }
    }

    private void repairMixAdjustElimData(Table<String, Long, Row> toMixElimTable) {
        Set<Long> linkSourceIdSet = toMixElimTable.values().stream().map(p -> p.getLong("linkagelinksource")).collect(Collectors.toSet());
        linkSourceIdSet.remove(0L);
        linkSourceIdSet.remove(null);
        if (!CollectionUtil.isEmpty(linkSourceIdSet)) {
            toMixElimTable.putAll(this.queryAdjustElimData(linkSourceIdSet));
            linkSourceIdSet.addAll(this.getPkIds());
            this.setPkIds(new ArrayList<Long>(linkSourceIdSet));
            this.getRecordLog().setCount(this.getPkIds().size());
        }
    }

    private void checkMainElimProperty(DynamicObject mainElim, Map<Long, Row> rowMap, DynamicObject mainElimClone) {
        IDNumberTreeNode mainBelongOrgNode;
        if (!this.isSuccess) {
            return;
        }
        List<String> entrySourceList = Arrays.asList(String.valueOf(2), String.valueOf(6), String.valueOf(9), String.valueOf(1), String.valueOf(5), String.valueOf(8), String.valueOf(0), String.valueOf(10));
        String templatecatalog = StringUtil.isEmptyString((String)mainElim.getString("templatecatalog.number")) ? "root" : mainElim.getString("templatecatalog.number");
        ArrayList errorFieldList = new ArrayList(checkSingleElimFieldSet.size());
        HashMultimap<Long, Row> entrysMap = this.queryAdjustEntryData(new QFBuilder("adjust", "in", rowMap.keySet()).add("isdefaultcurrency", "=", (Object)"1"));
        Set mainChildEntrys = entrysMap.get((Object)mainElim.getLong("id"));
        if (mainChildEntrys.isEmpty()) {
            this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u65e0\u660e\u7ec6\u884c\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_4", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
            return;
        }
        boolean isRelaProcess = OrgRelaProcessMembPool.isRelaProcess((String)mainElim.getString("process"));
        String mainBelongOrg = mainElim.getString("entity.number");
        if (!isRelaProcess) {
            Set belongOrgSet = entrysMap.get((Object)mainElim.getLong("id")).stream().map(p -> p.getString("entity.number")).collect(Collectors.toSet());
            if (belongOrgSet.size() == 1) {
                mainBelongOrg = (String)belongOrgSet.iterator().next();
            } else {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u5b58\u5728\u591a\u4e2a\u660e\u7ec6\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_5", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
                return;
            }
        }
        if ((mainBelongOrgNode = MemberReader.findEntityMemberByNum((String)this._ctx().getModelNum(), (String)mainBelongOrg)) == IDNumberTreeNode.NotFoundTreeNode) {
            this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)%2$s\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_6", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number"), isRelaProcess ? ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"MixOperationTask_7", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7", (String)"MixOperationTask_8", (String)"fi-bcm-business", (Object[])new Object[0])));
            return;
        }
        mainElimClone.set("entity", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", mainBelongOrgNode.getId()));
        mainElimClone.set("belongorg", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bcm_entitymembertree", mainBelongOrgNode.getId()));
        PermissionService permissionService = PermissionServiceImpl.getInstance(this._ctx().getModelId());
        DynamicObject permClass = this.getPermissionClassById(mainElim.getLong("id"));
        if (!permissionService.isAdmin()) {
            if (permClass != null && !"3".equals(PermClassEntityHelper.getDataPermission(RequestContext.get().getUserId(), UserTypeEnum.USER.getIndex(), permClass.getString("permclass.id"), this._ctx().getModelId() + ""))) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u6743\u9650\u7c7b\u65e0\u6743\u6216\u8005\u53ea\u8bfb\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_9", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
                return;
            }
            long templatecatalogId = mainElim.getLong("templatecatalog.id");
            if (templatecatalogId != 0L) {
                ArrayListMultimap<String, Long> calPermCalssMap = PermClassEntityHelper.getPermissionMap("bcm_templatecatalog", String.valueOf(this._ctx().getModelId()), RequestContext.get().getUserId());
                List noPermCalIds = calPermCalssMap.get((Object)"1");
                if (!CollectionUtils.isEmpty((Collection)noPermCalIds) && noPermCalIds.contains(templatecatalogId)) {
                    this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u5206\u7c7b\u6743\u9650\u7c7b\u65e0\u6743\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_10", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
                    return;
                }
                List readOnlyCalIds = calPermCalssMap.get((Object)"2");
                if (!CollectionUtils.isEmpty((Collection)readOnlyCalIds) && readOnlyCalIds.contains(templatecatalogId)) {
                    this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u5206\u7c7b\u6743\u9650\u7c7b\u53ea\u8bfb\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_11", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
                    return;
                }
            }
            if (permClass != null && !"3".equals(PermClassEntityHelper.getDataPermission(RequestContext.get().getUserId(), UserTypeEnum.USER.getIndex(), permClass.getString("permclass.id"), this._ctx().getModelId() + ""))) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u6743\u9650\u7c7b\u65e0\u6743\u6216\u8005\u53ea\u8bfb\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_9", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number")));
                return;
            }
            Dimension orgDim = this._ctx().getSctx().getDimensionByNumber("Entity");
            if (!permissionService.hasWritePerm(orgDim.getId(), mainBelongOrgNode.getId())) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)%2$s\u65e0\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_12", (String)"fi-bcm-business", (Object[])new Object[0]), mainElim.getString("number"), isRelaProcess ? ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"MixOperationTask_7", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7", (String)"MixOperationTask_8", (String)"fi-bcm-business", (Object[])new Object[0])));
                return;
            }
            QFBuilder qf = new QFBuilder("adjust", "in", rowMap.keySet()).add("isdefaultcurrency", "=", (Object)"1");
            QFilter permQf = null;
            for (Dimension dim : this._ctx().getSctx().getDimensions()) {
                if ("Entity".equals(dim.getNumber())) continue;
                if (permQf == null) {
                    permQf = new QFilter("1", "=", (Object)2);
                }
                permQf.or(permissionService.getNoOrReadPermFilter(dim.getId(), dim.getEntity(), dim.getFieldmapped()));
            }
            if (permQf != null) {
                qf.add(permQf);
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkEntryPerm", (String)"bcm_rptadjustdata", (String)"adjust", (QFilter[])qf.toArray(), null, (int)-1);){
                HashSet noOrReadPermAdjustSet = new HashSet(rowMap.size());
                ds.forEachRemaining(p -> {
                    long adjustId = p.getLong("adjust");
                    if (noOrReadPermAdjustSet.add(adjustId)) {
                        this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u65e0\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_13", (String)"fi-bcm-business", (Object[])new Object[0]), ((Row)rowMap.get(adjustId)).getString("number")));
                    }
                });
            }
        }
        if (!this.isSuccess) {
            return;
        }
        String finalMainBelongOrg = mainBelongOrg;
        rowMap.forEach((pkId, sourceRow) -> {
            Long sceneId = DynUtils.getBaseId((DynamicObject)mainElim, (String)"scenario");
            String status = sourceRow.getString("status");
            int sourceType = Integer.parseInt(sourceRow.getString("sourcetype"));
            Set childEntrys = entrysMap.get(pkId);
            if (childEntrys.isEmpty()) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u65e0\u660e\u7ec6\u884c\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_4", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number")));
            } else if (sceneId.longValue() != this._ctx().getScenarioId()) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u662f\u6e90\u60c5\u666f\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_14", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number")));
            } else if (MergeControlHelper.isQuoteLocked(this._ctx().getModelId(), sceneId, this._ctx().getFyId(), this._ctx().getPeriodId(), BcmThreadCache.findMemberByNum((String)this._ctx().getModelNum(), (String)"Entity", (String)finalMainBelongOrg).getId())) {
                this.addErrorOper(AdjustSceneVersionValidator.packErrorMsg(finalMainBelongOrg, this._ctx().getFyNum(), this._ctx().getPeriodNum()));
            } else if (!RptAdjustStatusEnum.SAVE.status().equals(status) && !RptAdjustStatusEnum.BACK.status().equals(status)) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u4e0d\u4e3a\u4fdd\u5b58\u6216\u8005\u6253\u56de\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_15", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number")));
            } else if (ElimRptAdjSourceTypeEnum.AUTO.getValue() == sourceType || ElimRptAdjSourceTypeEnum.SHEETINV.getValue() == sourceType || ElimRptAdjSourceTypeEnum.COMMON_PAPER.getValue() == sourceType) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u4e3a\u81ea\u52a8\u5206\u5f55\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_16", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number")));
            } else if (ElimRptAdjSourceTypeEnum.MANUAL.getValue() == sourceType && childEntrys.stream().anyMatch(entry -> entrySourceList.contains(entry.getString("entrysource")))) {
                this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)\u4e3a\u81ea\u52a8\u5206\u5f55\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_16", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number")));
            } else {
                String templatecatalogOther;
                if (ObjectUtils.notEqual((Object)sourceRow.getString("journaltype"), (Object)mainElim.getString("journaltype"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b", (String)"MixOperationTask_17", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (ObjectUtils.notEqual((Object)sourceRow.getString("bussnesstype"), (Object)mainElim.getString("bussnesstype"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"MixOperationTask_18", (String)"fi-bcm-business", (Object[])new Object[0]));
                } else if (isRelaProcess) {
                    if (ObjectUtils.notEqual((Object)sourceRow.getString("entity.number"), (Object)finalMainBelongOrg)) {
                        errorFieldList.add(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"MixOperationTask_7", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                } else if (childEntrys.stream().anyMatch(entry -> ObjectUtils.notEqual((Object)entry.getString("entity.number"), (Object)finalMainBelongOrg))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u660e\u7ec6\u7ec4\u7ec7", (String)"MixOperationTask_8", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (ElimRptAdjSourceTypeEnum.LINK.getValue() != sourceType && ObjectUtils.notEqual((Object)sourceRow.getString("balancetype"), (Object)mainElim.getString("balancetype"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u5e73\u8861\u7c7b\u578b", (String)"MixOperationTask_19", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (ObjectUtils.notEqual((Object)sourceRow.getString("linkcreatetype"), (Object)mainElim.getString("linkcreatetype"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u8054\u52a8\u751f\u6210\u65b9\u5f0f", (String)"MixOperationTask_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if ("1".equals(sourceRow.getString("multiplecurrency")) != "1".equals(mainElim.getString("multiplecurrency"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u662f\u5426\u591a\u5e01\u79cd", (String)"MixOperationTask_21", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (ObjectUtils.notEqual((Object)sourceRow.getLong("cvtbeforecurrency.id"), (Object)mainElim.getLong("cvtbeforecurrency.id"))) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u8f93\u5165\u5e01\u79cd", (String)"MixOperationTask_22", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                String string = templatecatalogOther = StringUtil.isEmptyString((String)sourceRow.getString("templatecatalog.number")) ? "root" : sourceRow.getString("templatecatalog.number");
                if (ObjectUtils.notEqual((Object)templatecatalogOther, (Object)templatecatalog)) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"MixOperationTask_23", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                DynamicObject permClassOther = this.getPermissionClassById((Long)pkId);
                if (permClass == null && permClassOther != null || permClass != null && permClassOther != null && permClass.getLong("permclass.id") != permClassOther.getLong("permclass.id")) {
                    errorFieldList.add(ResManager.loadKDString((String)"\u6743\u9650\u7c7b", (String)"MixOperationTask_24", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (!CollectionUtil.isEmpty((Collection)errorFieldList)) {
                    this.addErrorOper(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%1$s)%2$s\u5b57\u6bb5\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53c2\u4e0e\u878d\u5408\u3002", (String)"MixOperationTask_25", (String)"fi-bcm-business", (Object[])new Object[0]), sourceRow.getString("number"), errorFieldList));
                    errorFieldList.clear();
                }
            }
        });
    }

    private DynamicObject getPermissionClassById(Long pkId) {
        return (DynamicObject)((Map)ThreadCache.get((Object)"batchGetPermissionClass", () -> PermClassEntityHelper.batchGetPermissionClassByEntityAndId(this._ctx().getModelId(), "bcm_rptadjust", new HashSet<Long>(this.getPkIds())))).get(pkId);
    }

    private Set<String> checkCommembentrys(DynamicObject elim, Map<Long, Row> rowMap) {
        if (!this.isSuccess) {
            return Collections.emptySet();
        }
        HashSet<String> toMoveDimSet = new HashSet<String>(16);
        HashSet spreadmembentrys = new HashSet(16);
        CharSequence[] successIds = (String[])rowMap.keySet().stream().map(Object::toString).distinct().toArray(String[]::new);
        DataSet ds = DB.queryDataSet((String)"QUERY_SPREADMEMBENTRY", (DBRoute)BCMConstant.DBROUTE, (String)String.format("SELECT distinct FdimensionID FROM t_bcm_rptadjustspreaddim WHERE FID IN (%s)", String.join((CharSequence)",", successIds)));
        Object object = null;
        try {
            ds.forEachRemaining(row -> {
                Dimension dim = this._ctx().getSctx().getDimensionById(row.getLong("FdimensionID"));
                if (dim != null) {
                    spreadmembentrys.add(dim.getNumber());
                }
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Dimension, String> commembentrys = new HashMap<Dimension, String>();
        for (DynamicObject commembentry : elim.getDynamicObjectCollection("commembentry")) {
            Dimension dim = this._ctx().getSctx().getDimensionById(commembentry.getLong("comdimension.id"));
            if (dim == null) continue;
            if (spreadmembentrys.contains(dim.getNumber())) {
                toMoveDimSet.add(dim.getNumber());
                continue;
            }
            commembentrys.put(dim, BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dim.getNumber(), (long)DynUtils.getBaseId((DynamicObject)commembentry, (String)"commembid")).getNumber());
        }
        try (DataSet ds2 = DB.queryDataSet((String)"QUERY_COMMONMEMBENTRY", (DBRoute)BCMConstant.DBROUTE, (String)String.format("SELECT FID,FdimensionID,FMemberid FROM t_bcm_rptadjustcomdim WHERE FID IN (%s)", String.join((CharSequence)",", successIds)));){
            ds2.forEachRemaining(row -> {
                Dimension dim = this._ctx().getSctx().getDimensionById(row.getLong("FdimensionID"));
                if (dim != null && commembentrys.containsKey(dim) && !"Entity".equals(dim.getNumber()) && !StringUtil.equals((String)((String)commembentrys.get(dim)), (String)BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dim.getNumber(), (long)row.getLong("FMemberid")).getNumber())) {
                    toMoveDimSet.add(dim.getNumber());
                }
            });
        }
        toMoveDimSet.remove("Entity");
        return toMoveDimSet;
    }

    private void doMixOperation(DynamicObject mainElim, DynamicObject mainElimClone, Table<String, Long, Row> toMixElimTable, Set<String> toMoveDimSet) {
        if (this.isSuccess) {
            ArrayList pkList = new ArrayList(toMixElimTable.values().size());
            this.clearElim(mainElimClone);
            AdjustOperationHelper.batchGetNumbers("bcm_rptadjust", Collections.singletonList(mainElimClone));
            mainElimClone.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.MANUAL.getValue());
            mainElimClone.set("name", (Object)String.format(ResManager.loadKDString((String)"%s_\u878d\u5408", (String)"MixOperationTask_27", (String)"fi-bcm-business", (Object[])new Object[0]), mainElimClone.getString("name")));
            mainElimClone.getDynamicObjectCollection("commembentry").removeIf(commembentry -> {
                commembentry.set("id", null);
                return toMoveDimSet.contains(commembentry.getString("comdimension.number"));
            });
            DynamicObjectCollection spreadmembentrys = mainElimClone.getDynamicObjectCollection("spreadmembentry");
            spreadmembentrys.forEach(spreadmembentry -> spreadmembentry.set("id", null));
            toMoveDimSet.forEach(toMoveDim -> {
                DynamicObject spreadmembentry = spreadmembentrys.addNew();
                Dimension dim = this._ctx().getSctx().getDimensionByNumber((String)toMoveDim);
                spreadmembentry.set("spreaddimension", (Object)dim.getId());
            });
            DynamicObject entityDy = mainElimClone.getDynamicObject("entity");
            PlatUtil.executeWithTX(tx -> {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(toMixElimTable.values().size());
                int showseq = 1;
                for (Row row : toMixElimTable.values()) {
                    Object[] param = new Object[]{entityDy.getLong("id"), mainElimClone.get("id"), String.format(ResManager.loadKDString((String)"\uff08\u6e90\u540d\u79f0 \uff1a %1$s ; \u6e90\u8bf4\u660e : %2$s\uff09", (String)"MixOperationTask_28", (String)"fi-bcm-business", (Object[])new Object[0]), row.getString("name"), row.getString("description")), ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(row.getString("entrysource")) ? ((Row)toMixElimTable.get((Object)ElimHeaderSourceEnum.SOURCE.getValue(), (Object)row.getLong("linkagelinksource"))).getString("number") : row.getString("number"), showseq++, row.getLong("id")};
                    pkList.add(row.getLong("id"));
                    paramsList.add(param);
                    this.addSuccessCount();
                }
                StringJoiner sqlBuilder = new StringJoiner(" ");
                sqlBuilder.add("update t_bcm_rptadjustdata set");
                sqlBuilder.add("fmergeid = ?").add(", ");
                sqlBuilder.add("fadjustid = ?").add(", ");
                sqlBuilder.add("fentrysource = case when fentrysource in ('1','3','5','7','8','0','10') then '3' else '4' end ").add(",");
                sqlBuilder.add("fdescription = concat(fdescription,?)").add(",");
                sqlBuilder.add("fgroupnum = concat(fgroupnum,concat('_',?))").add(",");
                sqlBuilder.add("fshowseq = ?");
                sqlBuilder.add("where fadjustid = ?");
                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sqlBuilder.toString(), paramsList);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainElimClone});
                DeleteServiceHelper.delete((String)"bcm_rptadjust", (QFilter[])new QFBuilder("id", "in", (Object)pkList).toArray());
                this.doSaveCopyAdjustPermClass(mainElimClone, this.getPermissionClassById(mainElim.getLong("id")));
                SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjustdata");
            });
            ThreadPoolService.runInThread(() -> {
                AdjustAttachmentHelper.moveAttachment(pkList.stream().map(Object::toString).collect(Collectors.toSet()), mainElimClone.getString("id"));
                PermClassEntityHelper.deleteEntities(pkList, this._ctx().getModelId());
            });
        }
    }

    private void doSaveCopyAdjustPermClass(DynamicObject elimClone, DynamicObject permClass) {
        if (permClass != null) {
            permClass.set("entityid", (Object)elimClone.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{permClass});
        }
    }

    private Table<String, Long, Row> queryAdjustElimData(Collection<Long> pkIds) {
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.add("number");
        selectFieldSet.add("status");
        selectFieldSet.add("name");
        selectFieldSet.add("description");
        selectFieldSet.add("linkagelinksource");
        selectFieldSet.add("entrysource");
        selectFieldSet.add("sourcetype");
        selectFieldSet.add("process");
        selectFieldSet.add("templatecatalog.id");
        selectFieldSet.addAll(checkSingleElimFieldSet);
        HashBasedTable link2pk2ElimTable = HashBasedTable.create();
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(selectFieldSet, new QFBuilder("id", "in", pkIds), null, -1);){
            while (ds.hasNext()) {
                AbstractRow row = ((AbstractRow)ds.next()).persist();
                link2pk2ElimTable.put((Object)row.getString("entrysource"), (Object)row.getLong("id"), (Object)row);
            }
        }
        return link2pk2ElimTable;
    }

    private HashMultimap<Long, Row> queryAdjustEntryData(QFBuilder qf) {
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.add("adjust");
        selectFieldSet.add("entrysource");
        selectFieldSet.add("entity.number");
        HashMultimap link2pk2EntryMap = HashMultimap.create();
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryDataSet(selectFieldSet, qf, null, -1);){
            while (ds.hasNext()) {
                AbstractRow row = ((AbstractRow)ds.next()).persist();
                link2pk2EntryMap.put((Object)row.getLong("adjust"), (Object)row);
            }
        }
        return link2pk2EntryMap;
    }

    private DynamicObject clearElim(DynamicObject newElim) {
        newElim.set("id", (Object)this.getIdDistributor().getLongId());
        newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
        newElim.set("creator", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bos_user", RequestContext.get().getCurrUserId()));
        newElim.set("createtime", (Object)TimeServiceHelper.now());
        newElim.set("modifier", (Object)AdjustQueryServiceHelper.loadSingle(this._ctx().getModelNum(), "bos_user", RequestContext.get().getCurrUserId()));
        newElim.set("modifytime", (Object)TimeServiceHelper.now());
        newElim.getDynamicObjectCollection("shareentry").clear();
        newElim.set("allshareorg", null);
        newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
        newElim.set("extend", null);
        newElim.set("extendfrom", null);
        newElim.set("submitter", null);
        newElim.set("submittime", null);
        newElim.set("cancelsubmitter", null);
        newElim.set("cancelsubmittime", null);
        newElim.set("ratifier", null);
        newElim.set("ratifytime", null);
        newElim.set("cancelratifier", null);
        newElim.set("cancelratifytime", null);
        newElim.set("reviewer", null);
        newElim.set("reviewtime", null);
        newElim.set("callbacker", null);
        newElim.set("callbacktime", null);
        newElim.set("spreadjson", null);
        newElim.set("data", null);
        newElim.set("checkstatus", (Object)RptAdjustCheckStatusEnum.NOTCHECKED.getStatus());
        newElim.set("iscontinuous", (Object)1);
        newElim.set("linkagelinksource", (Object)0L);
        newElim.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        newElim.set("checkrecord", null);
        newElim.getDynamicObjectCollection("shareentry").clear();
        return newElim;
    }

    @Override
    void addErrorOper(String msg) {
        super.addErrorOper(msg);
        this.isSuccess = false;
    }

    @Override
    public boolean isForceBatch() {
        return false;
    }
}

