/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOperationTask;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustApplicationLocker;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AbstractShareEntryTask;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckArchiveStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataSysToMDDValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOlapLockValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.shareOper.AdjustCommonShareTarCheckValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLockOperTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class SpiltShareOperationTask
extends AbstractShareEntryTask {
    private final AdjustApplicationLocker locker = new AdjustApplicationLocker(AdjustLockOperTypeEnum.CommonLocker);
    private IDNumberTreeNode mergeOrgNode;
    private List<IDNumberTreeNode> orgScope;
    private Map<String, String> orgCheckMsgMap;

    @Override
    protected void beforeDispose() {
        super.beforeDispose();
        this.mergeOrgNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)((Long)this.getUserDefineParam("mergeorg")));
        if (this.mergeOrgNode == IDNumberTreeNode.NotFoundTreeNode || this.mergeOrgNode.isLeaf()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005\u975e\u5408\u5e76\u8282\u70b9\u3002", (String)"SpiltShareOperationTask_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.orgScope = new ArrayList<IDNumberTreeNode>(this.mergeOrgNode.getAllChildren(1));
        Map<Long, String> effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(new FilterOrgStructParam(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId()), this.orgScope.stream().map(p -> p.getId()).collect(Collectors.toList()));
        this.orgScope.removeIf(p -> !effectiveOrg.containsKey(p.getId()));
        this.orgScope.add(this.mergeOrgNode);
    }

    @Override
    protected void onAddValidators(AdjustValidatorExecute e) {
        super.onAddValidators(e);
        e.addValidator(new AdjustCheckDataNotNullValidator());
        e.addValidator(new AdjustCheckDimMemValidator());
        e.addValidator(new AdjustCheckPermValidator().setSkipOrg());
        e.addValidator(new AdjustCheckDimMemValidator());
        e.addValidator(new AbstractValidator(){
            boolean isExistArchiving;

            @Override
            protected void beforeValidate() {
                super.beforeValidate();
                this.isExistArchiving = LockScopeServiceHelper.isExistArchiving(this.getCtx().getModelId(), this.getCtx().getScenariodNum(), this.getCtx().getFyNum(), this.getCtx().getPeriodNum());
                SpiltShareOperationTask.this.orgCheckMsgMap = SpiltShareOperationTask.this.prepareOrgCheckMsgMap();
            }

            @Override
            protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
                if (this.isExistArchiving) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u56e0\u4e3a\u5f53\u671f\u671f\u95f4\u5206\u9636\u6bb5\u65b9\u6848\u5df2\u5f52\u6863\u3002", (String)"SpiltShareOperationTask_16", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                String process = adjust.getString("process");
                if (ElimRptAdjSourceTypeEnum.LINK.getValue() == adjust.getInt("sourcetype")) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u5f55\u4e3a\u8054\u52a8\u5206\u5f55\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SpiltShareOperationTask_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (!OrgRelaProcessMembPool.isRelaProcess((String)process)) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5355\u4f53\u8fc7\u7a0b\u5206\u5f55\u4e0d\u652f\u6301\u6267\u884c\u62c6\u5206\u5171\u4eab\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (!RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5171\u4eab\u5ba1\u6838\u72b6\u6001\u7684\u8c03\u6574\u62b5\u9500\u3002", (String)"SpiltShareOperationTask_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                if (ElimHeaderSourceEnum.SHARE.getValue().equals(adjust.getString("entrysource")) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(adjust.getString("entrysource"))) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6e90\u8c03\u6574\u62b5\u9500\u8fdb\u884c\u5171\u4eab\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return;
                }
                long srcId = adjust.getLong("id");
                SpiltShareOperationTask.this.orgScope.stream().anyMatch(orgNode -> {
                    Long oldShareId = SpiltShareOperationTask.this.searchOldRelationId(srcId, orgNode.getNumber());
                    String msg = (String)SpiltShareOperationTask.this.orgCheckMsgMap.get(orgNode.getNumber());
                    if (oldShareId != null && oldShareId != 0L && StringUtils.isNotEmpty((CharSequence)msg)) {
                        this.addErrorMessage(adjust, msg);
                        return true;
                    }
                    return false;
                });
            }
        });
    }

    protected void onTarAddValidators(AdjustValidatorExecute e) {
        e.addValidator(new AdjustCheckArchiveStatusValidator());
        e.addValidator(new AdjustSceneVersionValidator());
        e.addValidator(new AdjustCheckDataSysToMDDValidator());
        e.addValidator(new AdjustCommonShareTarCheckValidator());
        e.addValidator(new AdjustCheckOlapLockValidator().setCheck(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(List<DynamicObject> adjustDys, Map<Long, List<DynamicObject>> adjustDataMap) {
        HashMap<Long, DynamicObject> oldAdjustHeaderMap = new HashMap<Long, DynamicObject>();
        HashMap newShareAdjustMap = new HashMap();
        HashMap newShareEntryMap = new HashMap();
        HashMap share2SrcMap = new HashMap();
        Set orgNumSset = this.orgScope.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        HashMultimap src2OldSharePkIds = HashMultimap.create();
        HashMap<Long, String> oldSharePk2OrgNumMap = new HashMap<Long, String>(16);
        for (DynamicObject adjust : adjustDys) {
            long adjustPkId = adjust.getLong("id");
            for (String mergeNum : orgNumSset) {
                Long oldSharePkId = this.searchOldRelationId(adjustPkId, mergeNum);
                if (oldSharePkId == null || oldSharePkId == 0L) continue;
                src2OldSharePkIds.put((Object)adjustPkId, (Object)oldSharePkId);
                oldSharePk2OrgNumMap.put(oldSharePkId, mergeNum);
            }
        }
        Map<Long, HashBasedTable<Long, Long, List<String>>> delLockScope = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u62c6\u5206\u5171\u4eab\uff08\u6253\u56de\u5386\u53f2\u5206\u5f55\uff09", (String)"SpiltShareOperationTask_6", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx(), src2OldSharePkIds.values(), null);
        for (DynamicObject adjust : adjustDys) {
            try {
                long adjustId = adjust.getLong("id");
                List<DynamicObject> entryList = adjustDataMap.get(adjustId);
                if (CollectionUtil.isEmpty(entryList) || src2OldSharePkIds.get((Object)adjustId).stream().anyMatch(sharePkId -> {
                    if (delLockScope.containsKey(sharePkId)) {
                        HashBasedTable detailTable = (HashBasedTable)delLockScope.get(sharePkId);
                        if (detailTable != null) {
                            if (detailTable.containsRow(sharePkId)) {
                                this.addErrorOper(String.format(ResManager.loadKDString((String)"%1$s : \u6e90\u5408\u5e76\u7ec4\u7ec7\u5728\u76ee\u6807\u7ec4\u7ec7%2$s\u7684\u5171\u4eab\u5206\u5f55\u5b58\u5728\u9501\u5b9a\u7684\u5206\u5f55\u884c\uff0c\u4e0d\u53ef\u62c6\u5206\u5171\u4eab\uff0c\u9501\u5b9a\u4fe1\u606f\u5982\u4e0b\uff1a%3$s\u3002", (String)"SpiltShareOperationTask_7", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), oldSharePk2OrgNumMap.get(sharePkId), detailTable.row(sharePkId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                            } else {
                                this.addErrorOper(String.format(ResManager.loadKDString((String)"%1$s : \u6e90\u5408\u5e76\u7ec4\u7ec7\u5728\u76ee\u6807\u7ec4\u7ec7%2$s\u7684\u5171\u4eab\u5206\u5f55\u7684\u8054\u52a8\u5206\u5f55\u5b58\u5728\u9501\u5b9a\u7684\u5206\u5f55\u884c\uff0c\u4e0d\u53ef\u62c6\u5206\u5171\u4eab\uff0c\u9501\u5b9a\u4fe1\u606f\u5982\u4e0b\uff1a%3$s\u3002", (String)"SpiltShareOperationTask_8", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), oldSharePk2OrgNumMap.get(sharePkId), detailTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                            }
                        }
                        return true;
                    }
                    return false;
                })) continue;
                IDNumberTreeNode srcMergeNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)DynUtils.getBaseId((DynamicObject)adjust, (String)"entity"));
                if (orgNumSset.contains(srcMergeNode.getNumber())) {
                    this.addErrorOper(String.format(ResManager.loadKDString((String)"%1$s : \u6e90\u5408\u5e76\u7ec4\u7ec7\u5728\u76ee\u6807\u7ec4\u7ec7\u67b6\u6784\u4e2d\u5b58\u5728\uff0c\u8be5\u5206\u5f55\u6570\u636e\u4e0d\u53ef\u62c6\u5206\u5171\u4eab\u3002", (String)"SpiltShareOperationTask_9", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number")));
                    continue;
                }
                Set childSet = srcMergeNode.getAllChildren(1).stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                Map<IDNumberTreeNode, List<DynamicObject>> groupMap = this.resolveCommonParentNode(adjust, entryList, this.mergeOrgNode);
                new HashSet<IDNumberTreeNode>(groupMap.keySet()).stream().filter(cpNode -> cpNode != IDNumberTreeNode.NotFoundTreeNode && !cpNode.getNumber().equals(this.mergeOrgNode.getNumber()) && childSet.contains(cpNode.getNumber())).forEach(cpNode -> {
                    List entrysList = (List)groupMap.remove(cpNode);
                    if (!CollectionUtil.isEmpty((Collection)entrysList)) {
                        this.addWarnOper(String.format(ResManager.loadKDString((String)"%1$s : \u5206\u7ec4%2$s\u62c6\u5206\u5171\u4eab\u540e\u7684\u5408\u5e76\u7ec4\u7ec7%3$s\u4e3a\u6e90\u5408\u5e76\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u5408\u5e76\uff0c\u5df2\u81ea\u52a8\u63d0\u5347\u5171\u4eab\u81f3\u6240\u9009\u5408\u5e76\u8282\u70b9\u4e0b\u3002", (String)"SpiltShareOperationTask_10", (String)"fi-bcm-business", (Object[])new Object[0]), adjust.getString("number"), ((DynamicObject)entrysList.get(0)).getString("groupnum"), cpNode.getNumber()));
                        groupMap.computeIfAbsent(this.mergeOrgNode, a -> Lists.newArrayList()).addAll(entrysList);
                    }
                });
                groupMap.forEach((cpNode, entrys) -> {
                    Pair<DynamicObject, List<DynamicObject>> newSharePair = this.shareEntry(adjust, (List<DynamicObject>)entrys, (IDNumberTreeNode)cpNode);
                    if (newSharePair != null) {
                        long newAdjustId = ((DynamicObject)newSharePair.p1).getLong("id");
                        newShareAdjustMap.put(newAdjustId, newSharePair.p1);
                        newShareEntryMap.put(newAdjustId, newSharePair.p2);
                        AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)((DynamicObject)newSharePair.p1), (Collection)((Collection)newSharePair.p2), (boolean)true);
                        share2SrcMap.put(newAdjustId, adjustId);
                    }
                });
                oldAdjustHeaderMap.put(adjustId, adjust);
            }
            catch (Throwable t) {
                this.addErrorOper(adjust.getString("number") + " : " + AdjustmentServiceHelper.toString_Adj(t));
            }
        }
        ArrayList deleteRelationIdList = new ArrayList(16);
        ArrayList<DynamicObject> newShareHeaderList = new ArrayList<DynamicObject>();
        ArrayList newShareEntryList = new ArrayList();
        OperationResult op = this.getTarValidator().excute((Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>)Pair.onePair(new ArrayList(newShareAdjustMap.values()), newShareEntryMap));
        HashSet srcPkIds = new HashSet();
        op.getSuccessPkIds().forEach(pkId -> {
            long srcPkId = (Long)share2SrcMap.get(pkId);
            DynamicObject oldAjustHeader = (DynamicObject)oldAdjustHeaderMap.get(srcPkId);
            DynamicObject newShareHeader = (DynamicObject)newShareAdjustMap.get(pkId);
            List newShareEntrys = (List)newShareEntryMap.get(pkId);
            AdjustConvertUtil.setAdjustDataShowSeq(newShareEntrys, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
            this.prepareInsertShareRelation(oldAjustHeader, newShareHeader);
            newShareHeaderList.add(newShareHeader);
            newShareEntryList.addAll(newShareEntrys);
            if (srcPkIds.add(srcPkId)) {
                this.addSuccessCount();
                for (String mergeNum : orgNumSset) {
                    Long oldSharePkId = this.searchOldRelationId(srcPkId, mergeNum);
                    if (oldSharePkId == null || oldSharePkId == 0L) continue;
                    deleteRelationIdList.add(oldSharePkId);
                }
            }
        });
        AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", newShareHeaderList);
        deleteRelationIdList.remove(null);
        deleteRelationIdList.remove(0L);
        PlatUtil.executeWithTXNew(tx -> this.batchDeleteOldShareRelation(deleteRelationIdList));
        PlatUtil.executeWithTXNew(tx -> {
            try {
                SaveServiceHelper.save((DynamicObject[])newShareHeaderList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])newShareEntryList.toArray(new DynamicObject[0]));
                this.batchUpdateNewShareRelation();
                newShareHeaderList.forEach(head -> this.locker.addPreparedLockKey(head.getString("id"), ResManager.loadKDString((String)"\u5171\u4eab\u9884\u5165\u5e93\u4e2d\uff0c\u8bf7\u52ff\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_11", (String)"fi-bcm-business", (Object[])new Object[0])));
                this.locker.batchRequest();
            }
            catch (Throwable t) {
                this.locker.batchRelease();
                throw t;
            }
        });
        try {
            PlatUtil.executeWithTXNew(tx -> AdjustCheckServiceHelper.doSysToMddSameProcess(this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId(), newShareHeaderList.stream().map(p -> p.getLong("id")).collect(Collectors.toList()), true));
        }
        finally {
            this.locker.batchRelease();
        }
        ThreadPoolService.runInThread(() -> this.updateAllShareOrg(adjustDys));
    }

    private Map<String, String> prepareOrgCheckMsgMap() {
        if (this.orgCheckMsgMap == null) {
            this.orgCheckMsgMap = new HashMap<String, String>(this.orgScope.size());
            boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(this._ctx().getModelId());
            List<Long> orgList = this.orgScope.stream().map(IDNumberTreeNode::getId).collect(Collectors.toList());
            Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(this._ctx().getModelId(), orgList, this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId());
            Set<String> periodStatusOpenOrgNum = ConfigServiceHelper.getBoolParam(this._ctx().getModelId(), "CM012") ? PeriodSettingHelper.batchSelectPeriodStatusOpen(this._ctx().getModelId(), this.orgScope.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet()), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId(), "entrystatus") : null;
            Set<Long> writePermSet = modelManage ? null : PermissionServiceImpl.getInstance(this._ctx().getModelId()).matchWritePermMembers(this._ctx().getSctx().getDimensionByNumber("Entity").getId(), "bcm_entitymembertree", orgList);
            for (IDNumberTreeNode orgNode : this.orgScope) {
                McStatus mcstatus = mcStatusMap.get(orgNode.getId());
                if (mcstatus != null) {
                    if (mcstatus.getArchive().isArchive()) {
                        this.orgCheckMsgMap.put(orgNode.getNumber(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5728\u667a\u80fd\u5408\u5e76\u4e2d\u5df2\u5f52\u6863\u3002", (String)"SpiltShareOperationTask_12", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
                        continue;
                    }
                    if (mcstatus.getFlow().isSubmit()) {
                        this.orgCheckMsgMap.put(orgNode.getNumber(), String.format(ResManager.loadKDString((String)"%s\u5728\u667a\u80fd\u5408\u5e76\u4e2d\u5bf9\u5e94\u7684\u72b6\u6001\u4e0d\u662f\u5904\u7406\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u4ee5\u53ca\u5ba1\u6838\u540e\u7684\u6253\u56de\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_13", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
                        continue;
                    }
                }
                if (periodStatusOpenOrgNum != null && !periodStatusOpenOrgNum.contains(orgNode.getNumber())) {
                    this.orgCheckMsgMap.put(orgNode.getNumber(), String.format(ResManager.loadKDString((String)"\u5f53\u524d%s\u7ec4\u7ec7\u8c03\u6574\u5206\u5f55\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_14", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
                    continue;
                }
                if (writePermSet == null || writePermSet.contains(orgNode.getId())) continue;
                this.orgCheckMsgMap.put(orgNode.getNumber(), String.format(ResManager.loadKDString((String)"\u5f53\u524d%s\u7ec4\u7ec7\u65e0\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SpiltShareOperationTask_15", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
            }
        }
        return this.orgCheckMsgMap;
    }
}

