/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOrgDisPatchTask;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustBatchCreateParam;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustBatchCreateCommonEntryOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.task.batchOrgDisPatchTask.AbstractOrgTask;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.invest.elimination.InvElimGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import org.apache.commons.lang3.StringUtils;

public class DetailOrgTask
extends AbstractOrgTask {
    private final StringBuilder msgHandler = new StringBuilder();
    private final Map<String, Pair<Integer, String>> tmpLog = new HashMap<String, Pair<Integer, String>>();

    public DetailOrgTask(AdjustOperationContext ctx, AdjustBatchCreateParam param, OrgTreeNode orgNode, AdjRecordLog log) {
        super(ctx, param, orgNode, log);
    }

    private boolean checkCanContinue() {
        if (this.getOrgNode() == null || this.getOrgNode().getParent() == null) {
            return false;
        }
        String orgPath = this.getOrgNode().getParent().getNumber().concat("!").concat(this.getOrgNode().getNumber());
        if (!PeriodSettingHelper.checkPeriodStatus(this.getCtx().getModelId(), this.getOrgNode().getNumber(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), "entrystatus")) {
            this.msgHandler.append(orgPath).append(ResManager.loadKDString((String)"\u751f\u6210\u81ea\u52a8\u5206\u5f55\u5931\u8d25\uff0c\u56e0\u4e3a\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"DetailOrgTask_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (LockScopeServiceHelper.isExistArchiving(this.getCtx().getModelId(), this.getCtx().getScenariodNum(), this.getCtx().getFyNum(), this.getCtx().getPeriodNum())) {
            this.msgHandler.append(ResManager.loadKDString((String)"\u751f\u6210\u81ea\u52a8\u5206\u5f55\u5931\u8d25\uff0c\u56e0\u4e3a\u5f53\u671f\u671f\u95f4\u5206\u9636\u6bb5\u65b9\u6848\u5df2\u5f52\u6863\u3002", (String)"DetailOrgTask_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        PermissionService permService = PermissionServiceImpl.getInstance(this.getCtx().getModelId());
        boolean isAllWritePerm = permService.isAllWritePerm(MemberReader.getDimensionIdByNum((long)this.getCtx().getModelId(), (String)"Entity"), DimensionServiceHelper.getDimMembEntityNumByDimNum("Entity"), Lists.newArrayList((Object[])new Long[]{this.getOrgNode().getId()}));
        if (!isAllWritePerm) {
            this.msgHandler.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u6743\u6216\u8005\u53ea\u8bfb\u4e0d\u80fd\u53c2\u4e0e\u751f\u6210\u81ea\u52a8\u5206\u5f55", (String)"DetailOrgTask_3", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        McStatus mc = McStatus.getMcStatus(this.getCtx().getModelId(), this.getOrgNode().getId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId());
        if (mc.getArchive().isArchive()) {
            this.msgHandler.append(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u72b6\u6001\u5df2\u5f52\u6863\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"DetailOrgTask_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (mc.getFlow().isSubmit()) {
            this.msgHandler.append(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u4e2d\u7ec4\u7ec7\u7684\u72b6\u6001\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"DetailOrgTask_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (MergeControlHelper.isQuoteLocked(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), this.getOrgNode().getId())) {
            this.msgHandler.append(AdjustSceneVersionValidator.packErrorMsg(this.getOrgNode().getNumber(), this.getCtx().getFyNum(), this.getCtx().getPeriodNum()));
            return false;
        }
        return true;
    }

    @Override
    public void excute() {
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        try {
            isSuccess.set(this.checkCanContinue());
            if (isSuccess.get()) {
                String orgNumLockKey = String.format("/DetailOrgTask/%s/%s/%s/%s/%s", this.getCtx().getModelNum(), this.getCtx().getScenariodNum(), this.getCtx().getFyNum(), this.getCtx().getPeriodNum(), this.getOrgNode().getNumber());
                this.tryLock(orgNumLockKey, e -> {
                    if (!this.getOrgNode().isLeaf()) {
                        this.excuteElimEntryDispatcher();
                    }
                    this.excuteAdjustDispatcher();
                });
                this.tmpLog.forEach((str, result) -> {
                    if ((Integer)result.p1 > 0) {
                        this.msgHandler.append(String.format(str, result.p1));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)result.p2))) {
                        if ((Integer)result.p1 < 1) {
                            this.msgHandler.append(String.format(str, 0));
                        }
                        this.msgHandler.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u4e3a\u201c%s\u201d\u3002", (String)"DetailOrgTask_6", (String)"fi-bcm-business", (Object[])new Object[0]), result.p2));
                        isSuccess.set(false);
                    }
                });
            }
        }
        catch (Throwable t) {
            this.msgHandler.append(AdjustmentServiceHelper.toString_Adj(t));
            isSuccess.set(false);
        }
        if (isSuccess.get()) {
            this.getLog().addSuccessCount();
            if (this.msgHandler.length() > 0) {
                this.msgHandler.insert(0, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6267\u884c\u60c5\u51b5\u5982\u4e0b\uff1a", (String)"DetailOrgTask_7", (String)"fi-bcm-business", (Object[])new Object[0]), this.getOrgNode().getNumber().concat("|").concat(this.getOrgNode().getName())));
                this.getLog().addWarningMsg(this.msgHandler.toString());
            }
        } else {
            this.msgHandler.insert(0, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u6267\u884c\u60c5\u51b5\u5982\u4e0b\uff1a", (String)"DetailOrgTask_7", (String)"fi-bcm-business", (Object[])new Object[0]), this.getOrgNode().getNumber().concat("|").concat(this.getOrgNode().getName())));
            this.getLog().addErrorMsg(this.msgHandler.toString());
        }
    }

    private void excuteElimEntryDispatcher() {
        if (this.getParam().isCreateElim()) {
            List<List<String>> elimProcess = MergeControlHelper.getUnitElimProcesses(this.getCtx().getModelId());
            for (List<String> process : elimProcess) {
                Pair<Integer, String> result;
                if (this.getParam().isCommonPaperSelected()) {
                    result = this.createCommonPaperEntries(1, process);
                    this.addPairResult(result, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u6765\u6e90\u4e8e\u666e\u901a\u5206\u5f55\u5e95\u7a3f\u7684\u62b5\u9500\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_8", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (this.getParam().isInvestTempSelected()) {
                    result = this.createInvEntries(1, process);
                    this.addPairResult(result, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u6765\u6e90\u4e8e\u6743\u76ca\u62b5\u9500\u6a21\u677f\u7684\u62b5\u9500\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_9", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (!this.getParam().isInvSheetPaperSelected()) continue;
                Pair<Integer, String> paperResult = this.createInvPaper(1, process);
                this.addPairResult(paperResult, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u4e2a\u62b5\u9500\u7c7b\u6743\u76ca\u5e95\u7a3f\u3002", (String)"DetailOrgTask_10", (String)"fi-bcm-business", (Object[])new Object[0]));
                Pair<Integer, String> resultStr = this.createInvPaperEntries(1, process);
                this.addPairResult(resultStr, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u4e2a\u6765\u6e90\u4e8e\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u7684\u62b5\u9500\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_11", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    private void excuteAdjustDispatcher() {
        if (this.getParam().isCreateAdjust()) {
            Pair<Integer, String> result;
            ThreadCache.put((Object)"all_in_one_thread_invest", (Object)true);
            if (this.getParam().isCommonPaperSelected()) {
                result = this.createCommonPaperEntries(2, null);
                this.addPairResult(result, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u6765\u6e90\u4e8e\u666e\u901a\u5206\u5f55\u5e95\u7a3f\u7684\u8c03\u6574\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_12", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (this.getParam().isInvestTempSelected()) {
                result = this.createInvEntries(2, null);
                this.addPairResult(result, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u6761\u6765\u6e90\u4e8e\u6743\u76ca\u62b5\u9500\u6a21\u677f\u7684\u8c03\u6574\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_13", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (this.getParam().isInvSheetPaperSelected()) {
                Pair<Integer, String> paperResult = this.createInvPaper(2, null);
                this.addPairResult(paperResult, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u4e2a\u8c03\u6574\u7c7b\u6743\u76ca\u5e95\u7a3f\u3002", (String)"DetailOrgTask_14", (String)"fi-bcm-business", (Object[])new Object[0]));
                Pair<Integer, String> resultStr = this.createInvPaperEntries(2, Collections.singletonList("ERAdj"));
                this.addPairResult(resultStr, ResManager.loadKDString((String)"\u5171\u751f\u6210%s\u4e2a\u6765\u6e90\u4e8e\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u7684\u8c03\u6574\u7c7b\u5206\u5f55\u3002", (String)"DetailOrgTask_15", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ThreadCache.remove((Object)"all_in_one_thread_invest");
        }
    }

    private void addPairResult(Pair<Integer, String> result, String key) {
        int count = Math.max(0, (Integer)result.p1);
        Pair<Integer, String> tmp = this.tmpLog.get(key);
        if (tmp == null) {
            this.tmpLog.put(key, (Pair<Integer, String>)Pair.onePair((Object)count, (Object)(result.p2 == null ? "" : ((String)result.p2).trim())));
        } else {
            ArrayList<Object> reStrList = new ArrayList<Object>();
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)tmp.p2))) {
                reStrList.add(tmp.p2);
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)result.p2))) {
                reStrList.add(((String)result.p2).trim());
            }
            this.tmpLog.put(key, (Pair<Integer, String>)Pair.onePair((Object)((Integer)tmp.p1 + count), (Object)String.join((CharSequence)",", reStrList)));
        }
    }

    private Pair<Integer, String> createInvEntries(int elimTemplateType, List<String> process) {
        InvElimGenerateService service;
        DynamicObject orgDy = OrgCurrencyServiceHelper.getOrgModelAndCurrency(this.getOrgNode().getId(), (Long)this.getCtx().getFyId(), (Long)this.getCtx().getPeriodId());
        Set<Long> investedTemplateIds = this.getParam().getInvestedTemplateIds();
        if (elimTemplateType == 2) {
            DynamicObject unit = OrgCurrencyServiceHelper.getParentOrgModelAndCurrency(this.getOrgNode().getId(), this.getCtx().getFyId(), this.getCtx().getPeriodId());
            IDNumberTreeNode parent = this.getOrgNode().getParent();
            Long orgId = parent.getId();
            if ("Entity".equals(parent.getNumber())) {
                orgId = this.getOrgNode().getId();
            }
            service = new InvElimGenerateService(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), orgId, this.getCtx().getCslId(), true, investedTemplateIds);
            service.addUnitCurrency(unit.getString("currency.number"), unit.getLong("currency.id")).setElimTemplateType(2);
            service.setDetailEntity((Pair<Long, String>)Pair.onePair((Object)this.getOrgNode().getId(), (Object)this.getOrgNode().getNumber()));
            service.setDetailEntityCurrency((Pair<Long, String>)Pair.onePair((Object)orgDy.getLong("currency.id"), (Object)orgDy.getString("currency.number")));
        } else {
            IDNumberTreeNode org = this.getOrgNode();
            service = new InvElimGenerateService(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), org.getId(), this.getCtx().getCslId(), true, investedTemplateIds);
            service.addUnitCurrency(orgDy.getString("currency.number"), orgDy.getLong("currency.id")).setElimTemplateType(1);
            service.setSpecifiedProcess(process);
            service.setDetailEntity((Pair<Long, String>)Pair.onePair((Object)this.getOrgNode().getId(), (Object)this.getOrgNode().getNumber()));
        }
        return service.generate();
    }

    private Pair<Integer, String> createInvPaper(int elimTemplateType, List<String> process) {
        IDNumberTreeNode org = this.getOrgNode();
        InvElimPaperGenerateService paperGenService = new InvElimPaperGenerateService((Long)this.getCtx().getModelId(), (Long)this.getCtx().getScenarioId(), (Long)this.getCtx().getFyId(), (Long)this.getCtx().getPeriodId(), org.getId(), InvLimSheetLogConstant.Operation.GENERATE_ADJUST);
        paperGenService.setSpecifiedProcess(process);
        paperGenService.setElimTemplateType(elimTemplateType);
        return paperGenService.generatePaper();
    }

    private Pair<Integer, String> createInvPaperEntries(int elimTemplateType, List<String> process) {
        IDNumberTreeNode org = this.getOrgNode();
        InvElimSpreadGenerateService elimGenService = new InvElimSpreadGenerateService(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), org.getId());
        elimGenService.setSpecifiedProcess(process);
        Tuple<Integer, Set<Long>, String> result = elimGenService.generate();
        return new Pair(result.p1, result.p3);
    }

    private Pair<Integer, String> createCommonPaperEntries(int elimTemplateType, List<String> process) {
        Set<Long> commonPaperIds = this.getParam().getCommonPaperIds();
        AdjustBatchCreateCommonEntryOperation commonEntryOperation = new AdjustBatchCreateCommonEntryOperation(this.getCtx(), this.getOrgNode().getId(), commonPaperIds);
        commonEntryOperation.setElimTemplateType(elimTemplateType);
        if (elimTemplateType == 1) {
            commonEntryOperation.setSpecifiedProcess(process);
        }
        return commonEntryOperation.generate();
    }
}

