/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.batchOrgDisPatchTask;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.cache.ThreadCache;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.model.AdjustBatchCreateParam;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.task.batchOrgDisPatchTask.AbstractOrgTask;
import kd.fi.bcm.business.adjust.task.batchOrgDisPatchTask.DetailOrgTask;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;

public class UnitOrgTask
extends AbstractOrgTask {
    public UnitOrgTask(AdjustOperationContext ctx, AdjustBatchCreateParam param, OrgTreeNode orgTreeNode, AdjRecordLog log) {
        super(ctx, param, orgTreeNode, log);
    }

    @Override
    public void excute() {
        if (this.getOrgTreeNode() == null) {
            return;
        }
        if (this.getParam().getScope() != 1 && !CollectionUtils.isEmpty(this.getOrgTreeNode().getChildren())) {
            List orgNodeList = this.getOrgTreeNode().getChildren();
            CountDownLatch latch = new CountDownLatch(orgNodeList.size());
            for (ITreeNode childOrgNode : orgNodeList) {
                IDNumberTreeNode child = MemberReader.findEntityMemberById((String)this.getCtx().getModelNum(), (Long)LongUtil.toLong((Object)childOrgNode.getId()));
                this.excuteTaskInThread(child, () -> {
                    try {
                        if (IDNumberTreeNode.NotFoundTreeNode != child) {
                            if (child.isLeaf()) {
                                new DetailOrgTask(this.getCtx(), this.getParam(), (OrgTreeNode)childOrgNode, this.getLog()).excute();
                            } else {
                                new UnitOrgTask(this.getCtx(), this.getParam(), (OrgTreeNode)childOrgNode, this.getLog()).excute();
                            }
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        new DetailOrgTask(this.getCtx(), this.getParam(), this.getOrgTreeNode(), this.getLog()).excute();
    }

    private void excuteTaskInThread(IDNumberTreeNode child, Runnable runnable) {
        if (IDNumberTreeNode.NotFoundTreeNode == child) {
            return;
        }
        String processId = ThreadCache.get((Object)"cache_node_prefix") + "";
        if (child.isLeaf()) {
            ThreadPoolService.runInAdjustDetailTaskThread(() -> {
                ThreadCache.put((Object)"cache_node_prefix", (Object)processId);
                runnable.run();
            });
        } else {
            boolean isSycn = this.checkOverThreshold(child.getParent());
            if (isSycn) {
                this.getCtx().getUsetObjectFromCache("isSycn_" + child.getNumber(), () -> Boolean.TRUE);
            } else {
                isSycn = this.checkOverThreshold(child);
            }
            if (isSycn) {
                ThreadPoolService.runInAdjustUnitWaitingThread(() -> {
                    ThreadCache.put((Object)"cache_node_prefix", (Object)processId);
                    runnable.run();
                });
            } else {
                runnable.run();
            }
        }
    }

    private boolean checkOverThreshold(IDNumberTreeNode orgNode) {
        return (Boolean)this.getCtx().getUsetObjectFromCache("isSycn_" + orgNode.getNumber(), () -> (double)orgNode.getAllChildren(1).size() < (double)ThreadPoolService.getCurrentMaxThreadPool("pool_name_adjustunitwaiting", ThreadPoolService.pool_AdjustUnitWaiting_MaxThread) * 0.3);
    }
}

