/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.platDisPatchJobTask;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AdjustBelongOrgUpTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AdjustBelongOrgUpTask.class);
    private static final String LOADING_MESSAGE = "dealing...";

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, LOADING_MESSAGE, null);
        if (this.isStop()) {
            this.stop();
        }
        String message = null;
        Boolean success = Boolean.TRUE;
        try {
            if (this.isStop()) {
                this.stop();
            }
            Long modelId = (Long)params.get("modelId");
            Collection yearIds = (Collection)params.get("yearIds");
            Collection periodIds = (Collection)params.get("periodIds");
            Collection scenarioIds = (Collection)params.get("scenarioIds");
            if (!(CollectionUtils.isEmpty((Collection)yearIds) || CollectionUtils.isEmpty((Collection)periodIds) || CollectionUtils.isEmpty((Collection)scenarioIds))) {
                int totalSize = yearIds.size() * periodIds.size() * scenarioIds.size();
                int ac = 1;
                for (Long yearId : yearIds) {
                    for (Long sceneId : scenarioIds) {
                        for (Long periodId : periodIds) {
                            AdjustOperationContext _ctx = new AdjustOperationContext(modelId, sceneId, yearId, periodId);
                            String groupId = Joiner.on((String)"|").join((Object)"repairAdjustBelongOrg", (Object)_ctx.getModelNum(), new Object[]{_ctx.getScenariodNum(), _ctx.getPeriodNum(), _ctx.getFyNum()});
                            PlatUtil.tryDLock(groupId, "repairAdjustBelongOrg", false, 1, dc -> {
                                try {
                                    DynamicObject[] adjustDys;
                                    HashMap pkId2BelongOrgMap = new HashMap(16);
                                    try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryByBelongOrg(modelId, sceneId, yearId, periodId, null, Collections.singleton(AdjustQueryServiceHelper.queryBelongOrgIdFieldStr), null, null, false);){
                                        ds.forEachRemaining(row -> pkId2BelongOrgMap.computeIfAbsent(row.getLong("adjust"), a -> new ArrayList(3)).add(row.getLong("queryBelongOrg")));
                                    }
                                    QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
                                    qf.add("scenario", "=", (Object)sceneId);
                                    qf.add("year", "=", (Object)yearId);
                                    qf.add("period", "=", (Object)periodId);
                                    for (DynamicObject adjust : adjustDys = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"entity,process,belongorg,id,belongorglist.belongorgmem", (QFilter[])qf.toArray())) {
                                        AdjustRepairDataServiceHelper.repairHeadBelongOrgList((DynamicObject)adjust, (Collection)((Collection)pkId2BelongOrgMap.get(adjust.getLong("id"))), (boolean)false);
                                    }
                                    PlatUtil.executeWithTXNew(tx -> SaveServiceHelper.save((DynamicObject[])adjustDys));
                                }
                                catch (Throwable t) {
                                    logger.error(ResManager.loadKDString((String)"repairAdjustBelongOrg\u5347\u7ea7\u5931\u8d25\uff1a", (String)"AdjustBelongOrgUpTask_1", (String)"fi-bcm-business", (Object[])new Object[0]), t);
                                }
                            });
                            this.feedbackProgress(++ac / totalSize * 100, LOADING_MESSAGE, null);
                        }
                    }
                }
                SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
            }
        }
        catch (Exception e) {
            message = ThrowableHelper.toString((Exception)e);
            success = Boolean.FALSE;
            logger.error((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", success);
        result.put("message", message);
        this.feedbackCustomdata(result);
    }
}

