/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.task.platDisPatchJobTask;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AdjustOlapOrgUpGradleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AdjustOlapOrgUpGradleTask.class);
    private static final String LOADING_MESSAGE = "dealing...";

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, LOADING_MESSAGE, null);
        if (this.isStop()) {
            this.stop();
        }
        String message = null;
        Boolean success = Boolean.TRUE;
        try {
            if (this.isStop()) {
                this.stop();
            }
            Long modelId = (Long)params.get("modelId");
            Collection yearIds = (Collection)params.get("yearIds");
            Collection periodIds = (Collection)params.get("periodIds");
            Collection scenarioIds = (Collection)params.get("scenarioIds");
            if (!(CollectionUtils.isEmpty((Collection)yearIds) || CollectionUtils.isEmpty((Collection)periodIds) || CollectionUtils.isEmpty((Collection)scenarioIds))) {
                int totalSize = yearIds.size() * periodIds.size() * scenarioIds.size();
                int ac = 1;
                for (Long yearId : yearIds) {
                    for (Long scenarioId : scenarioIds) {
                        for (Long periodId : periodIds) {
                            AdjustCheckServiceHelper.updateOlapOrgNumUpStatus(modelId, scenarioId, yearId, periodId);
                            this.feedbackProgress(++ac / totalSize * 100, LOADING_MESSAGE, null);
                        }
                    }
                }
                SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
                SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjustdata");
            }
        }
        catch (Exception e) {
            message = ThrowableHelper.toString((Exception)e);
            success = Boolean.FALSE;
            logger.error((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", success);
        result.put("message", message);
        this.feedbackCustomdata(result);
    }
}

