/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.trace;

import java.util.Collection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.business.adjust.trace.impl.AdjustDimOperationTraceLogImpl;
import kd.fi.bcm.business.adjust.trace.impl.RedisTraceLogImpl;

public class TraceLogUtil {
    public static TraceLog getLogInstance(String logType) {
        switch (logType) {
            case "redis": {
                return RedisTraceLogImpl.get();
            }
            case "adjustrecompute": {
                return AdjustDimOperationTraceLogImpl.get();
            }
        }
        return RedisTraceLogImpl.get();
    }

    public static <T> T queryLogDetail(String logType, String logId) {
        return TraceLogUtil.getLogInstance(logType).queryLogDetail(logId);
    }

    public static void set(TraceLog log) {
        if (log instanceof RedisTraceLogImpl) {
            RedisTraceLogImpl.set((RedisTraceLogImpl)log);
        } else if (log instanceof AdjustDimOperationTraceLogImpl) {
            AdjustDimOperationTraceLogImpl.set((AdjustDimOperationTraceLogImpl)log);
        }
    }

    public static void showRedisLogDetail(IFormView view) {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_investracemsg");
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        formparam.setCustomParam("traceid", (Object)TraceLogUtil.getLogInstance("redis").getTraceId());
        formparam.setCustomParam("logType", (Object)TraceLogUtil.getLogInstance("redis").getLogType());
        view.showForm(formparam);
    }

    public static String packDimIndexKey(Collection<String> dimensionNumSet) {
        return String.join((CharSequence)",", dimensionNumSet.toArray(new String[0]));
    }
}

