/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.trace.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheLoader;
import kd.bos.context.RequestContext;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustDimOperationTraceLogImpl
implements TraceLog {
    private static final ThreadLocal<AdjustDimOperationTraceLogImpl> tl = ThreadLocals.create(AdjustDimOperationTraceLogImpl::new);
    private String specialSourceKey;
    private long modelId;
    private long sceneId;
    private long yearId;
    private long periodId;
    private List<String> dimKeys;
    private AdjustOperTypeEnum operTypeEnum;
    private final Map<String, Object> logQueueMap = new ConcurrentHashMap<String, Object>();

    public static AdjustDimOperationTraceLogImpl get() {
        return tl.get();
    }

    @Override
    public <T> void addTag(String key, CacheLoader<T> loader) {
        this.addTag(key, loader, true);
    }

    public static void set(AdjustDimOperationTraceLogImpl traceLog) {
        tl.set(traceLog);
    }

    @Override
    public <T> void addTag(String key, CacheLoader<T> loader, boolean isPutCache) {
        if (isPutCache) {
            Object val = loader.load();
            if (val == null) {
                val = "null";
            } else if (val instanceof BigDecimal) {
                val = ((BigDecimal)val).stripTrailingZeros().toPlainString();
            }
            this.logQueueMap.put(key, val);
        }
    }

    @Override
    public void publish() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTraceId()) && !this.logQueueMap.isEmpty()) {
            MQCommonPublisher.publishAdjustDimOperationLog((long)this.modelId, (long)this.sceneId, (long)this.yearId, (long)this.periodId, (AdjustOperTypeEnum)this.operTypeEnum, (Map)MapInitHelper.ofMap((Object)"dimKeys", this.dimKeys, (Object)"logQueueMap", this.logQueueMap, (Object)"specialSourceKey", (Object)this.specialSourceKey));
            this.logQueueMap.clear();
        }
        tl.remove();
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public void setSceneId(long sceneId) {
        this.sceneId = sceneId;
    }

    public void setYearId(long yearId) {
        this.yearId = yearId;
    }

    public void setDimKeys(List<String> dimKeys) {
        this.dimKeys = dimKeys;
    }

    public void setOperTypeEnum(AdjustOperTypeEnum operTypeEnum) {
        this.operTypeEnum = operTypeEnum;
    }

    public void setSpecialSourceKey(String specialSourceKey) {
        this.specialSourceKey = specialSourceKey;
    }

    @Override
    public String getLogType() {
        return "adjustrecompute";
    }

    @Override
    public String getTraceId() {
        return RequestContext.get().getTraceId();
    }

    public List<String> getDimKeys() {
        return this.dimKeys;
    }

    @Override
    public void close() {
        tl.remove();
    }
}

