/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.trace.impl;

import kd.bos.cache.CacheLoader;
import kd.bos.context.RequestContext;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.business.adjust.trace.impl.RedisTraceLogInfo;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class RedisTraceLogImpl
implements TraceLog {
    private static final ThreadLocal<RedisTraceLogImpl> tl = ThreadLocals.create(RedisTraceLogImpl::new);
    private final String traceId;
    private volatile RedisTraceLogInfo redisTraceLog = RedisTraceLogInfo.getInstance();

    public static RedisTraceLogImpl get() {
        return tl.get();
    }

    private RedisTraceLogImpl() {
        this.traceId = RequestContext.getOrCreate().getTraceId();
    }

    @Override
    public <T> void addTag(String key, CacheLoader<T> loader) {
        this.addTag(key, loader, WatchLoggerUtil.isDebug());
    }

    public static void set(RedisTraceLogImpl traceLog) {
        tl.set(traceLog);
    }

    @Override
    public <T> void addTag(String key, CacheLoader<T> loader, boolean isPutCache) {
        if (isPutCache) {
            this.put(key, loader.load());
        }
    }

    private <T> void put(String key, T value) {
        this.redisTraceLog.addTag(key, value);
    }

    @Override
    public <T> T queryLogDetail(String traceId) {
        String redisCacheKey = "RedisTraceLogImpl_" + traceId;
        Object value = AppCacheServiceHelper.get(redisCacheKey);
        if (value != null) {
            AppCacheServiceHelper.remove(redisCacheKey);
        }
        return (T)value;
    }

    @Override
    public void publish() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTraceId()) && !this.redisTraceLog.isEmpty()) {
            AppCacheServiceHelper.put("RedisTraceLogImpl_" + this.getTraceId(), ObjectSerialUtil.compress4GZip((String)this.redisTraceLog.toString()), 3600);
        }
    }

    @Override
    public String getLogType() {
        return "redis";
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public void close() {
        this.publish();
        tl.remove();
    }
}

