/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.trace.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.context.RequestContext;

class RedisTraceLogInfo {
    private volatile Map<Object, ConcurrentLinkedQueue<String>> logQueueMap = new ConcurrentHashMap<Object, ConcurrentLinkedQueue<String>>();

    RedisTraceLogInfo() {
    }

    public static RedisTraceLogInfo getInstance() {
        return new RedisTraceLogInfo();
    }

    public <T> void addTag(String key, T value) {
        this.logQueueMap.computeIfAbsent(RequestContext.getOrCreate().getTraceId(), a -> new ConcurrentLinkedQueue()).add(key + " [" + value + "] ");
    }

    public String toString() {
        return JSON.toJSONString(this.logQueueMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.logQueueMap.isEmpty();
    }
}

