/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;

public class AdjustBusinessTypeUtil {
    private static Map<String, String> businessTypeMap = AdjustBusinessTypeUtil.buildBusinessTypeMap();

    public static String getBusinessTypeByProcess(String process) {
        return businessTypeMap.get(process);
    }

    private static Map<String, String> buildBusinessTypeMap() {
        HashMap<String, String> businessTypeMap = new HashMap<String, String>(16);
        businessTypeMap.put("IRpt", BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName());
        businessTypeMap.put("CS", BusinessTypeEnum.ADJUSTCROSSLEVEL.getName());
        businessTypeMap.put("DADJ", BusinessTypeEnum.ADJUSTSELFLEVEL.getName());
        businessTypeMap.put("DEJE", BusinessTypeEnum.OFFSETSELFLEVEL.getName());
        businessTypeMap.put("ADJ", BusinessTypeEnum.ADJUSTSUBLEVEL.getName());
        businessTypeMap.put("EJE", BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName());
        businessTypeMap.put("EICA", BusinessTypeEnum.OFFSETEICA.getName());
        businessTypeMap.put("EIT", BusinessTypeEnum.OFFSETEIT.getName());
        businessTypeMap.put("EOE", BusinessTypeEnum.OFFSETEOE.getName());
        businessTypeMap.put("ECF", BusinessTypeEnum.OFFSETECF.getName());
        businessTypeMap.put("EOther", BusinessTypeEnum.OFFSETEOther.getName());
        businessTypeMap.put("CCADJ", BusinessTypeEnum.ADJUSTCONTRIBUTIONLEVEL.getName());
        businessTypeMap.put("CADJ", BusinessTypeEnum.ADJUSTLAYERLEVEL.getName());
        businessTypeMap.put("CCADJ", BusinessTypeEnum.ADJUSTCONTRIBUTIONLEVEL.getName());
        businessTypeMap.put("EJE", BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName());
        businessTypeMap.put("CADJ", BusinessTypeEnum.ADJUSTLAYERLEVEL.getName());
        businessTypeMap.put("ADJ", BusinessTypeEnum.ADJUSTSUBLEVEL.getName());
        businessTypeMap.put("RAdj", BusinessTypeEnum.RADJ.getName());
        businessTypeMap.put("ERAdj", BusinessTypeEnum.EADJ.getName());
        businessTypeMap.put("DADJ", BusinessTypeEnum.ADJUSTSELFLEVEL.getName());
        businessTypeMap.put("DEJE", BusinessTypeEnum.OFFSETSELFLEVEL.getName());
        return businessTypeMap;
    }

    public static Map<String, String> getBizType(long modelId) {
        LinkedHashMap<String, String> bizType = new LinkedHashMap<String, String>(16);
        JSONArray bizTypeConfig = ConfigServiceHelper.getConfigCM005(modelId);
        if (bizTypeConfig != null) {
            bizTypeConfig.forEach(e -> {
                JSONObject entry = (JSONObject)e;
                bizType.put(entry.getString("businesstypevalue"), LocaleString.fromMap((Map)((Map)entry.get((Object)"showname"))).getLocaleValue());
            });
        }
        return bizType;
    }

    public static Map<String, String> getBizType(long modelId, boolean isShow) {
        JSONArray bizTypeConfig = ConfigServiceHelper.getConfigCM005(modelId);
        HashMap<String, String> bizType = new HashMap<String, String>();
        bizTypeConfig.forEach(e -> {
            JSONObject entry = (JSONObject)e;
            if (isShow && entry.getBoolean("isshow").booleanValue()) {
                bizType.put(entry.getString("businesstypevalue"), LocaleString.fromMap((Map)((Map)entry.get((Object)"showname"))).getLocaleValue());
            }
        });
        return bizType;
    }

    public static List<ComboItem> getConfigCM005ComboEditList(long modelId, boolean isOrgLeaf, boolean isCheckOpen) {
        if (modelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList comboEditList = Lists.newArrayList();
        JSONArray bizTypeConfig = ConfigServiceHelper.getConfigCM005(modelId);
        Predicate<JSONObject> isShowPre = entryTemp -> {
            boolean isShow;
            String businesstypevalue = entryTemp.getString("businesstypevalue");
            boolean bl = isShow = !isCheckOpen || entryTemp.getBoolean("isshow") != false;
            if (isOrgLeaf) {
                isShow &= BusinessTypeEnum.EADJ.getName().equals(businesstypevalue) || BusinessTypeEnum.RADJ.getName().equals(businesstypevalue);
            }
            return isShow;
        };
        bizTypeConfig.forEach(entry -> {
            JSONObject entryTemp = (JSONObject)entry;
            if (isShowPre.test(entryTemp)) {
                comboEditList.add(new ComboItem(LocaleString.fromMap((Map)((Map)entryTemp.get((Object)"showname"))), entryTemp.getString("businesstypevalue")));
            }
        });
        return comboEditList;
    }

    public static JSONArray repairConfigCM005(long modelId, JSONArray bizTypeConfig) {
        if (bizTypeConfig == null) {
            bizTypeConfig = new JSONArray();
        }
        Set<String> noContainsPr = AdjustBusinessTypeUtil.getNoContainsBizTypeList(modelId);
        HashSet existPr = new HashSet(16);
        bizTypeConfig.removeIf(p -> {
            JSONObject json = (JSONObject)p;
            String bizType = json.getString("businesstypevalue");
            existPr.add(bizType);
            return noContainsPr.contains(bizType);
        });
        for (BusinessTypeEnum p2 : BusinessTypeEnum.values()) {
            if (existPr.contains(p2.getName()) || noContainsPr.contains(p2.getName())) continue;
            JSONObject json = new JSONObject();
            json.put("isshow", (Object)true);
            json.put("presetname", (Object)p2.getTextLocale());
            json.put("showname", (Object)p2.getTextLocale());
            json.put("entrydescription", (Object)p2.getDescriptionLocale());
            json.put("businesstypevalue", (Object)p2.getName());
            bizTypeConfig.add((Object)json);
        }
        return bizTypeConfig;
    }

    private static Set<String> getNoContainsBizTypeList(long modelId) {
        HashSet<String> noContainsPr = new HashSet<String>(16);
        noContainsPr.add(BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.ADJUSTCROSSLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.PADJ.getName());
        IDNumberTreeNode eje = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EJE");
        if (eje.isLeaf()) {
            noContainsPr.add(BusinessTypeEnum.OFFSETEICA.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEIT.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOE.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETECF.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOther.getName());
        } else {
            noContainsPr.add(BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName());
        }
        return noContainsPr;
    }
}

